/* USER CODE BEGIN Header */
/**
  ******************************************************************************
  * @file           : main.c
  * @brief          : Main program body
  ******************************************************************************
  * @attention
  *
  * <h2><center>&copy; Copyright (c) 2020 STMicroelectronics.
  * All rights reserved.</center></h2>
  *
  * This software component is licensed by ST under BSD 3-Clause license,
  * the "License"; You may not use this file except in compliance with the
  * License. You may obtain a copy of the License at:
  *                        opensource.org/licenses/BSD-3-Clause
  *
  ******************************************************************************
  */
/* USER CODE END Header */

/* Includes ------------------------------------------------------------------*/
#include "main.h"
#include "usart.h"
#include "gpio.h"

#include "delay.h"
#include "myiic.h"
#include "ht16c23.h"
#include "oled0561.h"
#include "key.h"
#include "flash.h"
#include "led.h"


extern u8 Usart1_rxFLag;
//extern u16 cnter;
extern u16 SendDelay_Counter;


extern uint8_t rsRxBuf[USART1_TX_BUFSIZE];

int Addr_ID=0;


/**
  * @brief  The application entry point.
  * @retval int
  */
int main(void)
{
	SystemInit();
	delay_init();
	LEDInit();
	TIM3_Init();//ʱ
	KEY_Init();//ʼ
  	MX_GPIO_Init();//ʼ
	USART1_Init();
	init_ht16c23();//ʾʼ
  while (1)
  { 
		LEDHandle();

		if(SendDelay_Counter>=50)
		{
			SendDelay_Counter=0;
			requestData();
			delay_ms(5);
		}

		ExistRXInformation();

		keyHandle();

		if(KEY2_ENTER == 0)
			displayPageInformation(MENUnum, &DataStruc); //ʾ

		else if(KEY2_ENTER > 0 )
			displaySettingPage(); //ʾ	
  }
}


/*
*********************************************************************************************************
*	  :  void displayPageInformation()
*	˵: ʾnҳ
*	    ΣpageNum ҳ unitNum λ
*	  ֵ: 
*********************************************************************************************************
*/
void displayPageInformation(u8 pageNum,DataStructure* data)
 {
	float	temp[3]={0};
	float	tempP[4]={0};
	float   tempsingle=0;
	 
	switch(pageNum)
	{
		//ѹ+
		case PAGE0:
			displayDIDO(&data->di1State);
			JudgeMinus(&data->ua,3);
			displayCtnum(pageNum);
			ht16c23_write_one_byte2ram(0x22,0x55);   // "|""_"D1
			ht16c23_write_one_byte2ram(0x23,0x41);   //"""_"
			ht16c23_write_one_byte2ram(0x24,0x28);   // "|"
			displayLoadRatio(&data->loadRatio);//ֵ		
			displayPowerData(&data->kwhttli); //"ʾ" "" "load"		
			if(data->ua <= 999.99f && data->ub <= 999.99f && data->uc <= 999.99f)
			{	
				if(data->ua<0)
					temp[0]=data->ua*-1;
				else
					temp[0]=data->ua;
				if(data->ub<0)
					temp[1]=data->ub*-1;
				else
					temp[1]=data->ub;
				if(data->uc<0)
					temp[2]=data->uc*-1;
				else
					temp[2]=data->uc;
				displayUIData(&temp[0]);
				if(DataStruc.ctnum!=CTNUM_TWO)
				{
					ht16c23_write_one_byte2ram(0x0b,0x10);   //V
					ht16c23_write_one_byte2ram(0x15,0x20);   //V
					ht16c23_write_one_byte2ram(0x16,0x08);   //V
				}
				else
				{
					ht16c23_write_one_byte2ram(0x0b,0x10);   //V
					ht16c23_write_one_byte2ram(0x15,0x20);   //V				
				}
			}
			else
			{	
				temp[0]=data->ua/1000.0f;
				temp[1]=data->ub/1000.0f;
				temp[2]=data->uc/1000.0f;
				displayUIData(&temp[0]);
				if(DataStruc.ctnum!=CTNUM_TWO)
				{
					ht16c23_write_one_byte2ram(0x0a,0x20);   //K				
					ht16c23_write_one_byte2ram(0x0b,0x11);   //K				
					ht16c23_write_one_byte2ram(0x15,0x30);   //V K					
					ht16c23_write_one_byte2ram(0x16,0x08);   //V
				}
				else
				{
					ht16c23_write_one_byte2ram(0x0a,0x20);   //K	 					
					ht16c23_write_one_byte2ram(0x15,0x30);   //V K
					ht16c23_write_one_byte2ram(0x0b,0x10);   //V						
				}
			}
			break;
		//
		case PAGE1: 
			displayDIDO(&data->di1State);
			JudgeMinus(&data->ia,3);
			displayCtnum(pageNum);
			ht16c23_write_one_byte2ram(0x22,0x41);   //"I"
			ht16c23_write_one_byte2ram(0x23,0x5b);   //ݺ"I"
			ht16c23_write_one_byte2ram(0x24,0x02);   //"I"
			displayLoadRatio(&data->loadRatio);//ֵ
			displayPowerData(&data->kwhttli);//"ʾ" "" "load"
			if(data->ia<=999.99&&data->ib<=999.99&&data->ic<=999.99)
			{
				displayUIData(&data->ia);
				if(DataStruc.ctnum!=CTNUM_TWO)
				{
					ht16c23_write_one_byte2ram(0x0b,0x20);	//A
					ht16c23_write_one_byte2ram(0x16,0x24);	//A A
				}
				else
				{
					ht16c23_write_one_byte2ram(0x0b,0x20);	//A
					ht16c23_write_one_byte2ram(0x16,0x20);	//A A					
				}
			}
			else
			{
				temp[0]=data->ia/1000.0f;
				temp[1]=data->ib/1000.0f;
				temp[2]=data->ic/1000.0f;
				displayUIData(&temp[0]);
				if(DataStruc.ctnum!=CTNUM_TWO)
				{
					ht16c23_write_one_byte2ram(0x0a,0x20);   //K
					ht16c23_write_one_byte2ram(0x0b,0x21);	//A
					ht16c23_write_one_byte2ram(0x15,0x10);	//KA KA
					ht16c23_write_one_byte2ram(0x16,0x24);	//KA KA
				}
				else
				{
					ht16c23_write_one_byte2ram(0x0a,0x20);   //K
					ht16c23_write_one_byte2ram(0x0b,0x20);	//A
					ht16c23_write_one_byte2ram(0x15,0x10);	//KA KA
					ht16c23_write_one_byte2ram(0x16,0x20);	//KA 					
				}

			}
			break;	
		//й
		case PAGE2: 			
			displayDIDO(&data->di1State);
			JudgeMinus(&data->pa,4);
			displayCtnum(pageNum);
			ht16c23_write_one_byte2ram(0x22,0x0d);   //"P"
			ht16c23_write_one_byte2ram(0x23,0x03);   //
			ht16c23_write_one_byte2ram(0x24,0x3a);   //"P"
			displayLoadRatio(&data->loadRatio);//ֵ
			displayPowerData(&data->kwhttli);//"ʾ" "" "load"
			if(data->pa<=999.9&&data->pb<=999.9&&data->pc<=999.9&&data->pttl<=999.9)
			{
				if(data->pa<0)
					tempP[0]=data->pa*-1;
				else
					tempP[0]=data->pa;						
				if(data->pb<0)
					tempP[1]=data->pb*-1;
				else
					tempP[1]=data->pb;
				if(data->pc<0)
					tempP[2]=data->pc*-1;
				else
					tempP[2]=data->pc;
				if(data->pttl<0)
					tempP[3]=data->pttl*-1;
				else 
					tempP[3]=data->pttl;
				displayPData(&tempP[0]);
				if(DataStruc.ctnum!=CTNUM_TWO)
				{
					ht16c23_write_one_byte2ram(0x0a,0x44);	//K K
					ht16c23_write_one_byte2ram(0x15,0x40);	//K 
					ht16c23_write_one_byte2ram(0x0b,0x82);	//W W
					ht16c23_write_one_byte2ram(0x16,0x80);	//W
				}
				else
				{
					ht16c23_write_one_byte2ram(0x15,0x40);	//K 					
					ht16c23_write_one_byte2ram(0x16,0x80);	//W					
				}
			}
			else
			{
				if(data->pa<0)
					tempP[0]=data->pa/1000*-1;
				else
					tempP[0]=data->pa/1000;						
				if(data->pb<0)
					tempP[1]=data->pb/1000*-1;
				else
					tempP[1]=data->pb/1000;
				if(data->pc<0)
					tempP[2]=data->pc/1000*-1;
				else
					tempP[2]=data->pc/1000;
				if(data->pttl<0)
					tempP[3]=data->pttl/1000*-1;
				else 
					tempP[3]=data->pttl/1000;
				displayPData(&tempP[0]);
				if(DataStruc.ctnum!=CTNUM_TWO)
				{
					ht16c23_write_one_byte2ram(0x0a,0x82);	//MW*3
					ht16c23_write_one_byte2ram(0x15,0x80);	//M 
					ht16c23_write_one_byte2ram(0x0b,0x82);	//W W
					ht16c23_write_one_byte2ram(0x16,0x80);	//W
				}
				else
				{
					ht16c23_write_one_byte2ram(0x15,0x80);	//M 					
					ht16c23_write_one_byte2ram(0x16,0x80);	//W					
				}
			}
			break;	
		//޹
		case PAGE3: 
			displayDIDO(&data->di1State);
			JudgeMinus(&data->qa,4);
			displayCtnum(pageNum);
			ht16c23_write_one_byte2ram(0x22,0x15);   //"Q"
			ht16c23_write_one_byte2ram(0x23,0x03);   //
			ht16c23_write_one_byte2ram(0x24,0x1a);   //"Q"
			displayLoadRatio(&data->loadRatio);//ֵ
			displayPowerData(&data->kwhttli);//"ʾ" "" "load"
			if(data->qa<=999.9&&data->qb<=999.9&&data->qc<=999.9&&data->qttl<=999.9)
			{
				if(data->qa<0)
					tempP[0]=data->qa*-1;
				else
					tempP[0]=data->qa;						
				if(data->qb<0)
					tempP[1]=data->qb*-1;
				else
					tempP[1]=data->qb;
				if(data->qc<0)
					tempP[2]=data->qc*-1;
				else
					tempP[2]=data->qc;
				if(data->qttl<0)
					tempP[3]=data->qttl*-1;
				else 
					tempP[3]=data->qttl;
				displayPData(&tempP[0]);
				if(DataStruc.ctnum!=CTNUM_TWO)
				{
					ht16c23_write_one_byte2ram(0x0a,0x08);   //Kvar
					ht16c23_write_one_byte2ram(0x0b,0x08);   //Kvar
					ht16c23_write_one_byte2ram(0x15,0x08);   //Kvar
					ht16c23_write_one_byte2ram(0x16,0x13);   //Kvar
				}
				else
				{
					ht16c23_write_one_byte2ram(0x15,0x08);   //Kvar					
					ht16c23_write_one_byte2ram(0x16,0x10);   //Kvar					
				}
			}
			else
			{
				if(data->qa<0)
					tempP[0]=data->qa/1000*-1;
				else
					tempP[0]=data->qa/1000;						
				if(data->qb<0)
					tempP[1]=data->qb/1000*-1;
				else
					tempP[1]=data->qb/1000;
				if(data->qc<0)
					tempP[2]=data->qc/1000*-1;
				else
					tempP[2]=data->qc/1000;
				if(data->qttl<0)
					tempP[3]=data->qttl/1000*-1;
				else 
					tempP[3]=data->qttl/1000;

				if(DataStruc.ctnum!=CTNUM_TWO)
				{
					displayPDataSpec(&tempP[0]);
					ht16c23_write_one_byte2ram(0x0b,0x08);   //Mvar
					ht16c23_write_one_byte2ram(0x16,0x12);   //Mvar
					ht16c23_write_one_byte2ram(0x15,0x04);   //M
				}
				else
				{	
					displayPData(&tempP[0]);
					ht16c23_write_one_byte2ram(0x16,0x10);   //var
					ht16c23_write_one_byte2ram(0x15,0x04);   //M						
				}
			}
			break;
		//ڹ
		case PAGE4:
			displayDIDO(&data->di1State);
			JudgeMinus(&data->sa,4);
			displayCtnum(pageNum);
			ht16c23_write_one_byte2ram(0x22,0x59);   //"S"
			ht16c23_write_one_byte2ram(0x23,0x43);   //
			ht16c23_write_one_byte2ram(0x24,0x1a);   //"S"
			displayLoadRatio(&data->loadRatio);//ֵ
			displayPowerData(&data->kwhttli);//"ʾ" "" "load"
			if(data->sa<=999.9&&data->sb<=999.9&&data->sc<=999.9&&data->sttl<=999.9)
			{
				displayPData(&data->sa);
				if(DataStruc.ctnum!=CTNUM_TWO)
				{
					ht16c23_write_one_byte2ram(0x0a,0x20);   //KVA
					ht16c23_write_one_byte2ram(0x0b,0x31);   //KVA
					ht16c23_write_one_byte2ram(0x15,0x30);   //KVA
					ht16c23_write_one_byte2ram(0x16,0x2c);   //KVA
				}
				else
				{
					ht16c23_write_one_byte2ram(0x15,0x30);   //KVA
					ht16c23_write_one_byte2ram(0x16,0x20);   //KVA									
				}
			}
			else
			{
					tempP[0]=data->sa/1000;						
					tempP[1]=data->sb/1000;
					tempP[2]=data->sc/1000;
					tempP[3]=data->sttl/1000;

				if(DataStruc.ctnum!=CTNUM_TWO)
				{
					displayPDataSpecVA(&tempP[0]);
					ht16c23_write_one_byte2ram(0x0a,0x11);   //MVA
					ht16c23_write_one_byte2ram(0x0b,0x30);   //MVA
					ht16c23_write_one_byte2ram(0x15,0x20);   //MVA
					ht16c23_write_one_byte2ram(0x16,0x2c);   //MVA
				}
				else
				{
					displayPDataSpecVA(&tempP[0]);
					ht16c23_write_one_byte2ram(0x15,0x20);   //
					ht16c23_write_one_byte2ram(0x16,0x20);   //MVA						
				}
			}
			break;
		//
		case PAGE5:
			displayDIDO(&data->di1State);
			JudgeMinus(&data->cosa,4);
			displayCtnum(pageNum);
			ht16c23_write_one_byte2ram(0x22,0x01);   //D1
			ht16c23_write_one_byte2ram(0x23,0x81);   //
			displayLoadRatio(&data->loadRatio);//ֵ
			displayPowerData(&data->kwhttli);//"ʾ
			if(data->cosa<0)
				tempP[0]=data->cosa*-1;
			else
				tempP[0]=data->cosa;						
			if(data->cosb<0)
				tempP[1]=data->cosb*-1;
			else
				tempP[1]=data->cosb;
			if(data->cosc<0)
				tempP[2]=data->cosc*-1;
			else
				tempP[2]=data->cosc;
			if(data->costtl<0)
				tempP[3]=data->costtl*-1;
			else 
				tempP[3]=data->costtl;
			displayPData(&tempP[0]);
			//displayPower(&data->kwhttli);//"ʾ" "" "load"
			break;	
		//Ƶ
		case PAGE6:
			displayDIDO(&data->di1State);
//				JudgeMinus(&data->freq,1);
//				displayCtnum(pageNum);
			ht16c23_write_one_byte2ram(0x22,0x09);   //"F"
			ht16c23_write_one_byte2ram(0x23,0x03);   //
			ht16c23_write_one_byte2ram(0x24,0x3a);   //"F"
			displayFreq(&data->freq);
			displayLoadRatio(&data->loadRatio);//ֵ
			displayPowerData(&data->kwhttli);//"ʾ" "" "load"
			ht16c23_write_one_byte2ram(0x15,0x01);//Hz
			break;
		//ѹг
		case PAGE7:
			displayDIDO(&data->di1State);
			JudgeMinus(&data->thdUa,3);
			displayCtnum(pageNum);
			ht16c23_write_one_byte2ram(0x22,0x55);   // "|""_"D1
			ht16c23_write_one_byte2ram(0x23,0x41);   //"""_"
			ht16c23_write_one_byte2ram(0x24,0x29);   // "|"
			displayPData(&data->thdUa);						
			displayLoadRatio(&data->loadRatio);//ֵ
			displayPowerData(&data->kwhttli);//"ʾ" "" "load"
			ht16c23_write_one_byte2ram(0x0b,0x44);//%
			ht16c23_write_one_byte2ram(0x16,0x40);//%
			
			break;
		//гЧֵ
		case PAGE8:
			displayDIDO(&data->di1State);
			JudgeMinus(&data->thdlRmsttl,3);
			displayCtnum(pageNum);			
			ht16c23_write_one_byte2ram(0x22,0x41);   //"I"
			ht16c23_write_one_byte2ram(0x23,0x5b);   //ݺ"I"
			ht16c23_write_one_byte2ram(0x24,0x03);   //"I"
			if(data->thdlRmsa<=999.9&&data->thdlRmsb<=999.9&&data->thdlRmsc<=999.9&&data->thdlRmsttl<=999.9)
			{
				displayPData(&data->thdlRmsa);
			}
			displayLoadRatio(&data->loadRatio);//ֵ
			displayPowerData(&data->kwhttli);//"ʾ" "" "load"	
			
			ht16c23_write_one_byte2ram(0x0b,0x20);	//A
			ht16c23_write_one_byte2ram(0x16,0x24);	//A A			
			break;	

		
		case PAGE9:
		//ѹƽ
			displayDIDO(&data->di1State);
			ht16c23_write_one_byte2ram(0x22,0x57);   // "|""_"D1
			ht16c23_write_one_byte2ram(0x23,0x41);   //"""_"
			ht16c23_write_one_byte2ram(0x24,0x28);   // "|"				
			displayHarmU(&data->unblU);
			displayLoadRatio(&data->loadRatio);//ֵ
			ht16c23_write_one_byte2ram(0x16,0x40);	//%
			displayPowerData(&data->kwhttli);//"ʾ" "" "load"
			break;
		case PAGE10:
		//ƽ		
			displayDIDO(&data->di1State);	
			ht16c23_write_one_byte2ram(0x22,0x43);   //"I"
			ht16c23_write_one_byte2ram(0x23,0x5b);   //ݺ"I"
			ht16c23_write_one_byte2ram(0x24,0x02);   //"I"		
			displayHarmU(&data->unblI);
			displayLoadRatio(&data->loadRatio);//ֵ
			displayPowerData(&data->kwhttli);//"ʾ" "" "load"	
			ht16c23_write_one_byte2ram(0x16,0x40);	//%			
			break;
		
		case PAGE11: 
			//©
			displayDIDO(&data->di1State);
			JudgeMinus(&data->leakCurrent,1);
			displayCtnum(pageNum);			
			ht16c23_write_one_byte2ram(0x22,0x81);  // ©
			ht16c23_write_one_byte2ram(0x23,0x01);  // 
			displayLoadRatio(&data->loadRatio);//ֵ
			if(data->leakCurrent<0)
				tempsingle=data->leakCurrent*-1;
			displayLC(&tempsingle);
			displayPowerData(&data->kwhttli);//"ʾ" "" "load"
		
			
			break;
		case PAGE12:
		//
			displayDIDO(&data->di1State);
			displayCtnum(pageNum);
			ht16c23_write_one_byte2ram(0x22,0x01);  // D1
			ht16c23_write_one_byte2ram(0x23,0x01);  // 
			ht16c23_write_one_byte2ram(0x24,0x40);  // 
			displayLoadRatio(&data->loadRatio);//ֵ
			if(data->md<=999.9)
			{
				displayMD(&data->md);
				ht16c23_write_one_byte2ram(0x15,0x40);
				ht16c23_write_one_byte2ram(0x16,0x80);
			}
			else
			{
				Mdtemp=data->md/1000.0f;
				displayMD(&Mdtemp);
				ht16c23_write_one_byte2ram(0x15,0x80);
				ht16c23_write_one_byte2ram(0x16,0x80);
			}
			displayPowerData(&data->kwhttli);//"ʾ" "" "load"
			
			break;
		case PAGE13:
		//¶				
			displayDIDO(&data->di1State);
			JudgeMinus(&data->temp1,4);
			displayCtnum(pageNum);			
			ht16c23_write_one_byte2ram(0x22,0x01);   //"T"
			ht16c23_write_one_byte2ram(0x23,0x1a);   //
			ht16c23_write_one_byte2ram(0x24,0x82);   //"T"				
			displayLoadRatio(&data->loadRatio);//ֵ
			displayTempata(&data->temp1);	
			displayPowerData(&data->kwhttli);//"ʾ" "" "load"	
			ht16c23_write_one_byte2ram(0x15,0x02);

			break;
		case PAGE14:
			//޹
			displayDIDO(&data->di1State);
			JudgeMinus(&data->ua,3);
			displayCtnum(pageNum);
			ht16c23_write_one_byte2ram(0x22,0x55);   // "|""_"D1
			ht16c23_write_one_byte2ram(0x23,0x41);   //"""_"
			ht16c23_write_one_byte2ram(0x24,0x28);   // "|"
			displayLoadRatio(&data->loadRatio);//ֵ
			displayPowerData(&data->kwhttle);//"ʾ" "" "load"		
			if(data->ua<=999.99f&&data->ub<=999.99f&&data->uc<=999.99f)
			{	
				if(data->ua<0)
					temp[0]=data->ua*-1;
				else
					temp[0]=data->ua;
				if(data->ub<0)
					temp[1]=data->ub*-1;
				else
					temp[1]=data->ub;
				if(data->uc<0)
					temp[2]=data->uc*-1;
				else
					temp[2]=data->uc;
				displayUIData(&temp[0]);
				if(DataStruc.ctnum!=CTNUM_TWO)
				{
					ht16c23_write_one_byte2ram(0x0b,0x10);   //V
					ht16c23_write_one_byte2ram(0x15,0x20);   //V
					ht16c23_write_one_byte2ram(0x16,0x08);   //V
				}
				else
				{
					ht16c23_write_one_byte2ram(0x0b,0x10);   //V
					ht16c23_write_one_byte2ram(0x16,0x08);   //V				
				}
			}
			else
			{	
				temp[0]=data->ua/1000.0f;
				temp[1]=data->ub/1000.0f;
				temp[2]=data->uc/1000.0f;
				displayUIData(&temp[0]);
				if(DataStruc.ctnum!=CTNUM_TWO)
				{
					ht16c23_write_one_byte2ram(0x0a,0x20);   //K				
					ht16c23_write_one_byte2ram(0x0b,0x11);   //K				
					ht16c23_write_one_byte2ram(0x15,0x30);   //V K					
					ht16c23_write_one_byte2ram(0x16,0x08);   //V
				}
				else
				{
					ht16c23_write_one_byte2ram(0x0a,0x20);   //K	 					
					ht16c23_write_one_byte2ram(0x15,0x30);   //V K
					ht16c23_write_one_byte2ram(0x0b,0x10);   //V						
				}
			}
			break;
		case PAGE15:
		//й+ѹ
			displayDIDO(&data->di1State);	
			JudgeMinus(&data->ua,3);
			displayCtnum(pageNum);
			ht16c23_write_one_byte2ram(0x22,0x55);   // "|""_"D1
			ht16c23_write_one_byte2ram(0x23,0x41);   //"""_"
			ht16c23_write_one_byte2ram(0x24,0x28);   // "|"
			displayLoadRatio(&data->loadRatio);
			displayPowerData(&data->kvarhttli);//"ʾ" "" "load"	
			if(data->ua<=999.99f&&data->ub<=999.99f&&data->uc<=999.99f)
			{	
				if(data->ua<0)
					temp[0]=data->ua*-1;
				else
					temp[0]=data->ua;
				if(data->ub<0)
					temp[1]=data->ub*-1;
				else
					temp[1]=data->ub;
				if(data->uc<0)
					temp[2]=data->uc*-1;
				else
					temp[2]=data->uc;
				displayUIData(&temp[0]);
				if(DataStruc.ctnum!=CTNUM_TWO)
				{
					ht16c23_write_one_byte2ram(0x0b,0x10);   //V
					ht16c23_write_one_byte2ram(0x15,0x20);   //V
					ht16c23_write_one_byte2ram(0x16,0x08);   //V
				}
				else
				{
					ht16c23_write_one_byte2ram(0x0b,0x10);   //V
					ht16c23_write_one_byte2ram(0x16,0x08);   //V				
				}
			}
			else
			{	
				temp[0]=data->ua/1000.0f;
				temp[1]=data->ub/1000.0f;
				temp[2]=data->uc/1000.0f;
				displayUIData(&temp[0]);
				if(DataStruc.ctnum!=CTNUM_TWO)
				{
					ht16c23_write_one_byte2ram(0x0a,0x20);   //K				
					ht16c23_write_one_byte2ram(0x0b,0x11);   //K				
					ht16c23_write_one_byte2ram(0x15,0x30);   //V K					
					ht16c23_write_one_byte2ram(0x16,0x08);   //V
				}
				else
				{
					ht16c23_write_one_byte2ram(0x0a,0x20);   //K	 					
					ht16c23_write_one_byte2ram(0x15,0x30);   //V K
					ht16c23_write_one_byte2ram(0x0b,0x10);   //V						
				}
			}	
			break;
		case PAGE16:
		//޹+ѹ
			displayDIDO(&data->di1State);	
			JudgeMinus(&data->ua,3);
			displayCtnum(pageNum);
			ht16c23_write_one_byte2ram(0x22,0x55);   // "|""_"D1
			ht16c23_write_one_byte2ram(0x23,0x41);   //"""_"
			ht16c23_write_one_byte2ram(0x24,0x28);   // "|"
			displayLoadRatio(&data->loadRatio);
			displayPowerData(&data->kvarhttle);//"ʾ" "" "load"	
			if(data->ua<=999.99f&&data->ub<=999.99f&&data->uc<=999.99f)
			{	
				if(data->ua<0)
					temp[0]=data->ua*-1;
				else
					temp[0]=data->ua;
				if(data->ub<0)
					temp[1]=data->ub*-1;
				else
					temp[1]=data->ub;
				if(data->uc<0)
					temp[2]=data->uc*-1;
				else
					temp[2]=data->uc;
				displayUIData(&temp[0]);
				if(DataStruc.ctnum!=CTNUM_TWO)
				{
					ht16c23_write_one_byte2ram(0x0b,0x10);   //V
					ht16c23_write_one_byte2ram(0x15,0x20);   //V
					ht16c23_write_one_byte2ram(0x16,0x08);   //V
				}
				else
				{
					ht16c23_write_one_byte2ram(0x0b,0x10);   //V
					ht16c23_write_one_byte2ram(0x16,0x08);   //V				
				}
			}
			else
			{	
				temp[0]=data->ua/1000.0f;
				temp[1]=data->ub/1000.0f;
				temp[2]=data->uc/1000.0f;
				displayUIData(&temp[0]);
				if(DataStruc.ctnum!=CTNUM_TWO)
				{
					ht16c23_write_one_byte2ram(0x0a,0x20);   //K				
					ht16c23_write_one_byte2ram(0x0b,0x11);   //K				
					ht16c23_write_one_byte2ram(0x15,0x30);   //V K					
					ht16c23_write_one_byte2ram(0x16,0x08);   //V
				}
				else
				{
					ht16c23_write_one_byte2ram(0x0a,0x20);   //K	 					
					ht16c23_write_one_byte2ram(0x15,0x30);   //V K
					ht16c23_write_one_byte2ram(0x0b,0x10);   //V						
				}
			}			
		}
	 
	 
 }
 /*
*********************************************************************************************************
*	  :  void displayDIDO()
*	˵: ʾDIDO
*	    ΣpageNum ҳ unitNum λ
*	  ֵ: 
*********************************************************************************************************
*/
void displayDIDO(float* data)
{
	if(*data==1)
	{
		ht16c23_write_one_byte2ram(0x00,0x28);  //DI1	OFF
	}
	else 
		ht16c23_write_one_byte2ram(0x00,0x30);  //DI1	ON	

}	

 /*
*********************************************************************************************************
*	  :  void displayLoadRatio()
*	˵: ʾload  PF
*	    ΣpageNum ҳ unitNum λ
*	  ֵ: 
*********************************************************************************************************
*/
void displayLoadRatio(float* data)
{
	if(MENUnum<14)
	{
		if(*data<0.3)
		{
			ht16c23_write_one_byte2ram(0x21,0x21);   //	
		}
		else if(*data>=0.3&&*data<0.6)
		{
			ht16c23_write_one_byte2ram(0x21,0x31);   //30% 
		}
		else if(*data>=0.6&&*data<=0.9)
		{
			ht16c23_write_one_byte2ram(0x21,0x29);   //60% 
		}		
		else if(*data>=0.9&&*data<1.2)
		{
			ht16c23_write_one_byte2ram(0x21,0x25);   //90% 
		}
		else if(*data>=1.2)
			ht16c23_write_one_byte2ram(0x21,0x23);   //120% 		
	}
	else if(MENUnum==PAGE14)//޹
	{
		if(*data<0.3)
		{
			ht16c23_write_one_byte2ram(0x21,0xa1);// kvarh
		}
		else if(*data>=0.3&&*data<0.6)
		{
			ht16c23_write_one_byte2ram(0x21,0xb1);   //30%  kvarh
		}
		else if(*data>=0.6&&*data<=0.9)
		{
			ht16c23_write_one_byte2ram(0x21,0xa9);   //60%  kvarh
		}		
		else if(*data>=0.9&&*data<1.2)
		{
			ht16c23_write_one_byte2ram(0x21,0xa5);   //90%  kvarh	
		}
		else if(*data>=1.2)
		{
			ht16c23_write_one_byte2ram(0x21,0xa3);   //120%  kvarh	
		}			
	}
	else if(MENUnum==PAGE15)//й
	{
		if(*data<0.3)
		{
			ht16c23_write_one_byte2ram(0x21,0x41);
		}
		else if(*data>=0.3&&*data<0.6)
		{
			ht16c23_write_one_byte2ram(0x21,0x51);   //30% 
		}
		else if(*data>=0.6&&*data<=0.9)
		{
			ht16c23_write_one_byte2ram(0x21,0x49);   //60% 
		}	
		else if(*data>=0.9&&*data<1.2)
		{
			ht16c23_write_one_byte2ram(0x21,0x45);   //90% 
		}
		else if(*data>=1.2)
		{
			ht16c23_write_one_byte2ram(0x21,0x43);   //120% 				
		}			
	}
	else if(MENUnum==PAGE16)//޹
	{
		if(*data<0.3)
		{
			ht16c23_write_one_byte2ram(0x21,0xc1);
		}
		else if(*data>=0.3&&*data<0.6)
		{
			ht16c23_write_one_byte2ram(0x21,0xd1);   //30%  kvarh
		}
		else if(*data>=0.6&&*data<=0.9)
		{
			ht16c23_write_one_byte2ram(0x21,0xc9);   //60% 	kvarh
		}		
		else if(*data>=0.9&&*data<1.2)
		{
			ht16c23_write_one_byte2ram(0x21,0xc5);   //90% 	kvarh	
		}
		else if(*data>=1.2)
		{
			ht16c23_write_one_byte2ram(0x21,0xc3);   //120% 	kvarh	
		}			
	}	
	
}

 /*
*********************************************************************************************************
*	  :  void displayLoadRatioOnlyNum()
*	˵: ʾ
*	    ΣpageNum ҳ unitNum λ
*	  ֵ: 
*********************************************************************************************************
*/
//void displayLoadRatioOnlyNum(float* data)
//{
//	if(*data<=0.3)
//	{
//		ht16c23_write_one_byte2ram(0x1f,0x06);   //30% (ֵ)	
//		
//	}
//	else if(*data>0.3&&*data<=0.6)
//	{
//		ht16c23_write_one_byte2ram(0x1f,0x0a);   //60% (ֵ)	
//	}
//	else if(*data>0.6&&*data<=0.9)
//	{
//		ht16c23_write_one_byte2ram(0x1f,0x12);   //90% (ֵ)
//	}		
//	else if(*data>0.9)
//	{
//		ht16c23_write_one_byte2ram(0x1f,0x22);   //120% (ֵ)
//	}
//	
//}
 /*
*********************************************************************************************************
*	  :  void displayFreq()
*	˵: 	ʾ
*	    Σ
*	  ֵ: 
*********************************************************************************************************
*/
void displayFreq(float* data)
{
	int tempa=0;
	u8 len;
	len=GetDatalength(data);
	
	tempa=(int)((*data)*10);//Сȥ Ȼ
	
	DisplayThirdLine(1,20);
	DisplayThirdLine(2,20);
	DisplayThirdLine(3,20);
	DisplayThirdLine(4,20);
	switch(len)
	{
		case 0:
			DisplayFourthLine(3,10);
			DisplayFourthLine(4,tempa%10);
			break;
		case 1:
			DisplayFourthLine(3,10+tempa/10);
			DisplayFourthLine(4,tempa%10);
			break;
		case 2:
			DisplayFourthLine(2,tempa/100);
			DisplayFourthLine(3,10+(tempa/10)%10);
			DisplayFourthLine(4,tempa%10);
			break;
		case 3:
			DisplayFourthLine(1,tempa/1000);
			DisplayFourthLine(2,(tempa/100)%10);
			DisplayFourthLine(3,10+(tempa/10)%10);
			DisplayFourthLine(4,tempa%10);
			break;		
	}
	


}

void displayLC(float* data)
{
	int tempa=0;
	u8 len;
	len=GetDatalength(data);
	
	tempa=(int)((*data)*10);//Сȥ Ȼ
	
	DisplayThirdLine(1,20);
	DisplayThirdLine(2,20);
	DisplayThirdLine(3,20);
	DisplayThirdLine(4,20);
	switch(len)
	{
		case 0:
			DisplayFourthLine(3,10);
			DisplayFourthLineSpec(4,tempa%10);
			break;
		case 1:
			DisplayFourthLine(3,10+tempa/10);
			DisplayFourthLineSpec(4,tempa%10);
			break;
		case 2:
			DisplayFourthLine(2,tempa/100);
			DisplayFourthLine(3,10+(tempa/10)%10);
			DisplayFourthLineSpec(4,tempa%10);
			break;
		case 3:
			DisplayFourthLine(1,tempa/1000);
			DisplayFourthLine(2,(tempa/100)%10);
			DisplayFourthLine(3,10+(tempa/10)%10);
			DisplayFourthLineSpec(4,tempa%10);
			break;		
	}
	


}

void displayMD(float* data)
{
	int tempa=0;
	u8 len;
	len=GetDatalength(data);
	
	tempa=(int)((*data)*10);//Сȥ Ȼ
	
	DisplayThirdLine(1,20);
	DisplayThirdLine(2,20);
	DisplayThirdLine(3,20);
	DisplayThirdLine(4,20);
	switch(len)
	{
		case 0:
			DisplayFourthLine(3,10);
			DisplayFourthLine(4,tempa%10);
			break;
		case 1:
			DisplayFourthLine(3,10+tempa/10);
			DisplayFourthLine(4,tempa%10);
			break;
		case 2:
			DisplayFourthLine(2,tempa/100);
			DisplayFourthLine(3,10+(tempa/10)%10);
			DisplayFourthLine(4,tempa%10);
			break;
		case 3:
			DisplayFourthLine(1,tempa/1000);
			DisplayFourthLine(2,(tempa/100)%10);
			DisplayFourthLine(3,10+(tempa/10)%10);
			DisplayFourthLine(4,tempa%10);
			break;		
	}
	


}


 /*
*********************************************************************************************************
*	  :  void displayHarmU()
*	˵: ʾѹг 
*	    ΣpageNum ҳ unitNum λ
*	  ֵ: 
*********************************************************************************************************
*/
void displayHarmU(float* data)
{
	
int tempa=0;
	u8 len;
	len=GetDatalength(data);
	
	tempa=(int)((*data)*10);//Сȥ Ȼ
	DisplayFourthLine(1,20);
	DisplayFourthLine(2,20);
	DisplayFourthLine(3,20);
	DisplayFourthLine(4,20);	
	switch(len)
	{
		case 0:
			DisplayThirdLine(3,10);
			DisplayThirdLine(4,tempa%10);
			break;
		case 1:
			DisplayThirdLine(3,10+tempa/10);
			DisplayThirdLine(4,tempa%10);
			break;
		case 2:
			DisplayThirdLine(2,tempa/100);
			DisplayThirdLine(3,10+(tempa/10)%10);
			DisplayThirdLine(4,tempa%10);
			break;
		case 3:
			DisplayThirdLine(1,tempa/1000);
			DisplayThirdLine(2,(tempa/100)%10);
			DisplayThirdLine(3,10+(tempa/10)%10);
			DisplayThirdLine(4,tempa%10);
			break;		
	}
}


 /*
*********************************************************************************************************
*	  :  void displayHarmI()
*	˵: ʾгЧֵ
*	    ΣpageNum ҳ unitNum λ
*	  ֵ: 
*********************************************************************************************************
*/
void displayHarmI(float* data)
{
	
int tempa=0;
	u8 len;
	len=GetDatalength(data);
	
	tempa=(int)((*data)*10);//Сȥ Ȼ
	
	DisplayFirstLine(1,20);
	DisplayFirstLine(2,20);
	DisplayFirstLine(3,20);
	DisplayFirstLine(4,20);	
	switch(len)
	{
		case 0:
			DisplaySecondLine(3,10);
			DisplaySecondLine(4,tempa%10);
			break;
		case 1:
			DisplaySecondLine(3,10+tempa/10);
			DisplaySecondLine(4,tempa%10);
			break;
		case 2:
			DisplaySecondLine(2,tempa/100);
			DisplaySecondLine(3,10+(tempa/10)%10);
			DisplaySecondLine(4,tempa%10);
			break;
		case 3:
			DisplaySecondLine(1,tempa/1000);
			DisplaySecondLine(2,(tempa/100)%10);
			DisplaySecondLine(3,10+(tempa/10)%10);
			DisplaySecondLine(4,tempa%10);
			break;		
	}
}




 /*
*********************************************************************************************************
*	  :  void displayPowerData()
*	˵: 	ʾ
*	    Σ
*	  ֵ: 
*********************************************************************************************************
*/
void displayPowerData(float* data)
{
	int temp=0;
	u8 len=0;
	temp=(int)((*data)*10);//Сȥ Ȼ
	
	len=GetDatalength(data);
	if(MENUnum==PAGE14 || MENUnum==PAGE16)
	{
		switch(len)
		{
			case 0:
				OLED_5_Display(9,10);
				ht16c23_write_one_byte2ram(0x17,Play1_5_spec2[temp]);
			
				break;
			case 1:
				OLED_5_Display(9,	10+temp/10);
				ht16c23_write_one_byte2ram(0x17,Play1_5_spec2[temp%10]);
			
				break;
			case 2:
				OLED_5_Display(8,temp/100);
				OLED_5_Display(9,10+(temp/10)%10);
				ht16c23_write_one_byte2ram(0x17,Play1_5_spec2[temp%10]);
			
				break;
			case 3:
				OLED_5_Display(7,temp/1000);
				OLED_5_Display(8,(temp/100)%10);
				OLED_5_Display(9,10+(temp/10)%10);
				ht16c23_write_one_byte2ram(0x17,Play1_5_spec2[temp%10]);
			
				break;
			case 4:
				OLED_5_Display(6,temp/10000);
				OLED_5_Display(7,temp/1000%10);
				OLED_5_Display(8,(temp/100)%10);
				OLED_5_Display(9,10+(temp/10)%10);
				ht16c23_write_one_byte2ram(0x17,Play1_5_spec2[temp%10]);
			
				break;
			case 5:
				OLED_5_Display(5,temp/100000);
				OLED_5_Display(6,temp/10000%10);
				OLED_5_Display(7,temp/1000%10);
				OLED_5_Display(8,(temp/100)%10);
				OLED_5_Display(9,10+(temp/10)%10);
				ht16c23_write_one_byte2ram(0x17,Play1_5_spec2[temp%10]);
			
				break;
			case 6:
				OLED_5_Display(4,temp/1000000);
				OLED_5_Display(5,temp/100000%10);
				OLED_5_Display(6,temp/10000%10);
				OLED_5_Display(7,temp/1000%10);
				OLED_5_Display(8,(temp/100)%10);
				OLED_5_Display(9,10+(temp/10)%10);
				ht16c23_write_one_byte2ram(0x17,Play1_5_spec2[temp%10]);
			
				break;
			case 7:
				OLED_5_Display(3,temp/10000000);
				OLED_5_Display(4,temp/1000000%10);
				OLED_5_Display(5,temp/100000%10);
				OLED_5_Display(6,temp/10000%10);
				OLED_5_Display(7,temp/1000%10);
				OLED_5_Display(8,(temp/100)%10);
				OLED_5_Display(9,10+(temp/10)%10);
				ht16c23_write_one_byte2ram(0x17,Play1_5_spec2[temp%10]);
			
				break;
			case 8:
				OLED_5_Display(2,temp/100000000);
				OLED_5_Display(3,temp/10000000%10);
				OLED_5_Display(4,temp/1000000%10);
				OLED_5_Display(5,temp/100000%10);
				OLED_5_Display(6,temp/10000%10);
				OLED_5_Display(7,temp/1000%10);
				OLED_5_Display(8,(temp/100)%10);
				OLED_5_Display(9,10+(temp/10)%10);
				ht16c23_write_one_byte2ram(0x17,Play1_5_spec2[temp%10]);
			
				break;
			case 9:
				OLED_5_Display(1,temp/1000000000);
				OLED_5_Display(2,temp/100000000%10);
				OLED_5_Display(3,temp/10000000%10);
				OLED_5_Display(4,temp/1000000%10);
				OLED_5_Display(5,temp/100000%10);
				OLED_5_Display(6,temp/10000%10);
				OLED_5_Display(7,temp/1000%10);
				OLED_5_Display(8,(temp/100)%10);
				OLED_5_Display(9,10+(temp/10)%10);
				ht16c23_write_one_byte2ram(0x17,Play1_5_spec2[temp%10]);
			
				break;
		}		
  }
	else
	{
		switch(len)
		{
			case 0:
				OLED_5_Display(9,10);
				ht16c23_write_one_byte2ram(0x17,Play1_5_spec1[temp]);
			
				break;
			case 1:
				OLED_5_Display(9,	10+temp/10);
				ht16c23_write_one_byte2ram(0x17,Play1_5_spec1[temp%10]);
			
				break;
			case 2:
				OLED_5_Display(8,temp/100);
				OLED_5_Display(9,10+(temp/10)%10);
				ht16c23_write_one_byte2ram(0x17,Play1_5_spec1[temp%10]);
			
				break;
			case 3:
				OLED_5_Display(7,temp/1000);
				OLED_5_Display(8,(temp/100)%10);
				OLED_5_Display(9,10+(temp/10)%10);
				ht16c23_write_one_byte2ram(0x17,Play1_5_spec1[temp%10]);
			
				break;
			case 4:
				OLED_5_Display(6,temp/10000);
				OLED_5_Display(7,temp/1000%10);
				OLED_5_Display(8,(temp/100)%10);
				OLED_5_Display(9,10+(temp/10)%10);
				ht16c23_write_one_byte2ram(0x17,Play1_5_spec1[temp%10]);
			
				break;
			case 5:
				OLED_5_Display(5,temp/100000);
				OLED_5_Display(6,temp/10000%10);
				OLED_5_Display(7,temp/1000%10);
				OLED_5_Display(8,(temp/100)%10);
				OLED_5_Display(9,10+(temp/10)%10);
				ht16c23_write_one_byte2ram(0x17,Play1_5_spec1[temp%10]);
			
				break;
			case 6:
				OLED_5_Display(4,temp/1000000);
				OLED_5_Display(5,temp/100000%10);
				OLED_5_Display(6,temp/10000%10);
				OLED_5_Display(7,temp/1000%10);
				OLED_5_Display(8,(temp/100)%10);
				OLED_5_Display(9,10+(temp/10)%10);
				ht16c23_write_one_byte2ram(0x17,Play1_5_spec1[temp%10]);
			
				break;
			case 7:
				OLED_5_Display(3,temp/10000000);
				OLED_5_Display(4,temp/1000000%10);
				OLED_5_Display(5,temp/100000%10);
				OLED_5_Display(6,temp/10000%10);
				OLED_5_Display(7,temp/1000%10);
				OLED_5_Display(8,(temp/100)%10);
				OLED_5_Display(9,10+(temp/10)%10);
				ht16c23_write_one_byte2ram(0x17,Play1_5_spec1[temp%10]);
			
				break;
			case 8:
				OLED_5_Display(2,temp/100000000);
				OLED_5_Display(3,temp/10000000%10);
				OLED_5_Display(4,temp/1000000%10);
				OLED_5_Display(5,temp/100000%10);
				OLED_5_Display(6,temp/10000%10);
				OLED_5_Display(7,temp/1000%10);
				OLED_5_Display(8,(temp/100)%10);
				OLED_5_Display(9,10+(temp/10)%10);
				ht16c23_write_one_byte2ram(0x17,Play1_5_spec1[temp%10]);
			
				break;
			case 9:
				OLED_5_Display(1,temp/1000000000);
				OLED_5_Display(2,temp/100000000%10);
				OLED_5_Display(3,temp/10000000%10);
				OLED_5_Display(4,temp/1000000%10);
				OLED_5_Display(5,temp/100000%10);
				OLED_5_Display(6,temp/10000%10);
				OLED_5_Display(7,temp/1000%10);
				OLED_5_Display(8,(temp/100)%10);
				OLED_5_Display(9,10+(temp/10)%10);
				ht16c23_write_one_byte2ram(0x17,Play1_5_spec1[temp%10]);
			
				break;
		}		
	
	
	
	}		
}
 /*
*********************************************************************************************************
*	  :  void displayUIData()
*	˵: 	ʾѹ
*	    Σ
*	  ֵ: 
*********************************************************************************************************
*/
void displayUIData(float* data)
{
	int tempa=0,tempb=0,tempc=0;
	u8 lenA=0,lenB=0,lenC=0;
	lenA=GetDatalength(data);
	lenB=GetDatalength((((float*)(data))+1));
	lenC=GetDatalength((((float*)(data))+2));
	
	tempa=(int)((*data)*10);//Сȥ Ȼ
	tempb=(int)(*(((float*)(data))+1)*10);
	tempc=(int)(*(((float*)(data))+2)*10);
	
	DisplayFourthLine(1,20);
	DisplayFourthLine(2,20);
	DisplayFourthLine(3,20);
	DisplayFourthLine(4,20);
	if(DataStruc.ctnum!=CTNUM_TWO)
	{		
		switch(lenA)
		{
			case 0:
				DisplayFirstLine(3,10);
				DisplayFirstLine(4,tempa%10);
				break;
			case 1:
				DisplayFirstLine(3,10+tempa/10);
				DisplayFirstLine(4,tempa%10);
				break;
			case 2:
				DisplayFirstLine(2,tempa/100);
				DisplayFirstLine(3,10+(tempa/10)%10);
				DisplayFirstLine(4,tempa%10);
				break;
			case 3:
				DisplayFirstLine(1,tempa/1000);
				DisplayFirstLine(2,(tempa/100)%10);
				DisplayFirstLine(3,10+(tempa/10)%10);
				DisplayFirstLine(4,tempa%10);
				break;		
		}
		
		switch(lenB)
		{
			case 0:
				DisplaySecondLine(3,10);
				DisplaySecondLine(4,tempb%10);
				break;
			case 1:
				DisplaySecondLine(3,10+tempb/10);
				DisplaySecondLine(4,tempb%10);
				break;
			case 2:
				DisplaySecondLine(2,tempb/100);
				DisplaySecondLine(3,10+(tempb/10)%10);
				DisplaySecondLine(4,tempb%10);
				break;
			case 3:
				DisplaySecondLine(1,tempb/1000);
				DisplaySecondLine(2,(tempb/100)%10);
				DisplaySecondLine(3,10+(tempb/10)%10);
				DisplaySecondLine(4,tempb%10);
				break;	
			
		}
		
		switch(lenC)
		{
			case 0:
				DisplayThirdLine(3,10);
				DisplayThirdLine(4,tempc%10);
				break;
			case 1:
				DisplayThirdLine(3,10+tempc/10);
				DisplayThirdLine(4,tempc%10);
				break;
			case 2:
				DisplayThirdLine(2,tempc/100);
				DisplayThirdLine(3,10+(tempc/10)%10);
				DisplayThirdLine(4,tempc%10);
				break;
			case 3:
				DisplayThirdLine(1,tempc/1000);
				DisplayThirdLine(2,(tempc/100)%10);
				DisplayThirdLine(3,10+(tempc/10)%10);
				DisplayThirdLine(4,tempc%10);
				break;	
		
		}
	}
	else
	{
		switch(lenA)
		{
			case 0:
				DisplayFirstLine(3,10);
				DisplayFirstLine(4,tempa%10);
				break;
			case 1:
				DisplayFirstLine(3,10+tempa/10);
				DisplayFirstLine(4,tempa%10);
				break;
			case 2:
				DisplayFirstLine(2,tempa/100);
				DisplayFirstLine(3,10+(tempa/10)%10);
				DisplayFirstLine(4,tempa%10);
				break;
			case 3:
				DisplayFirstLine(1,tempa/1000);
				DisplayFirstLine(2,(tempa/100)%10);
				DisplayFirstLine(3,10+(tempa/10)%10);
				DisplayFirstLine(4,tempa%10);
				break;		
		}
		switch(lenC)
		{
			case 0:
				DisplayThirdLine(3,10);
				DisplayThirdLine(4,tempc%10);
				break;
			case 1:
				DisplayThirdLine(3,10+tempc/10);
				DisplayThirdLine(4,tempc%10);
				break;
			case 2:
				DisplayThirdLine(2,tempc/100);
				DisplayThirdLine(3,10+(tempc/10)%10);
				DisplayThirdLine(4,tempc%10);
				break;
			case 3:
				DisplayThirdLine(1,tempc/1000);
				DisplayThirdLine(2,(tempc/100)%10);
				DisplayThirdLine(3,10+(tempc/10)%10);
				DisplayThirdLine(4,tempc%10);
				break;	
		
		}		
	
	
	
	}


}



 /*
*********************************************************************************************************
*	  :  void displayPData()
*	˵: 	ʾ
*	    Σ
*	  ֵ: 
*********************************************************************************************************
*/
void displayPData(float* data)
{
	int tempa=0,tempb=0,tempc=0,tempd=0;
	u8 lenA=0,lenB=0,lenC,lenD=0;
	lenA=GetDatalength(data);
	lenB=GetDatalength((((float*)(data))+1));
	lenC=GetDatalength((((float*)(data))+2));
	lenD=GetDatalength((((float*)(data))+3));

	tempa=(int)((*data)*10);//Сȥ Ȼ
	tempb=(int)(*(((float*)(data))+1)*10);
	tempc=(int)(*(((float*)(data))+2)*10);
	tempd=(int)(*(((float*)(data))+3)*10);
	if(DataStruc.ctnum!=CTNUM_TWO)
	{
		switch(lenA)
		{
			case 0:
				DisplayFirstLine(3,10);
				DisplayFirstLine(4,tempa%10);
				break;
			case 1:
				DisplayFirstLine(3,10+tempa/10);
				DisplayFirstLine(4,tempa%10);
				break;
			case 2:
				DisplayFirstLine(2,tempa/100);
				DisplayFirstLine(3,10+(tempa/10)%10);
				DisplayFirstLine(4,tempa%10);
				break;
			case 3:
				DisplayFirstLine(1,tempa/1000);
				DisplayFirstLine(2,(tempa/100)%10);
				DisplayFirstLine(3,10+(tempa/10)%10);
				DisplayFirstLine(4,tempa%10);
				break;
			default:
				DisplayFirstLine(3,10);
				DisplayFirstLine(4,0);
				break;
		}
		
		switch(lenB)
		{
			case 0:
				DisplaySecondLine(3,10);
				DisplaySecondLine(4,tempb%10);
				break;
			case 1:
				DisplaySecondLine(3,10+tempb/10);
				DisplaySecondLine(4,tempb%10);
				break;
			case 2:
				DisplaySecondLine(2,tempb/100);
				DisplaySecondLine(3,10+(tempb/10)%10);
				DisplaySecondLine(4,tempb%10);
				break;
			case 3:
				DisplaySecondLine(1,tempb/1000);
				DisplaySecondLine(2,(tempb/100)%10);
				DisplaySecondLine(3,10+(tempb/10)%10);
				DisplaySecondLine(4,tempb%10);
				break;
			default:
				DisplaySecondLine(3,10);
				DisplaySecondLine(4,0);
				break;			
			
		}
		
		switch(lenC)
		{
			case 0:
				DisplayThirdLine(3,10);
				DisplayThirdLine(4,tempc%10);
				break;
			case 1:
				DisplayThirdLine(3,10+tempc/10);
				DisplayThirdLine(4,tempc%10);
				break;
			case 2:
				DisplayThirdLine(2,tempc/100);
				DisplayThirdLine(3,10+(tempc/10)%10);
				DisplayThirdLine(4,tempc%10);
				break;
			case 3:
				DisplayThirdLine(1,tempc/1000);
				DisplayThirdLine(2,(tempc/100)%10);
				DisplayThirdLine(3,10+(tempc/10)%10);
				DisplayThirdLine(4,tempc%10);
				break;
			default:
				DisplayThirdLine(3,10);
				DisplayThirdLine(4,0);
				break;			
		
		}
		switch(lenD)
		{
			case 0:
				DisplayFourthLine(3,10);
				DisplayFourthLine(4,tempd%10);
				break;
			case 1:
				DisplayFourthLine(3,10+tempd/10);
				DisplayFourthLine(4,tempd%10);
				break;
			case 2:
				DisplayFourthLine(2,tempd/100);
				DisplayFourthLine(3,10+(tempd/10)%10);
				DisplayFourthLine(4,tempd%10);
				break;
			case 3:
				DisplayFourthLine(1,tempd/1000);
				DisplayFourthLine(2,(tempd/100)%10);
				DisplayFourthLine(3,10+(tempd/10)%10);
				DisplayFourthLine(4,tempd%10);
				break;
			default:
				DisplayFourthLine(3,10);
				DisplayFourthLine(4,0);
				break;			
		
		}
	}
	else
		switch(lenD)
		{
			case 0:
				DisplayFourthLine(3,10);
				DisplayFourthLine(4,tempd%10);
				break;
			case 1:
				DisplayFourthLine(3,10+tempd/10);
				DisplayFourthLine(4,tempd%10);
				break;
			case 2:
				DisplayFourthLine(2,tempd/100);
				DisplayFourthLine(3,10+(tempd/10)%10);
				DisplayFourthLine(4,tempd%10);
				break;
			case 3:
				DisplayFourthLine(1,tempd/1000);
				DisplayFourthLine(2,(tempd/100)%10);
				DisplayFourthLine(3,10+(tempd/10)%10);
				DisplayFourthLine(4,tempd%10);
				break;
		default:
				DisplayFourthLine(3,10);
				DisplayFourthLine(4,0);
				break;			
		
		}

}

 /*
*********************************************************************************************************
*	  :  void displayTempterata()
*	˵: 	ʾ¶
*	    Σ
*	  ֵ: 
*********************************************************************************************************
*/
void displayTempata(float* data)
{
	int tempa=0,tempb=0,tempc=0,tempd=0;
	u8 lenA=0,lenB=0,lenC,lenD=0;
	lenA=GetDatalength(data);
	lenB=GetDatalength((((float*)(data))+1));
	lenC=GetDatalength((((float*)(data))+2));
	lenD=GetDatalength((((float*)(data))+3));

	tempa=(int)((*data)*10);//Сȥ Ȼ
	tempb=(int)(*(((float*)(data))+1)*10);
	tempc=(int)(*(((float*)(data))+2)*10);
	tempd=(int)(*(((float*)(data))+3)*10);
		switch(lenA)
		{
			case 0:
				DisplayFirstLine(3,10);
				DisplayFirstLine(4,tempa%10);
				break;
			case 1:
				DisplayFirstLine(3,10+tempa/10);
				DisplayFirstLine(4,tempa%10);
				break;
			case 2:
				DisplayFirstLine(2,tempa/100);
				DisplayFirstLine(3,10+(tempa/10)%10);
				DisplayFirstLine(4,tempa%10);
				break;
			case 3:
				DisplayFirstLine(1,tempa/1000);
				DisplayFirstLine(2,(tempa/100)%10);
				DisplayFirstLine(3,10+(tempa/10)%10);
				DisplayFirstLine(4,tempa%10);
				break;
			default:
				DisplayFirstLine(3,10);
				DisplayFirstLine(4,0);
				break;
		}
		
		switch(lenB)
		{
			case 0:
				DisplaySecondLine(3,10);
				DisplaySecondLine(4,tempb%10);
				break;
			case 1:
				DisplaySecondLine(3,10+tempb/10);
				DisplaySecondLine(4,tempb%10);
				break;
			case 2:
				DisplaySecondLine(2,tempb/100);
				DisplaySecondLine(3,10+(tempb/10)%10);
				DisplaySecondLine(4,tempb%10);
				break;
			case 3:
				DisplaySecondLine(1,tempb/1000);
				DisplaySecondLine(2,(tempb/100)%10);
				DisplaySecondLine(3,10+(tempb/10)%10);
				DisplaySecondLine(4,tempb%10);
				break;
			default:
				DisplaySecondLine(3,10);
				DisplaySecondLine(4,0);
				break;			
			
		}
		
		switch(lenC)
		{
			case 0:
				DisplayThirdLine(3,10);
				DisplayThirdLine(4,tempc%10);
				break;
			case 1:
				DisplayThirdLine(3,10+tempc/10);
				DisplayThirdLine(4,tempc%10);
				break;
			case 2:
				DisplayThirdLine(2,tempc/100);
				DisplayThirdLine(3,10+(tempc/10)%10);
				DisplayThirdLine(4,tempc%10);
				break;
			case 3:
				DisplayThirdLine(1,tempc/1000);
				DisplayThirdLine(2,(tempc/100)%10);
				DisplayThirdLine(3,10+(tempc/10)%10);
				DisplayThirdLine(4,tempc%10);
				break;
			default:
				DisplayThirdLine(3,10);
				DisplayThirdLine(4,0);
				break;			
		
		}
		switch(lenD)
		{
			case 0:
				DisplayFourthLine(3,10);
				DisplayFourthLine(4,tempd%10);
				break;
			case 1:
				DisplayFourthLine(3,10+tempd/10);
				DisplayFourthLine(4,tempd%10);
				break;
			case 2:
				DisplayFourthLine(2,tempd/100);
				DisplayFourthLine(3,10+(tempd/10)%10);
				DisplayFourthLine(4,tempd%10);
				break;
			case 3:
				DisplayFourthLine(1,tempd/1000);
				DisplayFourthLine(2,(tempd/100)%10);
				DisplayFourthLine(3,10+(tempd/10)%10);
				DisplayFourthLine(4,tempd%10);
				break;
			default:
				DisplayFourthLine(3,10);
				DisplayFourthLine(4,0);
				break;			
		
		}


}



void displayPDataSpec(float* data) //M
{
	int tempa=0,tempb=0,tempc=0,tempd=0;
	u8 lenA=0,lenB=0,lenC,lenD=0;
	lenA=GetDatalength(data);
	lenB=GetDatalength((((float*)(data))+1));
	lenC=GetDatalength((((float*)(data))+2));
	lenD=GetDatalength((((float*)(data))+3));

	tempa=(int)((*data)*10);//Сȥ Ȼ
	tempb=(int)(*(((float*)(data))+1)*10);
	tempc=(int)(*(((float*)(data))+2)*10);
	tempd=(int)(*(((float*)(data))+3)*10);
		switch(lenA)
		{
			case 0:
				DisplayFirstLine(3,10);
				DisplayFirstLineSpec(4,tempa%10);
				break;
			case 1:
				DisplayFirstLine(3,10+tempa/10);
				DisplayFirstLineSpec(4,tempa%10);
				break;
			case 2:
				DisplayFirstLine(2,tempa/100);
				DisplayFirstLine(3,10+(tempa/10)%10);
				DisplayFirstLineSpec(4,tempa%10);
				break;
			case 3:
				DisplayFirstLine(1,tempa/1000);
				DisplayFirstLine(2,(tempa/100)%10);
				DisplayFirstLine(3,10+(tempa/10)%10);
				DisplayFirstLineSpec(4,tempa%10);
				break;			
		}
		
		switch(lenB)
		{
			case 0:
				DisplaySecondLine(3,10);
				DisplaySecondLineSpec(4,tempb%10);
				break;
			case 1:
				DisplaySecondLine(3,10+tempb/10);
				DisplaySecondLineSpec(4,tempb%10);
				break;
			case 2:
				DisplaySecondLine(2,tempb/100);
				DisplaySecondLine(3,10+(tempb/10)%10);
				DisplaySecondLineSpec(4,tempb%10);
				break;
			case 3:
				DisplaySecondLine(1,tempb/1000);
				DisplaySecondLine(2,(tempb/100)%10);
				DisplaySecondLine(3,10+(tempb/10)%10);
				DisplaySecondLineSpec(4,tempb%10);
				break;	
			
		}
		
		switch(lenC)
		{
			case 0:
				DisplayThirdLine(3,10);
				DisplayThirdLine(4,tempc%10);
				break;
			case 1:
				DisplayThirdLine(3,10+tempc/10);
				DisplayThirdLine(4,tempc%10);
				break;
			case 2:
				DisplayThirdLine(2,tempc/100);
				DisplayThirdLine(3,10+(tempc/10)%10);
				DisplayThirdLine(4,tempc%10);
				break;
			case 3:
				DisplayThirdLine(1,tempc/1000);
				DisplayThirdLine(2,(tempc/100)%10);
				DisplayThirdLine(3,10+(tempc/10)%10);
				DisplayThirdLine(4,tempc%10);
				break;	
		
		}
		switch(lenD)
		{
			case 0:
				DisplayFourthLine(3,10);
				DisplayFourthLine(4,tempd%10);
				break;
			case 1:
				DisplayFourthLine(3,10+tempd/10);
				DisplayFourthLine(4,tempd%10);
				break;
			case 2:
				DisplayFourthLine(2,tempd/100);
				DisplayFourthLine(3,10+(tempd/10)%10);
				DisplayFourthLine(4,tempd%10);
				break;
			case 3:
				DisplayFourthLine(1,tempd/1000);
				DisplayFourthLine(2,(tempd/100)%10);
				DisplayFourthLine(3,10+(tempd/10)%10);
				DisplayFourthLine(4,tempd%10);
				break;	
		
		}


}


void displayPDataSpecVA(float* data) //M
{
	int tempa=0,tempb=0,tempc=0,tempd=0;
	u8 lenA=0,lenB=0,lenC,lenD=0;
	lenA=GetDatalength(data);
	lenB=GetDatalength((((float*)(data))+1));
	lenC=GetDatalength((((float*)(data))+2));
	lenD=GetDatalength((((float*)(data))+3));

	tempa=(int)((*data)*10);//Сȥ Ȼ
	tempb=(int)(*(((float*)(data))+1)*10);
	tempc=(int)(*(((float*)(data))+2)*10);
	tempd=(int)(*(((float*)(data))+3)*10);
	if(DataStruc.ctnum!=CTNUM_TWO)
	{
		switch(lenA)
		{
			case 0:
				DisplayFirstLine(3,10);
				DisplayFirstLine(4,tempa%10);
				break;
			case 1:
				DisplayFirstLine(3,10+tempa/10);
				DisplayFirstLine(4,tempa%10);
				break;
			case 2:
				DisplayFirstLine(2,tempa/100);
				DisplayFirstLine(3,10+(tempa/10)%10);
				DisplayFirstLine(4,tempa%10);
				break;
			case 3:
				DisplayFirstLine(1,tempa/1000);
				DisplayFirstLine(2,(tempa/100)%10);
				DisplayFirstLine(3,10+(tempa/10)%10);
				DisplayFirstLine(4,tempa%10);
				break;			
		}
		
		switch(lenB)
		{
			case 0:
				DisplaySecondLine(3,10);
				DisplaySecondLine(4,tempb%10);
				break;
			case 1:
				DisplaySecondLine(3,10+tempb/10);
				DisplaySecondLine(4,tempb%10);
				break;
			case 2:
				DisplaySecondLine(2,tempb/100);
				DisplaySecondLine(3,10+(tempb/10)%10);
				DisplaySecondLine(4,tempb%10);
				break;
			case 3:
				DisplaySecondLine(1,tempb/1000);
				DisplaySecondLine(2,(tempb/100)%10);
				DisplaySecondLine(3,10+(tempb/10)%10);
				DisplaySecondLine(4,tempb%10);
				break;	
			
		}
		
		switch(lenC)
		{
			case 0:
				DisplayThirdLine(3,10);
				DisplayThirdLineSpec(4,tempc%10);
				break;
			case 1:
				DisplayThirdLine(3,10+tempc/10);
				DisplayThirdLineSpec(4,tempc%10);
				break;
			case 2:
				DisplayThirdLine(2,tempc/100);
				DisplayThirdLine(3,10+(tempc/10)%10);
				DisplayThirdLineSpec(4,tempc%10);
				break;
			case 3:
				DisplayThirdLine(1,tempc/1000);
				DisplayThirdLine(2,(tempc/100)%10);
				DisplayThirdLine(3,10+(tempc/10)%10);
				DisplayThirdLineSpec(4,tempc%10);
				break;	
		
		}
		switch(lenD)
		{
			case 0:
				DisplayFourthLine(3,10);
				DisplayFourthLine(4,tempd%10);
				break;
			case 1:
				DisplayFourthLine(3,10+tempd/10);
				DisplayFourthLine(4,tempd%10);
				break;
			case 2:
				DisplayFourthLine(2,tempd/100);
				DisplayFourthLine(3,10+(tempd/10)%10);
				DisplayFourthLine(4,tempd%10);
				break;
			case 3:
				DisplayFourthLine(1,tempd/1000);
				DisplayFourthLine(2,(tempd/100)%10);
				DisplayFourthLine(3,10+(tempd/10)%10);
				DisplayFourthLine(4,tempd%10);
				break;	
		
		}
	}
	else
	{
		switch(lenD)
		{
			case 0:
				DisplayFourthLine(3,10);
				DisplayFourthLineSpec2(4,tempd%10);
				break;
			case 1:
				DisplayFourthLine(3,10+tempd/10);
				DisplayFourthLineSpec2(4,tempd%10);
				break;
			case 2:
				DisplayFourthLine(2,tempd/100);
				DisplayFourthLine(3,10+(tempd/10)%10);
				DisplayFourthLineSpec2(4,tempd%10);
				break;
			case 3:
				DisplayFourthLine(1,tempd/1000);
				DisplayFourthLine(2,(tempd/100)%10);
				DisplayFourthLine(3,10+(tempd/10)%10);
				DisplayFourthLineSpec2(4,tempd%10);
				break;	
		
		}
		//ht16c23_write_one_byte2ram(0x14,0x10);
	}


}


 /*
*********************************************************************************************************
*	  :  void displayCtnum()
*	˵: ʾ4 ͷ
*	    ΣpageNum ҳ unitNum λ
*	  ֵ: 
*********************************************************************************************************
*/
void displayCtnum(u8 pageNum)
{
	u16 tempminus[2]={0};
		
		if(MinusFlag[0]==1)
			tempminus[0]|=0x40;
		if(MinusFlag[1]==1)
			tempminus[0]|=0x04;
		if(MinusFlag[2]==1)
			tempminus[1]|=0x40;
		if(MinusFlag[3]==1)
			tempminus[1]|=0x04;
		switch(pageNum)
		{
			case PAGE0:
				if(DataStruc.ctnum==CTNUM_TWO)
					ht16c23_write_one_byte2ram(0x01,0x33);
				else
				{
					ht16c23_write_one_byte2ram(0x01,0x11|tempminus[0]);  // 1    2
					ht16c23_write_one_byte2ram(0x0c,0x10|tempminus[1]);  //  3
				}
				break;
			case PAGE1:
				if(DataStruc.ctnum==CTNUM_TWO)
				{
					ht16c23_write_one_byte2ram(0x01,0x10);
					ht16c23_write_one_byte2ram(0x0c,0x10);
				}
				else
				{
					ht16c23_write_one_byte2ram(0x01,0x11|tempminus[0]);  // 1    2
					ht16c23_write_one_byte2ram(0x0c,0x10|tempminus[1]);  //  3
				}
				break;
			case PAGE2:
				if(DataStruc.ctnum==CTNUM_TWO)
				{
					if(MinusFlag[3]==1)
					ht16c23_write_one_byte2ram(0x0c,0x06);//-
					else
					ht16c23_write_one_byte2ram(0x0c,0x02);//
				}
				else
				{
						ht16c23_write_one_byte2ram(0x01,0x11|tempminus[0]);
						ht16c23_write_one_byte2ram(0x0c,0x12|tempminus[1]); 
				}
				break;
			case PAGE3:
				if(DataStruc.ctnum==CTNUM_TWO)
				{
					if(MinusFlag[3]==1)
					ht16c23_write_one_byte2ram(0x0c,0x06);//-
					else
					ht16c23_write_one_byte2ram(0x0c,0x02);//
				}
				else
				{
						ht16c23_write_one_byte2ram(0x01,0x11|tempminus[0]);
						ht16c23_write_one_byte2ram(0x0c,0x12|tempminus[1]); 						
				}
				break;
			case PAGE4:
				if(DataStruc.ctnum==CTNUM_TWO)
				{
					if(MinusFlag[3]==1)
					ht16c23_write_one_byte2ram(0x0c,0x06);//-
					else
					ht16c23_write_one_byte2ram(0x0c,0x02);//
				}
				else
				{
						ht16c23_write_one_byte2ram(0x01,0x11|tempminus[0]);
						ht16c23_write_one_byte2ram(0x0c,0x12|tempminus[1]); 
				}
				break;
			case PAGE5:
				if(DataStruc.ctnum==CTNUM_TWO)
				{
					if(MinusFlag[3]==1)
					ht16c23_write_one_byte2ram(0x0c,0x06);//-
					else
					ht16c23_write_one_byte2ram(0x0c,0x02);//
				}
				else
				{
					ht16c23_write_one_byte2ram(0x01,0x11|tempminus[0]);
					ht16c23_write_one_byte2ram(0x0c,0x12|tempminus[1]); 						
				}
				break;
				
			case PAGE6:
					ht16c23_write_one_byte2ram(0x0c,tempminus[1]);
					break;
			
			case PAGE7:		
					ht16c23_write_one_byte2ram(0x01,0x11);  // 1    2
					ht16c23_write_one_byte2ram(0x0c,0x12);  //  3
				break;
			
			case PAGE8:		
					ht16c23_write_one_byte2ram(0x01,0x11);  // 1    2
					ht16c23_write_one_byte2ram(0x0c,0x12);  //  3
				break;
			case PAGE13:
					ht16c23_write_one_byte2ram(0x01,0x11|tempminus[0]);  // 1    2
					ht16c23_write_one_byte2ram(0x0c,0x11|tempminus[1]);  //  3	 4
					break;
			
			case PAGE11:
					ht16c23_write_one_byte2ram(0x0c,tempminus[1]);
					break;
			case PAGE12:
					ht16c23_write_one_byte2ram(0x0c,0x02);//
					break;



			
				case PAGE14:
				if(DataStruc.ctnum==CTNUM_TWO)
					ht16c23_write_one_byte2ram(0x01,0x33);
				else
				{
					ht16c23_write_one_byte2ram(0x01,0x11|tempminus[0]);  // 1    2
					ht16c23_write_one_byte2ram(0x0c,0x10|tempminus[1]);  //  3
				}
				break;
				
				case PAGE15:
				if(DataStruc.ctnum==CTNUM_TWO)
					ht16c23_write_one_byte2ram(0x01,0x33);
				else
				{
					ht16c23_write_one_byte2ram(0x01,0x11|tempminus[0]);  // 1    2
					ht16c23_write_one_byte2ram(0x0c,0x10|tempminus[1]);  //  3
				}
				break;
				case PAGE16:
				if(DataStruc.ctnum==CTNUM_TWO)
					ht16c23_write_one_byte2ram(0x01,0x33);
				else
				{
					ht16c23_write_one_byte2ram(0x01,0x11|tempminus[0]);  // 1    2
					ht16c23_write_one_byte2ram(0x0c,0x10|tempminus[1]);  //  3
				}
				break;
		}
}	
 
 
  /*
*********************************************************************************************************
*	  :  void JudgeMinus()
*	˵: ʾ
*	    ΣpageNum ҳ unitNum λ
*	  ֵ: 
*********************************************************************************************************
*/
void JudgeMinus(float* data,u8 size)
{
	float temp1=0,temp2=0,temp3=0,temp4=0;

	if(size==4)
	{
		temp1=*data;//Сȥ Ȼ
		temp2=*(((float*)(data))+1);
		temp3=*(((float*)(data))+2);
		temp4=*(((float*)(data))+3);
		
		if(temp1<0)
			MinusFlag[0]=1;
		else
			MinusFlag[0]=0;
		if(temp2<0)
			MinusFlag[1]=1;
		else
			MinusFlag[1]=0;
		if(temp3<0)
			MinusFlag[2]=1;
		else
			MinusFlag[2]=0;
		if(temp4<0)
			MinusFlag[3]=1;
		else
			MinusFlag[3]=0;
	}
	else if(size==3)
	{
		temp1=*data;//Сȥ Ȼ
		temp2=*(((float*)(data))+1);
		temp3=*(((float*)(data))+2);
		if(temp1<0)
			MinusFlag[0]=1;
		else
			MinusFlag[0]=0;
		if(temp2<0)
			MinusFlag[1]=1;
		else
			MinusFlag[1]=0;
		if(temp3<0)
			MinusFlag[2]=1;
		else
			MinusFlag[2]=0;
		
		MinusFlag[3]=0;
	}
	else if(size==1)
	{
		temp1=*data;//Сȥ Ȼ
		if(temp1<0)
			MinusFlag[3]=1;
		else
			MinusFlag[3]=0;
		
		MinusFlag[0]=0;
		MinusFlag[1]=0;
		MinusFlag[2]=0;
	}
}
 
 
 /*
*********************************************************************************************************
*	  :  u8 GetDatalength
*	˵: ȡݳ
*	    Σ
*	  ֵ: 
*********************************************************************************************************
*/
u8 GetDatalength(float* data)
{
	float temp=(*data)/10;
	if(temp<0.1f)
		return 0;
	else if(temp>=0.1f&&temp<1.0f)
		return 1;	
	else if(temp>=1.0f&&temp<10.0f)
		return 2;
	else if(temp>=10.0f&&temp<100.0f)
		return 3;
	else if(temp>=100.0f&&temp<1000.0f)
		return 4;
	else if(temp>=1000.0f&&temp<10000.0f)
		return 5;
	else if(temp>=10000.0f&&temp<100000.0f)
		return 6;
	else if(temp>=100000.0f&&temp<1000000.0f)
		return 7;
	else if(temp>=1000000.0f&&temp<1000000.0f)
		return 8;
	else if(temp>=10000000.0f&&temp<10000000.0f)
		return 9;
	else 
		return 0;
}

/*
*********************************************************************************************************
*	  :  void displaySettingPage()
*	˵: ʾҳ
*	    Σ
*	  ֵ: 
*********************************************************************************************************
*/
void displaySettingPage(void)
{
		if(KEY2_ENTER_First_sel==0 && KEY2_ENTER==1)  //********************************
		{
			ht16c23_write_one_byte2ram(0x23,0x01);  // 
			ht16c23_write_one_byte2ram(0x01,0x80);  //  ַ

			DisplayFirstLine(4,ADDR_Num_Single);//ʾλʮλ
			DisplayFirstLine(3,ADDR_Num_Tens);
			DisplaySecondLine(4,20);//ֹʾ
			DisplaySecondLine(3,20);
		}
		if(KEY2_ENTER_First_sel==0 &&KEY2_ENTER==2 && KEY2_ENTER_ADDR_selLocation==1)
		{
			ht16c23_write_one_byte2ram(0x23,0x01);  // 
			ht16c23_write_one_byte2ram(0x01,0x80);  //  ַ
			DisplayFirstLine(4,ADDR_Num_Single);
			DisplayFirstLine(3,ADDR_Num_Tens);
//			DisplaySecondLine(4,20);
			delay_ms(250);				  
			DisplayFirstLine(4,20);//˸
			DisplaySecondLine(4,20);//ֹʾ
			DisplaySecondLine(3,20);
			delay_ms(250);		
		}
		else if(KEY2_ENTER_First_sel==0 &&KEY2_ENTER==2&&KEY2_ENTER_ADDR_selLocation==2)
		{
			ht16c23_write_one_byte2ram(0x23,0x01);  // 
			ht16c23_write_one_byte2ram(0x01,0x80);  //  ַ
			DisplayFirstLine(3,ADDR_Num_Tens);
			DisplayFirstLine(4,ADDR_Num_Single);
//			DisplaySecondLine(3,20);//˸
			delay_ms(250);				  
			DisplayFirstLine(3,20);
			DisplaySecondLine(3,20);//ֹʾ
			DisplaySecondLine(4,20);
			delay_ms(250);		
		}
		
		else if(KEY2_ENTER_First_sel==1 && KEY2_ENTER==1)             //***************************
		{
			ht16c23_write_one_byte2ram(0x23,0x01);  // 
			ht16c23_write_one_byte2ram(0x01,0x08);  //  
			
			DisplaySecondLine(4,BOUNDSEL);
			DisplayFirstLine(4,20);
		}
			
		else if(KEY2_ENTER_First_sel==1 && KEY2_ENTER==2 )// ò   && (KEY2_HCJ==2 || KEY2_HCJ==3)
		{				
				ht16c23_write_one_byte2ram(0x23,0x01);  // 
				ht16c23_write_one_byte2ram(0x01,0x08);  //  

				DisplaySecondLine(4,BOUNDSEL);
				delay_ms(250);//ѡʱ˸
				DisplaySecondLine(4,20);
				delay_ms(250);
		}

			else if(KEY2_ENTER_First_sel==2 && KEY2_ENTER==1)     //*********************
			{
				ht16c23_write_one_byte2ram(0x23,0x01);  // 
				ht16c23_write_one_byte2ram(0x0c,0x80);  //  CT
				
				DisplayThirdLine(4,CT_Single);
				DisplayThirdLine(3,CT_Tens);
				DisplayThirdLine(2,CT_Huns);
				
				DisplayFourthLine(4,20);
				DisplayFourthLine(3,20);
				DisplayFourthLine(2,20);
			}
			else if(KEY2_ENTER_First_sel==2 && KEY2_ENTER==2 && KEY2_CT_selLocation==1)// CT****************************
			{
				ht16c23_write_one_byte2ram(0x23,0x01);  // 
				ht16c23_write_one_byte2ram(0x0c,0x80);  //  CT
				DisplayThirdLine(4,CT_Single);
				DisplayThirdLine(3,CT_Tens);
				DisplayThirdLine(2,CT_Huns);
				delay_ms(250);
				DisplayThirdLine(4,20);
				delay_ms(250);
			}				

			else if(KEY2_ENTER_First_sel==2 && KEY2_ENTER==2 && KEY2_CT_selLocation==2)// CT****************************
			{
				ht16c23_write_one_byte2ram(0x23,0x01);  // 
				ht16c23_write_one_byte2ram(0x0c,0x80);  //  CT
				DisplayThirdLine(4,CT_Single);
				DisplayThirdLine(3,CT_Tens);
				DisplayThirdLine(2,CT_Huns);
				delay_ms(250);
				DisplayThirdLine(3,20);
				delay_ms(250);
			}

			else if(KEY2_ENTER_First_sel==2 && KEY2_ENTER==2 && KEY2_CT_selLocation==3)// CT****************************
			{
				ht16c23_write_one_byte2ram(0x23,0x01);  // 
				ht16c23_write_one_byte2ram(0x0c,0x80);  //  CT
				DisplayThirdLine(4,CT_Single);
				DisplayThirdLine(3,CT_Tens);
				DisplayThirdLine(2,CT_Huns);
				delay_ms(250);
				DisplayThirdLine(2,20);
				delay_ms(250);
			}
			
			else if(KEY2_ENTER_First_sel==3 && KEY2_ENTER==1)
			{
				ht16c23_write_one_byte2ram(0x23,0x01);  // 
				ht16c23_write_one_byte2ram(0x0c,0x08);  //  PT
				
				DisplayFourthLine(4,PT_Single);
				DisplayFourthLine(3,PT_Tens);
				DisplayFourthLine(2,PT_Huns);
				
				DisplayThirdLine(4,20);
				DisplayThirdLine(3,20);
				DisplayThirdLine(2,20);
			}				
			
			
			else if(KEY2_ENTER_First_sel==3 && KEY2_ENTER==2 && KEY2_PT_selLocation==1)// PT****************************
			{
				ht16c23_write_one_byte2ram(0x23,0x01);  // 
				ht16c23_write_one_byte2ram(0x0c,0x08);  //  PT
				DisplayFourthLine(4,PT_Single);
				DisplayFourthLine(3,PT_Tens);
				DisplayFourthLine(2,PT_Huns);
				delay_ms(250);
				DisplayFourthLine(4,20);
				delay_ms(250);
			}				

			else if(KEY2_ENTER_First_sel==3 && KEY2_ENTER==2 && KEY2_PT_selLocation==2)// PT****************************
			{
				ht16c23_write_one_byte2ram(0x23,0x01);  // 
				ht16c23_write_one_byte2ram(0x0c,0x08);  //  PT
				DisplayFourthLine(4,PT_Single);
				DisplayFourthLine(3,PT_Tens);
				DisplayFourthLine(2,PT_Huns);
				delay_ms(250);
				DisplayFourthLine(3,20);
				delay_ms(250);
			}

			else if(KEY2_ENTER_First_sel==3 && KEY2_ENTER==2 && KEY2_PT_selLocation==3)// PT****************************
			{
				ht16c23_write_one_byte2ram(0x23,0x01);  // 
				ht16c23_write_one_byte2ram(0x0c,0x08);  //  PT
				DisplayFourthLine(4,PT_Single);
				DisplayFourthLine(3,PT_Tens);
				DisplayFourthLine(2,PT_Huns);
				delay_ms(250);
				DisplayFourthLine(2,20);
				delay_ms(250);
			}			
}


#ifdef  USE_FULL_ASSERT
/**
  * @brief  Reports the name of the source file and the source line number
  *         where the assert_param error has occurred.
  * @param  file: pointer to the source file name
  * @param  line: assert_param error line source number
  * @retval None
  */
void assert_failed(char *file, uint32_t line)
{ 
  /* USER CODE BEGIN 6 */
  /* User can add his own implementation to report the file name and line number,
     tex: printf("Wrong parameters value: file %s on line %d\r\n", file, line) */
  /* USER CODE END 6 */
}
#endif /* USE_FULL_ASSERT */

/************************ (C) COPYRIGHT STMicroelectronics *****END OF FILE****/
