#include "led.h"
#include "usart.h"
#include "delay.h"

extern DataStructure DataStruc;

extern u8 Delay_cnter;



void LEDInit(void)
{

	GPIO_InitTypeDef GPIO_InitStructure;
	
	RCC_AHBPeriphClockCmd(RCC_AHBPeriph_GPIOB,ENABLE);
	GPIO_InitStructure.GPIO_Pin=GPIO_Pin_1|GPIO_Pin_3|GPIO_Pin_4;
	GPIO_InitStructure.GPIO_Mode=GPIO_Mode_OUT;
	GPIO_InitStructure.GPIO_OType=GPIO_OType_PP;
	GPIO_InitStructure.GPIO_PuPd=GPIO_PuPd_DOWN;
	GPIO_InitStructure.GPIO_Speed=GPIO_Speed_Level_3;
	GPIO_Init(GPIOB,&GPIO_InitStructure);


}


void LEDHandle(void)
{
	if(Delay_cnter>50)
	{
		if(DataStruc.SIDState==1)
			TURNLED1();
		if(DataStruc.NetState==1)
			TURNLED2();
		if(DataStruc.SIMState==1)
			TURNLED3();
		else if(DataStruc.SIDState==0&&DataStruc.NetState==0&&DataStruc.SIMState==0)
		{
			TURNLED1();
			TURNLED2();
			TURNLED3();
		}
		Delay_cnter=0;
  }
}



