#include "delay.h"
#include	"key.h"
#include "stm32f0xx_it.h"
#include "stm32f0xx_tim.h"
#define  u8  unsigned char
#define  u16  unsigned int

u8 keycnter=0;
u8 KeyPressFlag[4]={0};

static int8_t  fac_us=0;//us
static int16_t fac_ms=0;//ms

u8 Delay_cnter=0;
u16 SendDelay_Counter=0;
void TIM3_Init(void)//50ms
{
  TIM_TimeBaseInitTypeDef          TIM_TimeBaseInitStructure;
	NVIC_InitTypeDef                NVIC_InitStructure;

	RCC_APB1PeriphClockCmd(RCC_APB1Periph_TIM3, ENABLE);  //tim3ʱʹ,APBʱ48M
				 
	TIM_TimeBaseInitStructure.TIM_ClockDivision = TIM_CKD_DIV1; //ƵϵΪ1
	TIM_TimeBaseInitStructure.TIM_CounterMode = TIM_CounterMode_Up; //ϼ
	TIM_TimeBaseInitStructure.TIM_Period = 999;
	TIM_TimeBaseInitStructure.TIM_Prescaler = 959;  //ʱ500ms
	TIM_TimeBaseInit(TIM3, &TIM_TimeBaseInitStructure);


	TIM_ClearITPendingBit(TIM3,TIM_IT_Update);
	TIM_ITConfig(TIM3,TIM_IT_Update,ENABLE); //ʱ3ж
	TIM_Cmd(TIM3,ENABLE); //ʹܶʱ3       


	NVIC_InitStructure.NVIC_IRQChannel = TIM3_IRQn; //ʱ3ж
	NVIC_InitStructure.NVIC_IRQChannelPriority = 2; //ȼ0
	NVIC_InitStructure.NVIC_IRQChannelCmd = ENABLE;
	NVIC_Init(&NVIC_InitStructure);
 
}

void TIM3_IRQHandler(void)
{
       
	if(TIM_GetITStatus(TIM3,TIM_IT_Update) != RESET) //ж
	{
			HAL_TIM_PeriodElapsedCallback();
	}
	TIM_ClearITPendingBit(TIM3,TIM_IT_Update);  //жϱ־λ
}
void delay_init()	 
{
	SysTick_CLKSourceConfig(SysTick_CLKSource_HCLK_Div8);//ѡⲿʱ  HCLK/8
	
	fac_us=SystemCoreClock/8000000;	//Ϊϵͳʱӵ1/8  
	fac_ms=(int16_t)fac_us*1000;//ÿmsҪsystickʱ 
	
}	
//ʱNus

void delay_us(int32_t nus)
{		
	int32_t temp;	    	 
	SysTick->LOAD=nus*fac_us; //ʱ	  		 
	SysTick->VAL=0x00;        //ռ
	SysTick->CTRL|=SysTick_CTRL_ENABLE_Msk ;          //ʼ	 
	do
	{
		temp=SysTick->CTRL;
	}
	while(temp&0x01&&!(temp&(1<<16)));//ȴʱ䵽   
	SysTick->CTRL&=~SysTick_CTRL_ENABLE_Msk;       //رռ
	SysTick->VAL =0X00;       //ռ	 
}
//void delay_us(int32_t nus)
//{
//	for( ;nus>0;nus--)
//	{
//			__NOP();
//		
//	}
//}
//ʱNms

void delay_ms(int16_t nms)
{	 		  	  
	int32_t temp;		   
	SysTick->LOAD=(int32_t)nms*fac_ms;//ʱ(SysTick->LOADΪ24bit)
	SysTick->VAL =0x00;           //ռ
	SysTick->CTRL|=SysTick_CTRL_ENABLE_Msk ;          //ʼ  
	do
	{
		temp=SysTick->CTRL;
	}
	while(temp&0x01&&!(temp&(1<<16)));//ȴʱ䵽   
	SysTick->CTRL&=~SysTick_CTRL_ENABLE_Msk;       //رռ
	SysTick->VAL =0X00;       //ռ	  	    
} 


void HAL_TIM_PeriodElapsedCallback()
{
	
		static u8 key_up=1;//ɿ־
		Delay_cnter++;
		SendDelay_Counter++;
		if(key_up&&(KEY1==0||KEY2==0||KEY3==0 ||KEY4==0))
		{
			key_up=0;
			delay_ms(10);
			if(KEY1==0)	
			{
				// KeyPressFlag[0]=1;
				KeyPressFlag[3]=1;  //Enter  
			}
			else if(KEY2==0)
			{
				 KeyPressFlag[1]=1; //menu
			}					
			else if(KEY3==0)
			{
				KeyPressFlag[0]=1;  //right
			}					
			else if(KEY4==0)	
			{
				KeyPressFlag[2]=1;  //left
			}	
		}
		else if(KEY1==1 && KEY2==1 && KEY3==1 && KEY4==1)
		{
			 key_up=1; 
		}

}
