/* USER CODE BEGIN Header */
/**
  ******************************************************************************
  * @file           : main.h
  * @brief          : Header for main.c file.
  *                   This file contains the common defines of the application.
  ******************************************************************************
  * @attention
  *
  * <h2><center>&copy; Copyright (c) 2020 STMicroelectronics.
  * All rights reserved.</center></h2>
  *
  * This software component is licensed by ST under BSD 3-Clause license,
  * the "License"; You may not use this file except in compliance with the
  * License. You may obtain a copy of the License at:
  *                        opensource.org/licenses/BSD-3-Clause
  *
  ******************************************************************************
  */
/* USER CODE END Header */

/* Define to prevent recursive inclusion -------------------------------------*/
#ifndef __MAIN_H
#define __MAIN_H

#ifdef __cplusplus
extern "C" {
#endif

/* Includes ------------------------------------------------------------------*/
#include "stm32f0xx.h"
#include "stm32f0xx_it.h"
#include "usart.h"
/* Private includes ----------------------------------------------------------*/
/* USER CODE BEGIN Includes */

/* USER CODE END Includes */

/* Exported types ------------------------------------------------------------*/
/* USER CODE BEGIN ET */

/* USER CODE END ET */

/* Exported constants --------------------------------------------------------*/
/* USER CODE BEGIN EC */
#define PAGE0  0
#define PAGE1  1
#define PAGE2  2
#define PAGE3  3
#define PAGE4  4
#define PAGE5  5
#define PAGE6  6
#define PAGE7  7
#define PAGE8  8
#define PAGE9  9
#define PAGE10 10
#define PAGE11 11
#define PAGE12 12
#define PAGE13 13
#define PAGE14 14
#define PAGE15 15
#define PAGE16 16


#define V					 0
#define KV				 1
#define A	  			 2
#define KA				 3
#define KW				 5
#define MV				 6
#define VA				 7
#define KVA				 8
#define MVA				 9
#define C	  			 10
#define PERCENT	   11
#define MA	   		 12
#define HZ	   		 13
#define KVAR	   	 14
#define MVAR	   	 15

#define BOUND2400	 	 	1
#define BOUND9600	 		2
#define BOUND19200 		3
#define BOUND115200	 	4


#define	ADDR			 1
#define	BOUND			 2
#define CT				 3	
#define	PT				 4

#define	CTNUM_TWO					 2
#define	CTNUM_THREE				 3


#define  u8  unsigned char
#define  u16  unsigned int
#define  u32  unsigned long	
extern const unsigned char Play1_5_1[];
extern const u8	Play1_5_spec1[];
extern const u8	Play1_5_spec2[];


extern DataStructure DataStruc;

extern void ExistRXInformation(void);



/* USER CODE END EC */

/* Exported macro ------------------------------------------------------------*/
/* USER CODE BEGIN EM */

/* USER CODE END EM */

/* Exported functions prototypes ---------------------------------------------*/
void Error_Handler(void);

void displaySettingPage(void);
void displayPageInformation(u8 pageNum,DataStructure* data);
void displaySettingInfo(u8 Item);
void ShowUnitAndFrame(u8 unitNum);
void displayADIO(float* data); 
void displayCtnum(u8 pageNum);
void displayDIDO(float* data);
void displayLoadRatio(float* data);
void displayPower(float* data);
u8 GetDatalength(float* data);
void displayPowerData(float* data);
void displayPDataSpec(float* data);
void displayUIData(float* data);
void displayPData(float* data);
void displayFreq(float* data);
void displayHarmU(float* data);
void displayHarmI(float* data);
void displayMD(float* data);
void JudgeMinus(float* data,u8 size);
void displayLoadRatioOnlyNum(float* data);
void displayLC(float* data);
void displayTempata(float* data);
void displayPDataSpecVA(float* data);
unsigned char ch;

float  Powertemp=0;
float  Mdtemp=0;
u8 		 Hzdisplay=0;
u8 		 Thdudisplay=0;
u8 		 LCdisplay=0;
u8 		 TEMPdisplay=0;

u8     MinusFlag[4]={0};

u8 KEY_Scan(void);


extern u8 ADDR_Num_Single;
extern u8 ADDR_Num_Tens;
extern u8 CT_Single;
extern u8 CT_Tens;
extern u8 CT_Huns;

extern u8 PT_Single;
extern u8 PT_Tens;
extern u8 PT_Huns;

extern u8 MENUnum;
extern u8 BOUNDSEL;
extern int KEY2_ENTER;
extern int KEY2_ENTER_First_sel;
extern int KEY2_ENTER_ADDR_selLocation; 
extern int KEY2_CT_selLocation;
extern int KEY2_PT_selLocation;

#ifdef __cplusplus
}
#endif

#endif /* __MAIN_H */

/************************ (C) COPYRIGHT STMicroelectronics *****END OF FILE****/
