# 前后端交互

## 响应结果

> 响应结果形如以下结构
```js
{
    code: 200, // 按照http状态直接返回就好（可自定义状态）
    data: {},  // 返回数据
    message: "", // 返回参考信息（可以不返回该字段）
    srvTime："2020-07-06 12:00:00" // 当前服务器信息
}
```

> 参考信息如下：

-   自定义响应状态
```js
{
    code: 10001, // 无该页面访问权限
    message: "无该页面访问权限",
    srvTime："2020-07-06 12:00:00", // 当前服务器信息
}


{
    code: 10002, // 无该页面访问权限
    message: "无该页面访问权限",
    srvTime："2020-07-06 12:00:00" // 当前服务器信息
}
```

-   返回数据
```js
// 正常情况下
{
    code: 200,
    data: {
        class: "五年一班",
        memberCount: 30,
        member: [
            {name: '小明', age: 11},
            {name: '小红', age: 13},
            {name: '小白', age: 12},
        ]
    },
    srvTime: "2020-07-06 12:00:00"
}

// 字符串数据不存在的时候,返回空字符串
{
    code: 200,
    data: {
        class: "",
        memberCount: 30,
        member: [
            {name: '小明', age: 11},
            {name: '小红', age: 13},
            {name: '小白', age: 12},
        ]
    },
    srvTime: "2020-07-06 12:00:00"
}

// int类型数据不存在的时候，字段不返回
{
    code: 200,
    data: {
        class: "五年一班",
        member: [
            {name: '小明', age: 11},
            {name: '小红', age: 13},
            {name: '小白', age: 12},
        ]
    },
    srvTime: "2020-07-06 12:00:00"
}


// 数组查询为空，返回空数组
{
    code: 200,
    data: {
        class: "五年一班",
        memberCount: 30,
        member: []
    },
    srvTime: "2020-07-06 12:00:00"
}
```

-   message返回情况
```js
// 接口访问无权限
{
    code: 10001,
    message: "无权限",
    srvTime: "2020-07-06 12:00:00"
}

// 修改类
{
    code: 200,
    data: {
      ---
    },
    message: "修改成功 | 修改失败",
    srvTime: "2020-07-06 12:00:00"
}

// 上传类
{
    code: 200 | 10003,
    data: {
      ---
    },
    message: "上传成功 | 上传失败",
    srvTime: "2020-07-06 12:00:00"
}

// 请求错误
{
    code: 500,
    data: {
      ---
    },
    message: "error message", // 错误信息返回明确 比如 sql报错，或者其他问题， 便于定位错误
    srvTime: "2020-07-06 12:00:00"
}
```