const ua = navigator.userAgent.toLowerCase()
const testUA = (regexp) => regexp.test(ua)
const isSafari = testUA(/safari/g) && !testUA(/chrome/g)
const isWeChat = testUA(/micromessenger/g)

// 用电量、上送电量
const echart1Data = {
  date: ['8/17', '8/18', '8/19', '8/20', '8/21', '8/22', '8/23'],
  line1: [200, 190, 250, 100, 90, 100, 250],
  line2: [100, 90, 200, 80, 60, 50, 200],
}

// 楼层负荷、充电桩负荷
const echart2Data = {
  date: ['8/17', '8/18', '8/19', '8/20', '8/21', '8/22', '8/23'],
  line1: [0.02, 0.3, 0.5, 1, 0.2, 0.3, 0.5],
  line2: [0.01, 0.1, 0.2, 1, 0.5, 0.3, 0.8],
}

// 负荷预测、负荷功率
const echart3Data = {
  date: [
    '0',
    '1',
    '2',
    '3',
    '4',
    '5',
    '6',
    '7',
    '8',
    '9',
    '10',
    '11',
    '12',
    '13',
    '14',
    '15',
    '16',
    '17',
    '18',
    '19',
    '20',
    '21',
    '22',
    '23',
    '24',
  ],
  line1: [
    0.02, 0.03, 0.05, 0.05, 0.02, 0.03, 1, 0.02, 0.03, 0.05, 0.05, 0.02, 0.03,
    0.02, 0.02, 0.03, 0.05, 0.05, 0.02, 0.03, 0.02, 0.05, 0.02, 0.03, 0.1,
  ],
  line2: [
    0.03, 0.02, 0.02, 0.03, 0.05, 0.05, 0.02, 1, 0.02, 0.02, 0.03, 0.05, 0.05,
    0.02, 0.03, 0.02, 0.05, 0.02, 0.03, 0.02, 0.02, 0.03, 0.05, 0.05, 0.02,
  ],
}

// 光伏发电量、碳减排量
const echart4Data = {
  date: ['8/17', '8/18', '8/19', '8/20', '8/21', '8/22', '8/23'],
  line1: [0.02, 0.03, 0.05, 0.05, 0.02, 0.03, 0.01],
  line2: [0.01, 0.01, 0.02, 0.03, 0.1, 0.03, 0.02],
}

// AC/DC、储能、光伏、负荷
const echart5Data = {
  date: [
    '0',
    '1',
    '2',
    '3',
    '4',
    '5',
    '6',
    '7',
    '8',
    '9',
    '10',
    '11',
    '12',
    '13',
    '14',
    '15',
    '16',
    '17',
    '18',
    '19',
    '20',
    '21',
    '22',
    '23',
    '24',
  ],
  line1: [
    100, 190, 250, 100, 90, 100, 250, 100, 190, 250, 100, 90, 100, 250, 100,
    190, 250, 100, 90, 100, 250, 100, 190, 250, 100, 90, 100,
  ],
  line2: [
    200, 90, 200, 100, 90, 100, 200, 190, 250, 100, 90, 100, 250, 100, 190, 250,
    100, 90, 100, 250, 100, 1000, 100, 250, 500,
  ],
  line3: [
    300, 90, 200, 100, 90, 100, 200, 190, 250, 100, 90, 100, 250, 100, 190, 250,
    100, 90, 100, 250, 100, 1000, 100, 250, 400,
  ],
  line4: [
    400, 90, 200, 100, 90, 100, 200, 190, 250, 100, 90, 100, 250, 100, 190, 250,
    100, 90, 100, 250, 100, 1000, 100, 250, 300,
  ],
}

// 光伏预测、光伏功率
const echart6Data = {
  date: [
    '0',
    '1',
    '2',
    '3',
    '4',
    '5',
    '6',
    '7',
    '8',
    '9',
    '10',
    '11',
    '12',
    '13',
    '14',
    '15',
    '16',
    '17',
    '18',
    '19',
    '20',
    '21',
    '22',
    '23',
    '24',
  ],
  line1: [
    0.02, 0.03, 0.05, 0.05, 0.02, 0.03, 0.02, 0.02, 0.03, 0.05, 0.05, 0.02,
    0.03, 0.02, 0.02, 0.03, 0.05, 1, 0.02, 0.03, 0.02, 0.05, 0.02, 0.03, 0.05,
  ],
  line2: [
    0.03, 0.02, 0.02, 0.03, 0.05, 0.05, 0.02, 0.03, 0.02, 0.02, 0.03, 0.05,
    0.05, 0.02, 0.03, 0.02, 0.05, 1, 0.03, 0.02, 0.02, 0.03, 0.05, 0.05, 0.05,
  ],
}

/**
 * echartjs 曲线图通用配置
 * @param {type: array, desc: x轴数据} xData
 * @param {type: array, desc: y轴数据 } yData
 * */
const lineChartOption = (xData, yData, interval) => {
  const series = []
  yData.forEach((item) => {
    series.push({
      data: item.data,
      color: item.color,
      areaStyle: item.areaColor
        ? {
            color: new echarts.graphic.LinearGradient(0, 0, 0, 1, [
              {
                offset: 0,
                color: item.areaColor[0],
              },
              {
                offset: 1,
                color: item.areaColor[1],
              },
            ]),
          }
        : null,
      type: 'line',
      smooth: true,
      symbol: 'none',
    })
  })

  return {
    tooltip: {
      trigger: 'axis',
    },
    grid: {
      top: '5%',
      bottom: '15%',
      right: '5%',
    },
    xAxis: {
      data: xData,
      type: 'category',
      axisLine: { show: false },
      axisTick: { show: false },
      splitLine: false,
      boundaryGap: false,
      axisLabel: {
        color: '#7c90c8',
        fontSize: 10,
        margin: 15,
        interval,
      },
    },
    yAxis: {
      type: 'value',
      axisLine: { show: false },
      axisTick: { show: false },
      splitLine: false,
      axisLabel: {
        color: '#7c90c8',
        fontSize: 10,
        margin: 15,
      },
    },
    series,
  }
}

// 创建多组数字
function createMultiSrollNum(numArr, width, height) {
  const scrollBox = document.getElementsByClassName('scroll-box')
  for (let i = 0; i < scrollBox.length; i++) {
    const scrollNode = scrollBox[i]
    const childNumArr = numArr[i].split('')
    scrollNode.style.setProperty('--width', width + 'px')
    scrollNode.style.setProperty('--height', height + 'px')
    const docFrag = document.createDocumentFragment()
    childNumArr.forEach((num, i) => {
      docFrag.appendChild(createSrollNum(num))
    })
    scrollNode.appendChild(docFrag)
  }
}

// 创建单个数字
function createSrollNum(num) {
  const scrollNumNode = document.createElement('div')
  scrollNumNode.className = 'scroll-num'
  scrollNumNode.innerHTML = `<ul class="scroll-ul">
  <li>0</li>
  <li>1</li>
  <li>2</li>
  <li>3</li>
  <li>4</li>
  <li>5</li>
  <li>6</li>
  <li>7</li>
  <li>8</li>
  <li>9</li>
  <li>0</li>
  </ul>`

  const ulNode = scrollNumNode.childNodes[0]
  ulNode.setAttribute(
    'style',
    'transform: translateY(' + num * -9.09 + '%)'
  )
  return scrollNumNode
}

// 创建多组数字动画
function addMultiDigitAnimate(beforeNumArr, afterNumArr, delays, numArr) {
  const scrollBox = document.getElementsByClassName('scroll-box')
  for (let i = 0; i < scrollBox.length; i++) {
    const scrollBoxNode = scrollBox[i]
    const scrollNum = scrollBoxNode.childNodes
    addDigitAnimate(scrollNum, beforeNumArr[i], afterNumArr[i])
  }
}

// 创建单个数字动画
function addDigitAnimate(scrollNum, beforeNumArr, afterNumArr) {
  let delay = 0

  for (let i = scrollNum.length - 1; i >= 0; i--) {
    const scrollNumNode = scrollNum[i]
    scrollNumNode.style.setProperty('--i', beforeNumArr[i])
    scrollNumNode.style.setProperty('--j', afterNumArr[i])

    const d = Math.abs(beforeNumArr[i] - afterNumArr[i]) * 0.3
    scrollNumNode.style.setProperty('--duration', d)
    scrollNumNode.style.setProperty('--delay', delay)
    delay += d * 0.9

    const ulNode = scrollNumNode.childNodes[0]
    ulNode.classList.remove('animate')
    ulNode.setAttribute(
      'style',
      'transform: translateY(' + beforeNumArr[i] * -9.09 + '%)'
    )

    setTimeout(() => {
      ulNode.classList.add('animate')
    }, 0)

    if (isSafari || isWeChat) {
      let timer = setTimeout(() => {
        ulNode.setAttribute(
          'style',
          'animation: none;transform: translateY(' +
            afterNumArr[i] * -9.09 +
            '%)'
        )
        timer = null
      }, delay * 1000)
    }
  }
}

function createRandom() {
  const arr = []
  for (let i = 0; i < 4; i++) {
    let str = ''
    for (let j = 0; j < 5; j++) {
      const num = Math.floor(Math.random() * 10) + ''
      str += num
    }
    arr.push(str)
  }
  return arr
}

window.onload = () => {
  // echart渲染
  const lineChart1 = echarts.init(document.getElementById('line_chart_1'))
  lineChart1.setOption(
    lineChartOption(echart1Data.date, [
      {
        data: echart1Data.line1,
        color: '#4a76cf',
        areaColor: ['rgba(23,71,153, 1)', 'rgba(23,71,153, 0)'],
      },
      {
        data: echart1Data.line2,
        color: '#2dc9e3',
        areaColor: ['rgba(0,105,107, 1)', 'rgba(0,105,107, 0)'],
      },
    ])
  )

  const lineChart2 = echarts.init(document.getElementById('line_chart_2'))
  lineChart2.setOption(
    lineChartOption(echart2Data.date, [
      {
        data: echart2Data.line1,
        color: '#4a76cf',
        areaColor: ['rgba(23,71,153, 1)', 'rgba(23,71,153, 0)'],
      },
      {
        data: echart2Data.line2,
        color: '#2dc9e3',
        areaColor: ['rgba(0,105,107, 1)', 'rgba(0,105,107, 0)'],
      },
    ])
  )

  const lineChart3 = echarts.init(document.getElementById('line_chart_3'))
  lineChart3.setOption(
    lineChartOption(
      echart3Data.date,
      [
        {
          data: echart3Data.line1,
          color: '#4a76cf',
          areaColor: ['rgba(23,71,153, 1)', 'rgba(23,71,153, 0)'],
        },
        {
          data: echart3Data.line2,
          color: '#2dc9e3',
          areaColor: ['rgba(0,105,107, 1)', 'rgba(0,105,107, 0)'],
        },
      ],
      3
    )
  )

  const lineChart4 = echarts.init(document.getElementById('line_chart_4'))
  lineChart4.setOption(
    lineChartOption(echart4Data.date, [
      {
        data: echart4Data.line1,
        color: '#4a76cf',
        areaColor: ['rgba(23,71,153, 1)', 'rgba(23,71,153, 0)'],
      },
      {
        data: echart4Data.line2,
        color: '#2dc9e3',
        areaColor: ['rgba(0,105,107, 1)', 'rgba(0,105,107, 0)'],
      },
    ])
  )

  const lineChart5 = echarts.init(document.getElementById('line_chart_5'))
  lineChart5.setOption(
    lineChartOption(
      echart5Data.date,
      [
        {
          data: echart5Data.line1,
          color: '#f1ec41',
        },
        {
          data: echart5Data.line2,
          color: '#c49ffe',
        },
        {
          data: echart5Data.line3,
          color: '#4a76cf',
        },
        {
          data: echart5Data.line4,
          color: '#2dc9e3',
        },
      ],
      3
    )
  )

  const lineChart6 = echarts.init(document.getElementById('line_chart_6'))
  lineChart6.setOption(
    lineChartOption(
      echart6Data.date,
      [
        {
          data: echart6Data.line1,
          color: '#4a76cf',
          areaColor: ['rgba(23,71,153, 1)', 'rgba(23,71,153, 0)'],
        },
        {
          data: echart6Data.line2,
          color: '#2dc9e3',
          areaColor: ['rgba(0,105,107, 1)', 'rgba(0,105,107, 0)'],
        },
      ],
      3
    )
  )

  // 数据统计数字滚动
  const width = 39
  const height = 50

  let beforeNumArr = ['00000', '00000', '00000', '00000']
  let afterNumArr = ['35345', '83460', '36765', '36465']

  // 初始化
  createMultiSrollNum(beforeNumArr, width, height)

  // 开始动画
  addMultiDigitAnimate(beforeNumArr, afterNumArr)

  // 测试，点击第一列数字
  document.getElementsByClassName('scroll-box')[0].onclick = function () {
    const numArr = createRandom()
    beforeNumArr = afterNumArr
    afterNumArr = numArr
    addMultiDigitAnimate(beforeNumArr, afterNumArr)
  }
}
