const gulp = require("gulp");
var less = require('gulp-less');
const browserSync = require("browser-sync").create();
var autoprefixer = require('gulp-autoprefixer');

// less -> css
gulp.task('less', function () {
  return gulp.src(['./src/less/*.less'])
    .pipe(less())
    .pipe(autoprefixer({
      overrideBrowserslist: ['last 20 versions']
    }))
    .pipe(gulp.dest('./src/css'))
});

// 浏览器刷新
gulp.task("watch", function (cb) {
  gulp.watch("./src/less/*.less", gulp.series(['less']));
  browserSync.init(
    {
      files: ["./src/**/*.*"],
      // port: 3001,
      server: {
        baseDir: ['./src']
      }
    },
    function () {
      console.log("browser refreshed.");
    }
  );
  cb();
});

gulp.task("default", gulp.series("watch"));
