const ua = navigator.userAgent.toLowerCase()
const testUA = (regexp) => regexp.test(ua)
const isSafari = testUA(/safari/g) && !testUA(/chrome/g)
const isWeChat = testUA(/micromessenger/g)

// 用电量、上送电量
const echart1Data = {
  date: ['8/17', '8/18', '8/19', '8/20', '8/21', '8/22', '8/23'],
  line1: [200, 190, 250, 100, 90, 100, 250],
  line2: [100, 90, 200, 80, 60, 50, 200],
}

// 楼层负荷、充电桩负荷
const echart2Data = {
  date: ['8/17', '8/18', '8/19', '8/20', '8/21', '8/22', '8/23'],
  line1: [0.02, 0.3, 0.5, 1, 0.2, 0.3, 0.5],
  line2: [0.01, 0.1, 0.2, 1, 0.5, 0.3, 0.8],
}

// 负荷预测、负荷功率
const echart3Data = {
  date: [
    '0',
    '1',
    '2',
    '3',
    '4',
    '5',
    '6',
    '7',
    '8',
    '9',
    '10',
    '11',
    '12',
    '13',
    '14',
    '15',
    '16',
    '17',
    '18',
    '19',
    '20',
    '21',
    '22',
    '23',
    '24',
  ],
  line1: [
    0.02, 0.03, 0.05, 0.05, 0.02, 0.03, 1, 0.02, 0.03, 0.05, 0.05, 0.02, 0.03, 0.02, 0.02, 0.03, 0.05, 0.05, 0.02, 0.03,
    0.02, 0.05, 0.02, 0.03, 0.1,
  ],
  line2: [
    0.03, 0.02, 0.02, 0.03, 0.05, 0.05, 0.02, 1, 0.02, 0.02, 0.03, 0.05, 0.05, 0.02, 0.03, 0.02, 0.05, 0.02, 0.03, 0.02,
    0.02, 0.03, 0.05, 0.05, 0.02,
  ],
}

// 光伏发电量、碳减排量
const echart4Data = {
  date: ['8/17', '8/18', '8/19', '8/20', '8/21', '8/22', '8/23'],
  line1: [0.02, 0.03, 0.05, 0.05, 0.02, 0.03, 0.01],
  line2: [0.01, 0.01, 0.02, 0.03, 0.1, 0.03, 0.02],
}

// AC/DC、储能、光伏、负荷
const echart5Data = {
  date: [
    '0',
    '1',
    '2',
    '3',
    '4',
    '5',
    '6',
    '7',
    '8',
    '9',
    '10',
    '11',
    '12',
    '13',
    '14',
    '15',
    '16',
    '17',
    '18',
    '19',
    '20',
    '21',
    '22',
    '23',
    '24',
  ],
  line1: [
    100, 190, 250, 100, 90, 100, 250, 100, 190, 250, 100, 90, 100, 250, 100, 190, 250, 100, 90, 100, 250, 100, 190, 250,
    100, 90, 100,
  ],
  line2: [
    200, 90, 200, 100, 90, 100, 200, 190, 250, 100, 90, 100, 250, 100, 190, 250, 100, 90, 100, 250, 100, 1000, 100, 250,
    500,
  ],
  line3: [
    300, 90, 200, 100, 90, 100, 200, 190, 250, 100, 90, 100, 250, 100, 190, 250, 100, 90, 100, 250, 100, 1000, 100, 250,
    400,
  ],
  line4: [
    400, 90, 200, 100, 90, 100, 200, 190, 250, 100, 90, 100, 250, 100, 190, 250, 100, 90, 100, 250, 100, 1000, 100, 250,
    300,
  ],
}

// 光伏预测、光伏功率
const echart6Data = {
  date: [
    '0',
    '1',
    '2',
    '3',
    '4',
    '5',
    '6',
    '7',
    '8',
    '9',
    '10',
    '11',
    '12',
    '13',
    '14',
    '15',
    '16',
    '17',
    '18',
    '19',
    '20',
    '21',
    '22',
    '23',
    '24',
  ],
  line1: [
    0.02, 0.03, 0.05, 0.05, 0.02, 0.03, 0.02, 0.02, 0.03, 0.05, 0.05, 0.02, 0.03, 0.02, 0.02, 0.03, 0.05, 1, 0.02, 0.03,
    0.02, 0.05, 0.02, 0.03, 0.05,
  ],
  line2: [
    0.03, 0.02, 0.02, 0.03, 0.05, 0.05, 0.02, 0.03, 0.02, 0.02, 0.03, 0.05, 0.05, 0.02, 0.03, 0.02, 0.05, 1, 0.03, 0.02,
    0.02, 0.03, 0.05, 0.05, 0.05,
  ],
}

// 顶部滚动数字数据
const scrollNumData = {
  beforeNumArr: ["000.00", "000.0", "0000", "00000"],
  afterNumArr: ["003.45", "846.0", "0065", "36465"],
}

// 中间球体数据
const ballData = [11, 22, 33, 44, 55, 66]

// 底部环形数据
const ringData = [11, 22, 33, 44]

/**
 * echartjs 曲线图通用配置
 * @param {type: array, desc: x轴数据} xData
 * @param {type: array, desc: y轴数据 } yData
 * */
const lineChartOption = (xData, yData, interval) => {
  const series = []
  yData.forEach((item) => {
    series.push({
      data: item.data,
      color: item.color,
      areaStyle: item.areaColor
        ? {
            color: new echarts.graphic.LinearGradient(0, 0, 0, 1, [
              {
                offset: 0,
                color: item.areaColor[0],
              },
              {
                offset: 1,
                color: item.areaColor[1],
              },
            ]),
          }
        : null,
      type: 'line',
      smooth: true,
      symbol: 'none',
    })
  })

  return {
    tooltip: {
      trigger: 'axis',
    },
    grid: {
      top: '5%',
      bottom: '15%',
      right: '5%',
    },
    xAxis: {
      data: xData,
      type: 'category',
      axisLine: { show: false },
      axisTick: { show: false },
      splitLine: false,
      boundaryGap: false,
      axisLabel: {
        color: '#7c90c8',
        fontSize: 10,
        margin: 15,
        interval,
      },
    },
    yAxis: {
      type: 'value',
      axisLine: { show: false },
      axisTick: { show: false },
      splitLine: false,
      axisLabel: {
        color: '#7c90c8',
        fontSize: 10,
        margin: 15,
      },
    },
    series,
  }
}

// 创建多组数字
function createMultiSrollNum(numArr) {
  const scrollBox = document.getElementsByClassName('scroll-box')
  for (let i = 0; i < scrollBox.length; i++) {
    const scrollNode = scrollBox[i]
    const childNumArr = numArr[i].split('')
    const docFrag = document.createDocumentFragment()
    childNumArr.forEach((num, i) => {
      docFrag.appendChild(createSrollNum(num))
    })
    scrollNode.appendChild(docFrag)
  }
}

// 创建单个数字
function createSrollNum(num) {
  const scrollNumNode = document.createElement('div')
  if (num === '.') {
    scrollNumNode.className = 'dot'
  } else {
    scrollNumNode.className = 'scroll-num'
    scrollNumNode.innerHTML = '<ul><li>' + num + '</li></ul>'
  }
  return scrollNumNode
}

function getIntervalNumArr(start, end, reduce) {
  const arr = []
  if (reduce) {
    for (let i = end; i > start; i--) {
      arr.push(i)
    }
  } else {
    for (let i = start; i < end; i++) {
      arr.push(i)
    }
  }
  return arr
}

function repeatArr(a, m) {
  let j = []
  for (let i = 0; i < m; i++) {
    j = j.concat(a)
  }
  return j
}

// 创建多组数字动画
function addMultiDigitAnimate(beforeNumArr, afterNumArr) {
  TWEEN.removeAll()
  const scrollBox = document.getElementsByClassName('scroll-box')
  const arr = []
  for (let i = 0; i < scrollBox.length; i++) {
    const scrollNode = scrollBox[i]
    const beforeNum = beforeNumArr[i]
    const afterNum = afterNumArr[i]
    const isUp = Number(afterNum) - Number(beforeNum) >= 0

    const beforeChildNumArr = beforeNum.split('')
    const afterChildNumArr = afterNum.split('')

    const scrollNum = scrollNode.childNodes
    let delay = 0
    const staticDuration = 6000
    let zeroBeforeIndex = 0 // 是否以0开头 标志位
    let zeroAfterIndex = 0 // 是否以0开头 标志位
    let someNumberIndex = 0 // 前面有几位数字相同
    let stopSomeNumber = false // 停止计算前面有几位数字相同

    const digitIndex = beforeChildNumArr.findIndex((ele) => ele === '.') // 小数点
    for (let j = 0; j < beforeChildNumArr.length; j++) {
      if (beforeChildNumArr[j] === '.') {
        continue
      }
      const num = +beforeChildNumArr[j]
      const num2 = +afterChildNumArr[j]

      // 算beforeNum前面的0
      let zeroBeforeFlag = false
      if (num === 0 && zeroBeforeIndex === j) {
        if ((digitIndex > -1 && j < digitIndex - 1) || digitIndex === -1) {
          zeroBeforeFlag = true
          zeroBeforeIndex++
        }
      }

      // 算afterNum前面的0
      let zeroAfterFlag = false
      if (num2 === 0 && zeroAfterIndex === j) {
        if ((digitIndex > -1 && j < digitIndex - 1) || digitIndex === -1) {
          zeroAfterFlag = true
          zeroAfterIndex++
        }
      }

      // 前面有几位数字相同
      if (num === num2 && !stopSomeNumber) {
        someNumberIndex++
      } else {
        stopSomeNumber = true
      }

      let numberArr
      let repeatNum

      if (isUp) {
        if (num2 > num) {
          numberArr = getIntervalNumArr(num, num2)
          repeatNum = getIntervalNumArr(num2, 10).concat(getIntervalNumArr(0, num2))
        } else {
          numberArr = getIntervalNumArr(num2, num, true)
          repeatNum = getIntervalNumArr(0, num2, true).concat([0]).concat(getIntervalNumArr(num2, 9, true))
        }
        numberArr = numberArr.concat(repeatArr(repeatNum, j - someNumberIndex))
        numberArr.push(num2)
      } else {
        if (num2 < num) {
          numberArr = getIntervalNumArr(num2, num, true)
          repeatNum = getIntervalNumArr(0, num2, true).concat([0]).concat(getIntervalNumArr(num2, 9, true))
        } else {
          numberArr = getIntervalNumArr(num, num2)
          repeatNum = getIntervalNumArr(num2, 10).concat(getIntervalNumArr(0, num2))
        }
        numberArr = numberArr.concat(repeatArr(repeatNum, j - someNumberIndex))
        numberArr.push(num2)
        numberArr.reverse()
      }

      const ulNode = scrollNum[j].childNodes[0]
      ulNode.innerHTML = numberArr.map((ele) => '<li>' + ele + '</li>').join('')

      const last = (1 / numberArr.length - 1) * 100
      const start = isUp ? 0 : last
      const lastDelay = delay + staticDuration * 0.03
      const opacityBefore = zeroBeforeFlag ? 0 : 1
      arr.push({
        start,
        end: isUp ? last : 0,
        delay,
        opacityBefore,
        opacityAfter: zeroAfterFlag ? 0 : 1,
        duration: staticDuration - lastDelay,
        ulNode,
      })
      delay = lastDelay
      ulNode.setAttribute('style', 'transform: translateY(' + start + '%);opacity:' + opacityBefore)
    }
  }

  arr.forEach((sObject) => {
    const { start, end, ulNode, delay, duration, opacityBefore, opacityAfter } = sObject
    new TWEEN.Tween({ y: start, opacity: opacityBefore })
      .to({ y: end, opacity: opacityAfter }, duration)
      .delay(delay)
      .easing(TWEEN.Easing.Quintic.Out)
      .onUpdate((object) => {
        ulNode.setAttribute('style', 'transform: translateY(' + object.y + '%);opacity:' + object.opacity)
      })
      .start()
  })

  animate()
}

function createRandom() {
  const arr = []
  for (let i = 0; i < 4; i++) {
    let str = ''
    for (let j = 0; j < 5; j++) {
      const num = Math.floor(Math.random() * 10) + ''
      str += num
    }
    arr.push(str)
  }
  return arr
}

function animate(time) {
  let id = requestAnimationFrame(animate)
  var result = TWEEN.update(time)
  if (!result) cancelAnimationFrame(id)
}

// 设置圆球数据
function setBallData(list) {
  list.forEach((_, idx) => {
    document.querySelector('.ball-l-' + (idx + 1)).innerHTML = list[idx]
  })
}

// 设置环形数据
function setRingData(list) {
  list.forEach((_, idx) => {
    document.querySelector('.s-ring-' + (idx + 1)).innerHTML = list[idx]
  })
}

const leftLineChart = () => {
  // echart渲染
  const lineChart1 = echarts.init(document.getElementById('line_chart_1'))
  lineChart1.setOption(
    lineChartOption(echart1Data.date, [
      {
        data: echart1Data.line1,
        color: '#4a76cf',
        areaColor: ['rgba(23,71,153, 1)', 'rgba(23,71,153, 0)'],
      },
      {
        data: echart1Data.line2,
        color: '#2dc9e3',
        areaColor: ['rgba(0,105,107, 1)', 'rgba(0,105,107, 0)'],
      },
    ])
  )

  const lineChart2 = echarts.init(document.getElementById('line_chart_2'))
  lineChart2.setOption(
    lineChartOption(echart2Data.date, [
      {
        data: echart2Data.line1,
        color: '#4a76cf',
        areaColor: ['rgba(23,71,153, 1)', 'rgba(23,71,153, 0)'],
      },
      {
        data: echart2Data.line2,
        color: '#2dc9e3',
        areaColor: ['rgba(0,105,107, 1)', 'rgba(0,105,107, 0)'],
      },
    ])
  )

  const lineChart3 = echarts.init(document.getElementById('line_chart_3'))
  lineChart3.setOption(
    lineChartOption(
      echart3Data.date,
      [
        {
          data: echart3Data.line1,
          color: '#4a76cf',
          areaColor: ['rgba(23,71,153, 1)', 'rgba(23,71,153, 0)'],
        },
        {
          data: echart3Data.line2,
          color: '#2dc9e3',
          areaColor: ['rgba(0,105,107, 1)', 'rgba(0,105,107, 0)'],
        },
      ],
      3
    )
  )
}

const rightLineChart = () => {
  const lineChart4 = echarts.init(document.getElementById('line_chart_4'))
  lineChart4.setOption(
    lineChartOption(echart4Data.date, [
      {
        data: echart4Data.line1,
        color: '#4a76cf',
        areaColor: ['rgba(23,71,153, 1)', 'rgba(23,71,153, 0)'],
      },
      {
        data: echart4Data.line2,
        color: '#2dc9e3',
        areaColor: ['rgba(0,105,107, 1)', 'rgba(0,105,107, 0)'],
      },
    ])
  )

  const lineChart5 = echarts.init(document.getElementById('line_chart_5'))
  lineChart5.setOption(
    lineChartOption(
      echart5Data.date,
      [
        {
          data: echart5Data.line1,
          color: '#f1ec41',
        },
        {
          data: echart5Data.line2,
          color: '#c49ffe',
        },
        {
          data: echart5Data.line3,
          color: '#4a76cf',
        },
        {
          data: echart5Data.line4,
          color: '#2dc9e3',
        },
      ],
      3
    )
  )

  const lineChart6 = echarts.init(document.getElementById('line_chart_6'))
  lineChart6.setOption(
    lineChartOption(
      echart6Data.date,
      [
        {
          data: echart6Data.line1,
          color: '#4a76cf',
          areaColor: ['rgba(23,71,153, 1)', 'rgba(23,71,153, 0)'],
        },
        {
          data: echart6Data.line2,
          color: '#2dc9e3',
          areaColor: ['rgba(0,105,107, 1)', 'rgba(0,105,107, 0)'],
        },
      ],
      3
    )
  )
}

window.onload = () => {
  /***********************************顶部数字滚动****************************************/

  // 初始化
  createMultiSrollNum(scrollNumData.beforeNumArr)
  // 添加动画
  addMultiDigitAnimate(scrollNumData.beforeNumArr, scrollNumData.afterNumArr)

  // 测试，点击第一列数字
  // document.getElementsByClassName('scroll-box')[0].onclick = function () {
  //   const numArr = createRandom()
  //   beforeNumArr = afterNumArr
  //   afterNumArr = numArr
  //   addMultiDigitAnimate(beforeNumArr, afterNumArr)
  // }

  /***********************************左侧chart线条****************************************/
  leftLineChart()
  /***********************************右侧chart线条****************************************/
  rightLineChart()

  /***********************************中间球体****************************************/
  // 球体数据
  setBallData(ballData)
  /***********************************底部环形****************************************/
  // 环形数据
  setRingData(ringData)
}
