import json
import pytest
from unify_api.tests.constants_t import post_request, get_request


# 返回平台
class TestProduct(object):
    url = "/unify-api/zhiwei-u/warning-operations/product"

    @pytest.mark.asyncio
    async def test_product(self):
        resp_str, status = await get_request(self.url)
        assert status == 200


# 报警类型 工单类型
class TestWarningType(object):
    url = "/unify-api/zhiwei-u/warning-operations/warning-type"

    @pytest.mark.asyncio
    async def test_warning_type(self):
        resp_str, status = await get_request(self.url)
        assert status == 200


# 返回平台
class TestSelectUser(object):
    url = "/unify-api/zhiwei-u/warning-operations/select-user"

    @pytest.mark.parametrize('data', [{
        "prod_id": 0}, {"prod_id": 3}, {"prod_id": 9}
    ])
    @pytest.mark.asyncio
    async def test_select_user(self, data):
        resp_str, status = await post_request(self.url, data)
        assert status == 200
        resp_dict = json.loads(resp_str)
        assert isinstance(resp_dict["data"]["data"], list)


# 平台、客户选择监测点
class TestSelectPoint(object):
    url = "/unify-api/zhiwei-u/warning-operations/select-point"

    @pytest.mark.parametrize('data', [{
        "cid": 44}, {"cid": 117}, {"cid": 119}, {"cid": 10000}, {"cid": 0}
    ])
    @pytest.mark.asyncio
    async def test_select_point(self, data):
        resp_str, status = await post_request(self.url, data)
        assert status == 200
        resp_dict = json.loads(resp_str)
        assert isinstance(resp_dict["data"]["data"], list)


# 运维报警状态改变为已忽略
class TestWarningStateIgnore:
    url = "/unify-api/zhiwei-u/warning-operations/warning-state-ignore"

    @pytest.mark.parametrize('data', [{
        "id": [10, 11, 12, 1000, 0, -1, "15"], "remark": "错误告警"}
    ])
    @pytest.mark.asyncio
    async def test_warning_state_ignore(self, data):
        resp_str, status = await post_request(self.url, data)
        assert status == 200
        resp_dict = json.loads(resp_str)
        assert resp_dict["data"]["success"] == 1

    @pytest.mark.parametrize('data', [{
        "id": [], "remark": ""}, {"id": ["sss"], "remark": ""}
    ])
    @pytest.mark.asyncio
    async def test_warning_state_ignore_no_data(self, data):
        resp_str, status = await post_request(self.url, data)
        assert status == 200
        resp_dict = json.loads(resp_str)
        assert resp_dict["data"]["success"] == 0


# 运维报警 已忽略撤销
class TestWarningStateFocus:
    url = "/unify-api/zhiwei-u/warning-operations/warning-state-focus"

    @pytest.mark.parametrize('data', [{
        "id": [10, 11, 12, 1000, 0, -1, "15"]}
    ])
    @pytest.mark.asyncio
    async def test_warning_state_focus(self, data):
        resp_str, status = await post_request(self.url, data)
        assert status == 200
        resp_dict = json.loads(resp_str)
        assert resp_dict["data"]["success"] == 1

    @pytest.mark.parametrize('data', [{
        "id": []}, {"id": ["sss"]}
    ])
    @pytest.mark.asyncio
    async def test_warning_state_focus_no_data(self, data):
        resp_str, status = await post_request(self.url, data)
        assert status == 200
        resp_dict = json.loads(resp_str)
        assert resp_dict["data"]["success"] == 0


# 运维报警 转为工单
class TestWarningToOrder:
    url = "/unify-api/zhiwei-u/warning-operations/warning-to-order"

    @pytest.mark.parametrize('data', [{
        "id": [10, 11, 12, 1000, 0, -1, "15"], "user_id": 88}
    ])
    @pytest.mark.asyncio
    async def test_warning_to_order(self, data):
        resp_str, status = await post_request(self.url, data)
        assert status == 200
        resp_dict = json.loads(resp_str)
        assert resp_dict["data"]["success"] == 1

    @pytest.mark.parametrize('data', [{
        "id": [], "user_id": 12}, {"id": ["sss"], "user_id": 88}
    ])
    @pytest.mark.asyncio
    async def test_warning_to_order_no_data(self, data):
        resp_str, status = await post_request(self.url, data)
        assert status == 200
        resp_dict = json.loads(resp_str)
        assert resp_dict["data"]["success"] == 0
