import json
import pytest
from unify_api.tests.constants_t import TOKEN, HTTP_PREFIX
from pot_libs.aiohttp_util.aiohttp_utils import AioHttpUtils


@pytest.mark.parametrize('data', [
    {
          "cid": 44,
          "start": "2020-09-01 00:00:00",
          "end": "2020-09-30 23:59:59",
          "inline_id": 42
    }
])
@pytest.mark.asyncio
async def test_load_distribution(data):
    """
    """
    resp_str, status = await AioHttpUtils().post(
        url=f"{HTTP_PREFIX}/unify-api/load-analysis/load-distribution"
            f"/load-distribution",
        data=data,
        timeout=10,
        headers={"Authorization": f"Bearer {TOKEN}"}
    )
    assert status == 200
    resp_str = json.loads(resp_str)
    assert all([resp_str["data"]["base_load"], resp_str["data"]["max_load"],
                resp_str["data"]["mean_load_rate"],
                resp_str["data"]["peak_valley"]])
