from pot_libs.sanic_api import summary
from unify_api.modules.zhiwei_u.components.equipment_operations_cps import \
    EquOptReq, EquOptResp, EdReq, EdResp, EdmReq, EcnReq, ErReq, EdmlReq
from unify_api.modules.zhiwei_u.procedures.common import zhiweiu_required
from unify_api.modules.zhiwei_u.service.equipment_operations_service import \
    equipment_operations_service, equipment_details_mysql_service, \
    equipment_details_mqtt_service, equipment_change_name_service, \
    equipment_replace_service, equipment_demolish_service


@summary('设备管理')
async def post_equipment_operations(req, body: EquOptReq) -> EquOptResp:
    prod_id = body.product
    cid = body.cid
    pid = body.pid
    page_size = body.page_size
    page_num = body.page_num
    sid = body.sid
    user_id = req.ctx.user_id
    return await equipment_operations_service(user_id, prod_id, cid, sid, pid,
                                              page_num, page_size)


@summary('设备管理-详情和修改-从mqtt获取数据')
async def post_equipment_details_mqtt(req, body: EdReq) -> EdResp:
    sid = body.sid
    mtid = body.mtid
    return await equipment_details_mqtt_service(sid, mtid)


@summary('设备管理-详情和修改-从mysql获取数据')
async def post_equipment_details_mysql(req, body: EdmReq) -> EdResp:
    sid = body.sid
    mtid = body.mtid
    return await equipment_details_mysql_service(sid, mtid)


@summary('设备管理-修改-安装点更名')
@zhiweiu_required()
async def post_equipment_change_name(req, body: EcnReq):
    mtid = int(body.mtid)
    pid = body.pid
    new_name = body.new_name
    return await equipment_change_name_service(mtid, pid, new_name)


@summary('设备管理-修改-装置更换')
@zhiweiu_required()
async def post_equipment_replace(req, body: ErReq):
    cid = body.cid
    sid = body.sid
    new_sid = body.new_sid
    return await equipment_replace_service(cid, sid, new_sid)


@summary('设备管理-修改-装置拆除')
@zhiweiu_required()
async def post_equipment_demolish(req, body: EdmlReq):
    cid = body.cid
    sid = body.sid
    return await equipment_demolish_service(cid, sid)
