# -*- coding: utf-8 -*-
from numpy import *
import operator


def classify(inputPoint, dataSet, labels, k=3):
    inputPoint = [x for x in inputPoint]
    dataSetSize = dataSet.shape[0]

    diffMat = tile(inputPoint, (dataSetSize, 1)) - dataSet
    sqDiffMat = power(diffMat, 2)
    distances = sqDiffMat.sum(axis=1)

    sortedDistIndicies = distances.argsort()
    classCount = {}

    for i in range(k):
        voteIlabel = labels[sortedDistIndicies[i]]
        classCount[voteIlabel] = classCount.get(voteIlabel, 0) + 1

    sortedClassCount = sorted(classCount.items(), key=operator.itemgetter(1), reverse=True)

    return sortedClassCount
