from pot_libs.mysql_util.mysql_util import MysqlUtil


async def sid_to_order_dao(sid):
    sql = "SELECT p.pid FROM `monitor` m LEFT JOIN point p " \
          "on p.mtid=m.mtid where m.sid=%s and m.demolished=0"
    async with MysqlUtil() as conn:
        data = await conn.fetchall(sql, args=(sid,))
    return data


async def select_cids_by_prod_id(pro_id):
    sql = "select cid from company where product=%s"
    async with MysqlUtil() as conn:
        data = await conn.fetchall(sql, args=(pro_id,))
    return data


async def select_sid_by_pid(pid):
    sql = "SELECT p.name, m.sid,p.pid FROM `monitor` m LEFT JOIN point p " \
          "on p.mtid=m.mtid where p.pid=%s and m.demolished=0"
    async with MysqlUtil() as conn:
        data = await conn.fetchone(sql, args=(pid,))
    return data


async def select_sid_by_pids(cids):
    sql = "SELECT p.name, m.sid,p.pid FROM `monitor` m LEFT JOIN point p " \
          "on p.mtid=m.mtid where p.pid in %s and m.demolished=0"
    async with MysqlUtil() as conn:
        data = await conn.fetchall(sql, args=(cids,))
    return data


async def select_cname_by_cids(cids):
    sql = f"select shortname,product,cid from company where cid in %s"
    async with MysqlUtil() as conn:
        data = await conn.fetchall(sql, args=(cids,))
    return data
