from dataclasses import dataclass
from pot_libs.sanic_api import Model
from pot_libs.sanic_api.column import Opt, Str, Int, List


@dataclass
class WarningSearchReq(Model):
    prod_id: int = Opt(Int('项目id').eg(1))
    cid: int = Opt(Int('客户id').eg(45))
    w_type: int = Opt(Int("报警类型").eg(1))
    page_size: int = Int("每页记录数").eg(20)
    page_num: int = Int("当前页码").eg(1)
    sid: str = Opt(Str('硬件编号').eg("A1904000583"))
    state: int = Int("运维报警所属模块 0待关注 1已忽略").eg(0)
    start: str = Opt(Str("开始时间").eg("2021-07-10 00:00:00"))
    end: str = Opt(Str("结束时间").eg("2021-07-10 23:59:59"))


@dataclass
class Alarm(Model):
    id: int = Int('报警id').eg(12)
    cid: int = Int('客户id').eg(45)
    compy_name: int = Int('工厂名').eg("德鑫矿业")
    sid: str = Str('硬件编号').eg("A1904000121")
    mtid: int = Int('监测点id').eg(28)
    monitor_name: int = Int('项目id').eg("变压器井上")
    w_type: int = Int('异常类型').eg(1)
    warn_info: int = Int('异常描述').eg("15min_index缺失4个，qingstor完整")
    check_dt: int = Int('异常时间').eg("2021-07-10 11:01")
    prod_id: int = Int('所属项目').eg(0)


@dataclass
class WarningSearchResp(Model):
    total: int = Int('总量').eg(1)
    is_power: int = Int('用户权限 1普通用户  2运维').eg(2)
    rows: list = List('信息').items(Alarm)


@dataclass
class Order(Model):
    id: int = Int('工单id').eg(12)
    check_dt: int = Int('发生时间').eg("2021-07-10 11:01")
    prod_id: int = Int('所属项目').eg(0)
    cid: int = Int('用户项目').eg(0)
    compy_name: int = Int('工厂名').eg("德鑫矿业")
    sid: str = Str('硬件编号').eg("A1904000121")
    mtid: int = Int('监测点id').eg(28)
    monitor_name: int = Int('项目名称').eg("变压器井上")
    w_type: int = Int('异常类型').eg(1)
    warn_info: int = Int('异常描述').eg("15min_index缺失4个，qingstor完整")
    state: int = Int('工单状态 1待接单 2处理中 3已关闭"').eg(0)
    username: str = Str('处理人').eg("张三")
    doc_url: str = Str('附件').eg("url")
    origin: str = Str('来源 张三手动录入 运维报警').eg("张三手动录入")
    is_order: int = Int('是否显示接单按钮 1显示   0不显示').eg(1)
    is_mod: int = Int('是否显示修改按钮 1显示   0不显示').eg(0)


@dataclass
class OrderSearchResp(Model):
    total: int = Int('总量').eg(1)
    rows: list = List('信息').items(Order)


@dataclass
class OrderSearchReq(Model):
    id: int = Opt(Int('工单id').eg(1))
    prod_id: int = Opt(Int('项目id').eg(1))
    cid: int = Opt(Int('客户id').eg(17))
    w_type: int = Opt(Int("报警类型 1丢失 2延迟 3异常 4手动 0全部").eg(1))
    state: int = Opt(Int("工单类型 1待接单 2-处理中 3-已关闭 0全部").eg(0))
    w_origin: int = Opt(Int("报警来源【0-全部 1-手动 2-自动】").eg(0))
    create_user_id: int = Opt(Int('创建人id 当w_origin为1时需要传递').eg("10086"))
    sid: str = Opt(Str('硬件编号').eg("A1904000583"))
    page_size: int = Int("每页记录数").eg(20)
    page_num: int = Int("当前页码").eg(1)
    start: str = Opt(Str("开始时间").eg("2021-07-10 00:00:00"))
    end: str = Opt(Str("结束时间").eg("2021-07-10 23:59:59"))

