from dataclasses import dataclass
from pot_libs.sanic_api import Model
from pot_libs.sanic_api.column import Int, List, Str, Dict, Float


@dataclass
class IndexMapDateResp(Model):
    index_map: list = List('data').eg([{"name": "观澜", "position": [114, 22]}])


@dataclass
class IndexMapallDateResp(Model):
    index_map: list = List('data').eg([{"pm25": 118, "position": [114, 22]}])


@dataclass
class IndexDataResp(Model):
    company_info: dict = Dict()
    company_data: list = List('data').eg([{"name": "观澜", "position": [1, 2]}])


@dataclass
class IndexTopDataResp(Model):
    count_project: str = Str("接入项目总数").eg("1")
    pm25_unusual: str = Str("pm2.5异常项目数").eg("1")
    pm10_unusual: str = Str("pm10异常项目数").eg("1")
    tsp_unusual: str = Str("tsp异常项目数").eg("1")
    air_standard: str = Str("空气达标率").eg("80%")
    rank: list = List("rank").eg([
        {"company": "深圳湾文化广场", "effective_rate": "20%", "measures": 10}])
