from pot_libs.mysql_util.mysql_util import MysqlUtil


async def query_sdu_power_wave(pid, cal_day):
    """根据pid和时间查询功率波动数据"""
    async with MysqlUtil() as conn:
        sql = "select * from sdu_power_wave where pid=%s and cal_day=%s"
        res = await conn.fetchone(sql, args=(pid, cal_day))
    return res


async def query_sdu_recog_record(pid, start, end):
    """根据pid查询用电设备识别结果"""
    async with MysqlUtil() as conn:
        sql = "select * from sdu_recog_record where pid=%s " \
              "and recog_dt>=%s and recog_dt<=%s"
        res = await conn.fetchall(sql, args=(pid, start, end))
    return res
