from dataclasses import dataclass
from pot_libs.sanic_api.column import Str, Int, Opt, List, Float
from pot_libs.sanic_api import Model
from unify_api.utils.response_code import DbErr
from unify_api.modules.zhiwei_u.components.scope_operations_cps import \
    ScopeContent


@dataclass
class ScopeRecordReq(Model):
    cid: int = Int("工厂id").eg(132)
    point_id: list = List("监测点id 0表示全部").eg(
        [1019, 1021, 1023, 1025, 1026, 1027, 1020])
    start: str = Opt(Str("开始时间").eg("2021-07-01 00:00:00"))
    end: str = Opt(Str("结束时间").eg("2021-07-01 23:59:59"))
    page_size: int = Int("每页记录数").eg(20)
    page_num: int = Int("当前页码").eg(1)


@dataclass
class ScopeRecord(Model):
    trigger_time: str = Str("触发时间").eg("2021-07-01 23:59:59")
    point_id: int = Int("监测点id").eg("12")
    point_name: str = Str("监测点 ").eg("1#变压器")
    record_type: str = Str("over_res_cur").eg("错误类型")
    record_type_name: str = Str("漏电流或者电流越限").eg("错误类型")
    probability: float = Float("触发概率")
    reason: str = Str("触发原因")
    scope_id: str = Str("录波id")


@dataclass
class ScopeRecordResp(Model, DbErr):
    rows: list = List('报警信息').items(ScopeRecord)
    total: int = Int("总数")


@dataclass
class ScopeAnalyseReq(Model):
    scope_id: str = Str("录波id").eg("A1911000284_1630053507"
                                     " A2012121205_1628244954")


@dataclass
class ScopeAnalyseResp(Model):
    point_id: int = Int("监测点id").eg("12")
    point_name: str = Str("监测点 ").eg("1#变压器")
    trigger_time: str = Str("触发时间").eg("2021-07-01 23:59:59")
    trigger_params: list = List("触发参数").eg([""])
    trigger_point: str = Str("触发点").eg("240")
    reason: list = List("识别原因和建议")
    contents: ScopeContent = ScopeContent


@dataclass
class LeakageCurrent(Model):
    ileak: list = List("漏电流实际值").items(Float())
    ileak_rms: list = List("漏电流有效值").items(Float())


@dataclass
class LeakageCurrentResp(Model):
    point_id: int = Int("监测点id").eg("12")
    point_name: str = Str("监测点 ").eg("1#变压器")
    trigger_time: str = Str("触发时间").eg("2021-07-01 23:59:59")
    trigger_point: str = Str("触发点").eg("240")
    trigger_params: list = List("触发参数").eg([])
    reason: list = List("识别原因和建议")
    contents: LeakageCurrent = LeakageCurrent
