from dataclasses import dataclass

from pot_libs.common.components.fields import Cid
from pot_libs.sanic_api import Model
from pot_libs.sanic_api.column import Opt, Str, Int, List, Float
from unify_api.utils.response_code import DbErr, ServerErr


@dataclass
class SecurityCountReq(Model):
    cid: int = Opt(Int("工厂id-管理版本不用传").eg(66))
    point_id: int = Int("point_id").eg(-1)
    date_type: str = Str("时间类型->day/month").eg("day")
    start: str = Str("开始时间").eg("2020-07-30 00:00:00")
    end: str = Str("结束时间").eg("2020-07-30 23:59:59")
    product: int = Opt(Int("product 1-知电 2-安电 3-安电管理, 可选参数，传了认为是查对应产品的数据").eg(3))
    proxy_id: int = Opt(Int("proxy_id").eg(1))


@dataclass
class SlotValue(Model):
    slots: list = List("slots").eg(["00:00", "00:15", "00:30"])
    value: list = List("时间段对应的值").eg([0.1, 0.2, 0.3])


@dataclass
class LevelCount(Model):
    first_alarm_cnt: int = Opt(Int("一级报警数").eg(12))
    second_alarm_cnt: int = Opt(Int("二级报警数").eg(20))
    third_alarm_cnt: int = Opt(Int("三级报警数").eg(50))


@dataclass
class SecurityCountResp(Model, DbErr, ServerErr):
    first_alarm: SlotValue = Opt(SlotValue)
    second_alarm: SlotValue = Opt(SlotValue)
    third_alarm: SlotValue = Opt(SlotValue)
    level_detail: LevelCount = LevelCount


@dataclass
class SecurityCommonReq(Model):
    """
    这个本意用来使得代码更通用, 比如cid->cids支持多个,单个
    """

    cids: list = List("工厂id列表,例如[66, 68]").items(Int("工厂id")).eg([66, 68])
    date_type: str = Str("时间类型->day/month").eg("day")
    start: str = Str("开始时间").eg("2020-07-30 00:00:00")
    end: str = Str("结束时间").eg("2020-07-30 23:59:59")
    product: int = Int("product 1-知电 2-安电 3-安电管理 4-知电U, 可选参数，传了认为是查对应产品的数据").eg(3)
    proxy_id: int = Opt(Int("代理id").eg(1))


@dataclass
class ElectricParam(Model):
    harmonic: int = Int("谐波报警数").eg(11)
    voltage: int = Int("电压报警数").eg(20)
    current: int = Int("电流报警数").eg(30)
    power_factor: int = Int("功率因数报警数").eg(40)
    threephase_imbalance: int = Int("三项不平衡报警数").eg(40)
    load_rate: int = Int("负载率报警数").eg(40)


@dataclass
class ContentCount(Model):
    temperature_cnt: int = Opt(Int("温度报警数").eg(12))
    residual_current_cnt: int = Opt(Int("漏电流报警数").eg(20))
    electric_param_cnt: int = Opt(Int("电参数报警数").eg(50))


@dataclass
class AlarmContentDistributionResp(Model):
    temperature: SlotValue = Opt(SlotValue)
    residual_current: SlotValue = Opt(SlotValue)
    electric_param: SlotValue = Opt(SlotValue)
    content_detail: ContentCount = ContentCount
    electric_param_detail: ElectricParam = ElectricParam


@dataclass
class AlarmSummaryResp(Model):
    total_alarm_cnt: int = Int("总报警数").eg(12)
    alarm_company_cnt: int = Int("有报警的公司数").eg(2)
    avg_alarm_cnt: int = Int("平均报警数").eg(6)
    max_alarm_cnt: int = Int("最高报警数").eg(7)
    safe_run_days: int = Int("安全运行天数").eg(110)
    avg_safe_run_days: int = Int("平均安全运行").eg(120)
    day_alarm_cnt: int = Int("白天报警数").eg(110)
    night_alarm_cnt: int = Int("晚上报警数").eg(120)
    morning_alarm_cnt: int = Int("凌晨报警数").eg(120)
