from pot_libs.sanic_api import summary
from unify_api.modules.electric.components.proxy_safe_cps import (
    ProxyElectricPageReq,
    ProxyElectricPageResp,
    ProxyElectricPageItem,
    ProxyElectricCountResp,
    ProxySecurityLevel,
    AlarmContent,
)
from unify_api.modules.electric.procedures.proxy_safe_pds import (
    page_proxy_electric_info,
    proxy_electric_count_info,
)


@summary("安电u管理版本-用电安全-上方统计数据接口")
async def post_elec_count_info(req, body: ProxyElectricPageReq) -> ProxyElectricCountResp:
    cids, month = body.cids, body.month
    count_info_map = await proxy_electric_count_info(cids, month)
    return ProxyElectricCountResp(
        total_cid_cnt=count_info_map["total_cid_cnt"],
        total_run_days=count_info_map["total_run_days"],
        total_safe_run_days=count_info_map["total_safe_run_days"],
        security_level=ProxySecurityLevel(**count_info_map["security_level"]),
        alarm_content=AlarmContent(**count_info_map["alarm_content"]),
    )


@summary("安电u管理版本获取用电安全月度数据")
async def post_elec_list(req, body: ProxyElectricPageReq) -> ProxyElectricPageResp:
    cids, month = body.cids, body.month
    page_size, page_num = body.page_size, body.page_num
    sort_field, sort_direction = body.sort_field, body.sort_direction
    electric_info = await page_proxy_electric_info(
        cids, month, page_size, page_num, sort_field=sort_field, sort_direction=sort_direction,
    )
    return ProxyElectricPageResp(
        total=electric_info["total"],
        rows=[ProxyElectricPageItem(**i) for i in electric_info["rows"]],
    )
