from pot_libs.sanic_api import summary
from pot_libs.logger import log
from unify_api.modules.anshiu.dao.fine_monitor_dao import get_mtid_by_pid_dao
from unify_api.utils import time_format
from unify_api.modules.anshiu.components.fine_monitor_cps import (
    FineMonitorChartReq, FineMonitorInfoReq, FineMonitorChartResp,
    FineMonitorInfoResp
)
from unify_api.modules.anshiu.procedures.fine_monitor_pds import (
    get_mtid_by_location_ids
)
from unify_api.modules.anshiu.service.fine_monitor_serv import (
    get_adio_chart_data, get_point_chart_data,
    electric_index_list_service
)


@summary("精细监测-五个图表")
async def post_fine_monitor_chart(request,
                                  body: FineMonitorChartReq) -> FineMonitorChartResp:
    try:
        date_start = body.start
        date_end = body.end
        # 起始时间转化为时间戳
        start_timestamp = time_format.get_date_timestamp(date_start)
        end_timestamp = time_format.get_date_timestamp(date_end)

        # 计算间隔与坐标点
        intervel, slots = time_format.time_pick_transf(date_start, date_end)
        # 获取监测点
        point_id = body.pid
        if not point_id or point_id <= 0:
            raise Exception('point_error point_id:{}'.format(point_id))
        # 获取location点
        location_group = body.location_ids
        if not location_group:
            raise Exception('in_groups is NULL, no location_id')
    except Exception as e:
        log.error('get_fine_monitor_chart_error ' + str(e))
        return FineMonitorChartResp.param_error()

    # 获取location表的信息
    try:
        location_info = await get_mtid_by_location_ids(location_group)
    except Exception as e:
        log.error('get_fine_monitor_chart_error ' + e)
        return FineMonitorChartResp.db_error()

    # 获取温度及漏电流数据
    temperature_list, residual_currents_list = await get_adio_chart_data(
        location_group, location_info, date_start, date_end,
        intervel, slots)

    # 电力数据 power_list、电流曲线、电压曲线
    power_list, i_list, v_list, ctnum = await get_point_chart_data(
        point_id,
        date_start,
        date_end,
        intervel,
        slots)
    # 获取温度与漏电流的曲线数据
    # 获取用电数据
    return FineMonitorChartResp(time_slots=slots,
                                temperature=temperature_list,
                                residual_current=residual_currents_list,
                                power=power_list, i=i_list, v=v_list,
                                ctnum=ctnum)


@summary("精细监测-指标统计")
async def post_fine_monitor_info(request,
                                 body: FineMonitorInfoReq) -> FineMonitorInfoResp:
    mtid = await get_mtid_by_pid_dao(body.pid)
    mtid = mtid["mtid"]
    # 1，获取参数
    start_time = body.start
    end_time = body.end
    # 2，获取信息
    ctnum, general_param, electric_quality, safe_param = await \
        electric_index_list_service(mtid, start_time, end_time)
    if ctnum == -1:
        raise Exception("监测点出错")
    # 3，返回信息
    info_list = []
    info_list.extend(general_param)
    info_list.extend(safe_param)
    return FineMonitorInfoResp(info_list=info_list)
