# /usr/bin/env python
# -*- coding: UTF-8 -*-l
import sys
sys.path.append(f'/home/ubuntu/data/code/unify_api2/unify_api/modules/'
                f'zhiwei_u/fault_foreast')
from filterSteadyData import filterSteadyData, testFeat
from knnForecast import classify
from numpy import array
from resultFinal import resultFinal
from filterStrength import filterStrength
from load_in_flag import load_in_flag
import pandas as pd
from faultreg import fault_reg
from voltDigReg import voltDipReg
import random


def actionFile(data=None, ctnum=None):
    result=actionFilemin(data, ctnum)
    if result == "nofault":
        firstDict={}
        if ctnum == 2:
            if "ubc" in data:
                for i in ["uab", "ubc"]:
                    firstDict[i] = data[i]
                    if max(firstDict[i]) > 200:
                        return i[1].upper() + "相电压波动"
                for i in ['ia', 'ic', 'uab', 'ucb']:
                    firstDict[i] = data[i]
                    eachcurrent = [each for each in firstDict[i][::80]]
                    eachcurrentsubs = [
                        abs(eachcurrent[each] - eachcurrent[each - 1]) for
                        each in
                        range(1, len(eachcurrent))]
                    if max(eachcurrentsubs) > 0.2 * max(firstDict[i]):
                        return i[1].upper() + "相电流波动"
            else:
                for i in ["uab", "ucb"]:
                    firstDict[i] = data[i]
                    if max(firstDict[i]) > 200:
                        return i[1].upper() + "相电压波动"
                for i in ['ia', 'ic', 'uab', 'ucb']:
                    firstDict[i] = data[i]
                    eachcurrent = [each for each in firstDict[i][::80]]
                    eachcurrentsubs = [
                        abs(eachcurrent[each] - eachcurrent[each - 1]) for each in
                        range(1, len(eachcurrent))]
                    if max(eachcurrentsubs) > 0.2 * max(firstDict[i]):
                        return i[1].upper() + "相电流波动"
            return "A相电流波动"
        else:
            for i in ["ua", "ub", "uc"]:
                firstDict[i] = data[i]
                if max(firstDict[i]) > 230:
                    return i[1].upper() + "相电压波动"
            for i in ['ia', 'ib', 'ic', 'ua', 'ub', 'uc']:
                firstDict[i] = data[i]
                eachcurrent = [each for each in firstDict[i][::80]]
                eachcurrentsubs = [
                    abs(eachcurrent[each] - eachcurrent[each - 1]) for each in
                    range(1, len(eachcurrent))]
                if max(eachcurrentsubs) > 0.2 * max(firstDict[i]):
                    return i[1].upper() + "相电流波动"
            return "A相电流波动"
    else:
        firstDict = {}
        if ctnum == 2:
            if "ubc" in data:
                for i in ["uab", "ubc"]:
                    firstDict[i] = data[i]
                    if max(firstDict[i])>200:
                        result1=[each.append(i[1].upper()+"相电压波动") for each in result]
                        return result
                for i in ['iab0','ibc','uab','ubc']:
                    firstDict[i] = data[i]
                    eachcurrent=[each for each in firstDict[i][::80]]
                    eachcurrentsubs=[abs(eachcurrent[each]-eachcurrent[each-1]) for each in range(1,len(eachcurrent))]
                    if max(eachcurrentsubs)>0.2*max( firstDict[i]):
                        result1 = [each.append(i[1].upper() + "相电流波动")
                                   for each in result]
                        return result
            else:
                for i in ["uab", "ucb"]:
                    firstDict[i] = data[i]
                    if max(firstDict[i]) > 200:
                        result1 = [each.append(i[1].upper() + "相电压波动") for each
                                   in result]
                        return result
                for i in ['ia', 'ic', 'uab', 'ucb']:
                    firstDict[i] = data[i]
                    eachcurrent = [each for each in firstDict[i][::80]]
                    eachcurrentsubs = [
                        abs(eachcurrent[each] - eachcurrent[each - 1]) for each
                        in range(1, len(eachcurrent))]
                    if max(eachcurrentsubs) > 0.2 * max(firstDict[i]):
                        result1 = [each.append(i[1].upper() + "相电流波动")
                                   for each in result]
                        return result
            [each.append("A相电流波动") for each in result]
            return result
        else:
            for i in ["ua", "ub", "uc"]:
                firstDict[i] = data[i]
                if max(firstDict[i]) > 230:
                    [each.append(i[1].upper() + "相电压波动") for each in result]
                    return result
            for i in ['ia', 'ib', 'ic', 'ua', 'ub', 'uc']:
                firstDict[i] = data[i]
                eachcurrent=[each for each in firstDict[i][::80]]
                eachcurrentsubs=[abs(eachcurrent[each]-eachcurrent[each-1]) for each in range(1,len(eachcurrent))]
                if max(eachcurrentsubs)>0.2*max( firstDict[i]):
                    result1 =[each.append(i[1].upper() + "相电流波动") for each in
                                  result]

                    return result
            [each.append("A相电流波动") for each in result]
            return result



def actionFilemin(data, ctnum):
    dataDict={}
    firstDict={}
    import os
    origin_path = os.path.dirname(__file__)
    maxStaThrFeatsTwo_path = os.path.join(origin_path,
                                          "libs/maxStaThrFeatsTwo.csv")
    maxStaThrFeatsThree_path = os.path.join(origin_path,
                                            "libs/maxStaThrFeatsThree.csv")
    if ctnum == 2:
        data1 = {}
        data1["iab"] = data["ia"]
        data1["ibc"] = data["ic"]
        data1["uab"] = data["uab"]
        data1["ubc"] = data["ucb"]
        data = data1
        for i in ["uab","ubc"]:
            firstDict[i] = data[i]
        firstflag=voltDipReg(firstDict,ctnum)
        if firstflag<0.5:
            return "nofault"
        for i in ['iab','ibc','uab','ubc']:
            dataDict[i]=data[i]
        length = len(dataDict['iab'])

        if length < 200:
            return 'nofault'
        volt_fluct, currentFlag, voltFlag, currentFlag2, currentFlag3, voltFlag2, flag, FLAGCurrent, FLAGCurrentLevel2 = filterSteadyData(
            dataDict, length, ctnum)
        waveflag = filterStrength(dataDict, length, ctnum)
        ctnum_count_flag_max, ctnum_count_flag_min,vote_ctnum_count_flag_max,vote_ctnum_count_flag_min ,current_sum_fore= load_in_flag(dataDict, length, ctnum)
    else:
        for i in ["ua","ub","uc"]:
            firstDict[i] = data[i]
        firstflag=voltDipReg(firstDict,ctnum)
        if firstflag<0.5:
            return "nofault"
        for i in ['ia','ib','ic','ua','ub','uc']:
            dataDict[i]=data[i]
        length = len(dataDict['ia'])
        if length < 200:
            return 'nofault'
        volt_fluct, currentFlag, voltFlag, currentFlag2, currentFlag3, voltFlag2, flag, FLAGCurrent, FLAGCurrentLevel2 = filterSteadyData(
            dataDict, length, ctnum)
        waveflag = filterStrength(dataDict, length, ctnum)
        ctnum_count_flag_max, ctnum_count_flag_min,vote_ctnum_count_flag_max,vote_ctnum_count_flag_min,current_sum_fore = load_in_flag(dataDict, length, ctnum)
    testFeature = testFeat(dataDict, length, ctnum)
    testFeature = [x for x in testFeature]

    if ctnum == 2 and currentFlag3 == 2:
        return 'nofault'
    elif ctnum == 3 and currentFlag3 == 3:
        return 'nofault'
    elif currentFlag2 >= 3:
        return 'nofault'
    elif volt_fluct == 2 and ctnum == 2 or volt_fluct == 3 and ctnum == 3:
        return 'nofault'
    elif ctnum == 2 and current_sum_fore >= 4 or ctnum == 3 and current_sum_fore >= 6:
        return 'nofault'
    elif ctnum == 2 and ctnum_count_flag_max >= 2 and ctnum_count_flag_min >= 2 and (
            vote_ctnum_count_flag_min >= 2 or vote_ctnum_count_flag_max >= 2) or ctnum == 3 and ctnum_count_flag_max >= 3 and ctnum_count_flag_min >= 3 and (
            vote_ctnum_count_flag_min >= 3 or vote_ctnum_count_flag_max >= 3):
        return 'nofault'
    elif waveflag > 0:
        if ((FLAGCurrent > 1 or FLAGCurrentLevel2 > 0) and flag > 1 and (
                FLAGCurrent > 1 or FLAGCurrentLevel2 > 0)) and (
                currentFlag3 == 0 or flag >= 2):

            if ctnum == 2:
                resultRule = []
                faultFlag, faultype, position = fault_reg(dataDict, 2)
                if faultFlag == 0:
                    return "nofault"
                else:
                    resultRule.append(faultype)
                    resultRule.append(0.7 + random.uniform(0.02, 0.02))

                    trainData = pd.read_csv(maxStaThrFeatsTwo_path,
                                            encoding="gbk")
                    dataSet = array(
                        trainData[['2', '3', '4', '5', '6', '7']].values)
                    labels = [str(each[0]) for each in
                              trainData[['9']].values.tolist()]
                    classResult = classify(testFeature, dataSet, labels, 3)
                    print(classResult)
                    result = resultFinal(classResult, resultRule)
                    print("result2", result)
                    return result

            elif ctnum == 3:
                resultRule = []
                faultFlag, faultype, position = fault_reg(dataDict, 3)
                if faultFlag == 0:
                    return "nofault"
                else:
                    resultRule.append(faultype)
                    resultRule.append(0.7 + random.uniform(0.02, 0.02))
                    # "/app/bin/tools/faultForeast/lib/maxStaThrFeatsThree.csv"
                    trainData = pd.read_csv(maxStaThrFeatsThree_path,
                                            encoding="gbk")
                    dataSet = array(trainData[
                                        ['2', '3', '4', '5', '6', '7', '8',
                                         '9', '10']].values)
                    labels = [str(each[0]) for each in
                              trainData[['12']].values.tolist()]

                    classResult = classify(testFeature, dataSet, labels, 3)
                    result = resultFinal(classResult, resultRule)

                    return result
        elif ((
                      FLAGCurrent > 0 or FLAGCurrentLevel2 > 0) and ctnum == 2 and flag > 0 or (
                      FLAGCurrent > 0 or FLAGCurrentLevel2 > 0) and ctnum == 3 and flag > 0) and currentFlag3 == 0:
            if ctnum == 2:
                resultRule = []
                faultFlag, faultype, position = fault_reg(dataDict, 2)
                if faultFlag == 0:
                    return "nofault"
                else:
                    resultRule.append(faultype)
                    resultRule.append(0.7 + random.uniform(-0.02, 0.02))
                    trainData = pd.read_csv(maxStaThrFeatsTwo_path,
                                            encoding="gbk")
                    dataSet = array(
                        trainData[['2', '3', '4', '5', '6', '7']].values)
                    labels = [str(each[0]) for each in
                              trainData[['9']].values.tolist()]
                    classResult = classify(testFeature, dataSet, labels, 3)
                    result = resultFinal(classResult, resultRule)
                    return result
            elif ctnum == 3:
                resultRule = []
                faultFlag, faultype, position = fault_reg(dataDict, 3)
                if faultFlag == 0:
                    return "nofault"
                else:
                    resultRule.append(faultype)
                    resultRule.append(0.7 + random.uniform(-0.02, 0.02))
                    trainData = pd.read_csv(maxStaThrFeatsThree_path,
                                            encoding="gbk")
                    dataSet = array(trainData[
                                        ['2', '3', '4', '5', '6', '7', '8',
                                         '9', '10']].values)
                    labels = [str(each[0]) for each in
                              trainData[['12']].values.tolist()]

                    classResult = classify(testFeature, dataSet, labels, 3)
                    result = resultFinal(classResult, resultRule)

                    return result
                # "/app/bin/tools/faultForeast/lib/maxStaThrFeatsThree.csv"
            else:
                return "nofault"
        elif currentFlag2 >= 3:
            if ctnum == 2:
                resultRule = []
                faultFlag, faultype, position = fault_reg(dataDict, 2)
                if faultFlag == 0:
                    return "nofault"
                else:
                    resultRule.append(faultype)
                    resultRule.append(0.7 + random.uniform(-0.02, 0.02))
                    trainData = pd.read_csv(maxStaThrFeatsTwo_path)
                    dataSet = array(
                        trainData[['2', '3', '4', '5', '6', '7']].values)
                    labels = [str(each[0]) for each in
                              trainData[['9']].values.tolist()]
                    classResult = classify(testFeature, dataSet, labels, 3)
                    result = resultFinal(classResult, resultRule)
                    return result
            elif ctnum == 3:
                resultRule = []
                faultFlag, faultype, position = fault_reg(dataDict, 3)
                if faultFlag == 0:
                    return "nofault"
                else:
                    resultRule.append(faultype)
                    resultRule.append(0.7 + random.uniform(-0.02, 0.02))
                    # "/app/bin/tools/faultForeast/lib/maxStaThrFeatsThree.csv"
                    trainData = pd.read_csv(maxStaThrFeatsThree_path,
                                            encoding="gbk")
                    dataSet = array(trainData[
                                        ['2', '3', '4', '5', '6', '7', '8',
                                         '9', '10']].values)
                    labels = [str(each[0]) for each in
                              trainData[['12']].values.tolist()]
                    classResult = classify(testFeature, dataSet, labels, 3)
                    result = resultFinal(classResult, resultRule)
                    return result
            else:
                return "nofault"

        elif (FLAGCurrent > 1 or FLAGCurrentLevel2 > 0) and flag > 0:
            if currentFlag3 > 0 and voltFlag2 > 0:
                if ctnum == 2:
                    resultRule = []
                    faultFlag, faultype, position = fault_reg(dataDict, 2)
                    if faultFlag == 0:
                        return "nofault"
                    else:
                        resultRule.append(faultype)
                        resultRule.append(0.7 + random.uniform(-0.02, 0.02))
                        trainData = pd.read_csv(maxStaThrFeatsTwo_path)
                        dataSet = array(
                            trainData[['2', '3', '4', '5', '6', '7']].values)
                        labels = [str(each[0]) for each in
                                  trainData[['9']].values.tolist()]
                        classResult = classify(testFeature, dataSet, labels, 3)
                        result = resultFinal(classResult, resultRule)
                        return result
                elif ctnum == 3:
                    resultRule = []
                    faultFlag, faultype, position = fault_reg(dataDict, 3)
                    if faultFlag == 0:
                        return "nofault"
                    else:
                        resultRule.append(faultype)
                        resultRule.append(0.7 + random.uniform(-0.02, 0.02))
                        # "/app/bin/tools/faultForeast/lib/maxStaThrFeatsThree.csv"
                        trainData = pd.read_csv(maxStaThrFeatsThree_path,
                                                encoding="gbk")
                        dataSet = array(trainData[
                                            ['2', '3', '4', '5', '6', '7', '8',
                                             '9', '10']].values)
                        labels = [str(each[0]) for each in
                                  trainData[['12']].values.tolist()]
                        classResult = classify(testFeature, dataSet, labels, 3)
                        result = resultFinal(classResult, resultRule)
                        return result
                else:
                    return 'nofault'
            elif currentFlag > 0 or currentFlag2 >= 3:
                # "/app/bin/tools/faultForeast/lib/maxStaThrFeatsTwo.csv"
                if ctnum == 2:
                    resultRule = []
                    faultFlag, faultype, position = fault_reg(dataDict, 2)
                    if faultFlag == 0:
                        return "nofault"
                    else:
                        resultRule.append(faultype)
                        resultRule.append(0.7 + random.uniform(-0.02, 0.02))
                        trainData = pd.read_csv(maxStaThrFeatsTwo_path)
                        dataSet = array(
                            trainData[['2', '3', '4', '5', '6', '7']].values)
                        labels = [str(each[0]) for each in
                                  trainData[['9']].values.tolist()]
                        classResult = classify(testFeature, dataSet, labels, 3)
                        result = resultFinal(classResult, resultRule)
                        return result

                elif ctnum == 3:
                    resultRule = []
                    faultFlag, faultype, position = fault_reg(dataDict, 3)
                    if faultFlag == 0:
                        return "nofault"
                    else:
                        resultRule.append(faultype)
                        resultRule.append(0.7 + random.uniform(-0.02, 0.02))
                        # "/app/bin/tools/faultForeast/lib/maxStaThrFeatsThree.csv"
                        trainData = pd.read_csv(maxStaThrFeatsThree_path,
                                                encoding="gbk")
                        dataSet = array(trainData[
                                            ['2', '3', '4', '5', '6', '7', '8',
                                             '9', '10']].values)
                        labels = [str(each[0]) for each in
                                  trainData[['12']].values.tolist()]
                        classResult = classify(testFeature, dataSet, labels, 3)
                        result = resultFinal(classResult, resultRule)
                        return result
                else:
                    return 'nofault'
            else:
                return 'nofault'
        else:
            return 'nofault'
    else:
        return "nofault"


if __name__ == "__main__":
    # data = {"uab": [53.59, 48.63, 50.76, 51.11, 50.4, 53.24, 48.63, 41.55, 41.9, 42.96, 40.13, 37.3, 29.86, 28.09, 25.96, 18.53, 15.34, 12.51, 6.48, 1.53, 4.36, 2.94, 4.36, 1.17, -8.04, -18.31, -18.66, -23.27, -26.81, -20.79, -26.81, -32.83, -37.08, -38.5, -37.79, -34.6, -43.45, -43.81, -42.04, -41.33, -39.2, -37.79, -40.62, -41.68, -37.08, -34.95, -30.7, -28.58, -33.18, -31.41, -24.33, -20.79, -18.31, -16.89, -17.95, -14.41, -9.45, -7.33, -0.24, 6.13, 5.07, 10.73, 17.11, 17.82, 19.24, 18.53, 16.76, 23.49, 26.67, 28.8, 33.05, 33.4, 30.92, 32.34, 35.17, 36.24, 38.01, 36.59, 33.76, 34.46, 38.71, 40.84, 40.49, 39.42, 34.82, 36.59, 35.88, 35.88, 34.82, 27.38, 25.96, 26.67, 23.13, 24.19, 23.13, 19.94, 12.15, 9.32, 7.19, 7.19, 8.96, 5.42, 0.46, -0.24, -3.08, -5.56, -6.97, -14.77, -16.18, -16.89, -19.37, -18.66, -18.31, -23.62, -24.33, -23.62, -23.27, -21.14, -23.27, -28.93, -27.16, -23.97, -23.62, -21.85, -19.02, -21.85, -24.68, -22.91, -21.14, -15.47, -14.77, -18.66, -16.54, -12.29, -8.04, -4.85, -4.14, -5.2, -2.37, 2.23, 9.32, 18.53, 17.82, 9.67, 9.67, 12.51, 13.57, 14.63, 16.05, 17.46, 19.59, 21.36, 22.07, 24.55, 24.19, 22.78, 23.49, 25.61, 26.32, 28.44, 25.26, 21.71, 21.71, 21.36, 27.38, 30.21, 29.51, 18.17, 18.53, 19.94, 20.3, 18.88, 16.4, 11.09, 14.28, 14.63, 11.44, 11.8, 7.19, 6.13, 8.61, 8.26, 8.96, 8.96, 2.23, -2.02, -3.08, -3.43, -2.72, -4.85, -9.45, -9.81, -3.79, -3.43, -1.31, -6.62, -10.52, -12.64, -6.97, -6.97, -6.27, -8.04, -12.99, -11.22, -8.39, -7.33, -7.68, -7.33, -6.27, -5.2, -4.14, -2.02, 2.23, -3.43, -8.74, -5.91, 4.01, 5.07, 5.78, 2.94, 0.82, 4.36, 7.55, 7.9, 11.44, 11.8, 6.84, 8.96, 13.92, 13.21, 16.05, 13.92, 12.15, 15.34, 17.11, 15.34, 19.94, 21.36, 13.92, 14.98, 16.4, 16.76, 19.94, 17.82, 14.28, 14.98, 17.46, 19.24, 20.3, 17.11, 15.34, 16.76, 16.4, 12.86, 13.21, 7.9, 4.71, 7.55, 5.78, 6.48, 5.78, -2.72, -4.14, -2.02, -2.02, -1.31, -0.95, -4.49, -8.04, -7.33, -5.56, -5.2, -6.62, -8.74, -9.45, -9.45, -11.93, -6.62, -4.14, -2.37, 0.11, 2.23, -3.79, -3.43, -2.72, -5.2, -3.08, -0.24, -3.79, 0.11, 1.88, -2.02, -2.72, -0.24, -2.02, 2.23, 1.17, -2.37, -2.37, 5.78, 7.9, 12.15, 7.9, 3.3, 4.01, 5.07, 5.78, 7.55, 4.71, 1.17, 5.07, 7.19, 4.36, 4.36, 2.23, 1.53, 1.88, 5.07, 6.48, 7.19, 3.3, -0.6, 1.53, 5.42, 6.13, 7.19, 3.3, 2.23, 4.71, 7.19, 7.55, 4.36, -2.02, -0.95, 3.3, 4.36, 6.48, 4.01, -0.24, -1.66, 7.19, 7.19, 6.13, 6.13, 1.17, -0.24, 0.82, 2.23, 4.71, 5.78, 1.53, 3.3, 6.84, 5.07, 6.48, 7.19, 4.71, 2.59, 5.42, 8.96, 10.03, 13.57, 2.23, -0.6, -0.24, 0.82, 8.61, 6.48, 2.94, -1.31, 2.94, 2.59, 4.71, 9.67, 5.78, 2.59, 5.42, 7.55, 4.36, -0.24, -9.45, -2.37, 1.88, 3.65, 7.9, 13.21, 6.48, 6.13, 10.38, 18.88, 21.01, 16.76, 13.21, 14.28, 17.82, 19.59, 21.01, 18.17, 18.17, 16.4, 15.34, 19.24, 19.24, 16.76, 10.73, 15.34, 17.82, 15.69, 11.8, 10.38, 11.09, 13.57, 13.57, 10.03, 10.03, -2.02, -4.49, -0.24, 1.17, -5.56, -6.27, -19.37, -20.08, -16.89, -10.52, -9.1, -9.1, -15.83, -17.95, -18.31, -17.95, -17.25, -20.79, -25.39, -26.1, -25.04, -26.81, -26.1, -26.1, -27.52, -30.0, -28.22, -26.45, -22.91, -23.97, -30.7, -26.45, -22.2, -20.43, -16.54, -17.25, -17.25, -7.68, -7.68, -9.45, -6.97, -2.02, -4.49, -3.08, -1.31, -5.56, -6.27, -3.08, -0.6, 11.8, 21.36, 22.78, 28.09, 32.69, 32.69, 37.3, 41.55, 44.38, 50.4, 48.63, 44.38, 49.34, 51.47, 51.47, 50.76, 48.63, 46.15, 47.92, 47.57, 48.99, 48.99, 44.38, 40.84, 40.49, 38.71, 38.01, 36.94, 30.21, 26.32, 22.78, 15.69, 16.76, 16.4, 4.71, -1.66, -10.87, -17.6, -17.25, -17.6, -20.08, -23.27, -25.75, -28.22, -30.7, -35.31, -40.97, -47.35, -47.7, -49.48, -49.12, -50.89, -59.04, -59.04, -57.27, -58.33, -57.62, -55.5, -57.98, -57.27, -55.5, -52.31, -46.64, -44.87, -49.83, -45.58, -37.08, -31.77, -27.87, -24.68, -26.45, -21.5, -12.99, -11.93, -1.66, 0.82, 0.46, 9.67, 14.28, 20.65, 26.32, 27.74, 27.03, 35.53, 39.78, 39.42, 49.34, 53.59, 53.24, 53.94, 64.57, 69.88, 65.63, 63.86, 63.86, 66.34, 65.28, 64.92, 66.34, 64.57, 61.38, 60.32, 56.07, 55.01, 55.72, 44.38, 40.49, 39.07, 38.36, 35.53, 27.38, 21.36, 8.61, 7.9, 7.19, 3.65, -2.37, -8.39, -13.7, -15.83, -17.25, -19.72, -22.91, -31.06, -35.31, -35.31, -40.97, -41.33, -43.1, -51.6, -53.37, -53.02, -56.56, -55.5, -58.33, -62.58, -60.81, -61.87, -68.25, -76.75, -67.18, -67.54, -61.52, -62.23, -60.1, -52.31, -49.12, -49.12, -42.04, -35.66, -31.06, -21.85, -19.02, -17.25, -9.1, -3.43, 4.71, 15.69, 17.46, 20.65, 25.61, 36.94, 45.44, 48.99, 51.11, 55.36, 58.55, 64.57, 64.92, 72.72, 74.84, 73.78, 77.67, 82.28, 83.7, 79.09, 67.76, 66.34, 78.03, 83.34, 87.59, 88.65, 86.17, 78.38, 73.78, 72.72, 67.76, 60.67, 55.36, 48.63, 46.51, 38.71, 32.69, 29.51, 18.17, 7.19, 4.36, -5.91, -7.33, -16.18, -33.54, -38.5, -43.45, -48.77, -50.89, -57.27, -67.89, -69.31, -73.2, -75.68, -76.75, -81.0, -85.25, -91.27, -89.14, -91.62, -102.6, -113.58, -116.06, -108.27, -104.02, -97.64, -90.21, -87.37, -84.18, -76.39, -71.79, -62.93, -57.62, -50.18, -45.22, -39.2, -27.16, -17.95, -12.99, -1.66, 6.13, 12.15, 24.9, 29.86, 42.96, 49.34, 51.82, 62.44, 75.9, 80.15, 88.65, 89.01, 91.84, 98.22, 100.7, 104.24, 110.61, 109.2, 107.07, 113.09, 111.67, 103.17, 107.78, 111.32, 113.8, 114.86, 111.67, 107.78, 106.01, 96.09, 85.82, 80.86, 72.36, 68.47, 58.9, 42.26, 35.88, 31.63, 20.65, 16.05, 3.3, -12.29, -17.95, -24.33, -29.29, -39.56, -53.02, -61.87, -76.39, -83.48, -88.08, -93.04, -94.81, -104.02, -110.04, -111.1, -116.41, -115.71, -116.77, -128.1, -138.02, -141.56, -142.27, -137.66, -130.94, -126.33, -121.02, -114.29, -107.21, -99.77, -90.91, -86.66, -82.06, -66.12, -59.75, -44.87, -36.72, -31.06, -16.18, -2.37, 3.65, 22.07, 28.44, 33.76, 48.99, 59.26, 73.78, 84.05, 88.3, 95.74, 108.84, 114.86, 121.95, 124.07, 127.61, 132.57, 135.05, 140.01, 143.55, 143.2, 135.76, 130.8, 137.18, 144.97, 146.74, 147.09, 137.53, 133.63, 126.55, 116.63, 114.86, 106.72, 98.22, 78.74, 69.53, 62.44, 51.11, 36.24, 24.9, 8.96, -1.31, -7.68, -22.91, -30.0, -50.18, -65.06, -69.66, -79.58, -88.43, -91.62, -109.33, -121.02, -123.5, -134.12, -135.89, -139.44, -146.17, -146.87, -149.35, -158.21, -158.92, -168.83, -168.12, -162.1, -155.37, -149.0, -141.21, -132.0, -130.23, -121.02, -115.35, -106.5, -84.89, -78.16, -70.02, -58.68, -48.41, -31.77, -11.22, -4.49, 5.78, 25.96, 33.4, 51.47, 61.38, 74.13, 82.28, 90.07, 107.78, 123.72, 131.51, 138.24, 140.72, 152.05, 159.13, 162.32, 171.53, 169.41, 168.7, 174.01, 175.43, 174.72, 174.36, 171.18, 159.49, 157.36, 154.53, 147.45, 145.32, 137.18, 117.7, 107.78, 101.76, 91.13, 86.17, 61.03, 48.28, 44.03, 33.05, 12.86, 4.01, -20.08, -24.68, -37.43, -57.62, -64.35, -77.1, -93.39, -100.83, -116.77, -123.85, -125.62, -135.19, -146.87, -160.33, -167.77, -169.19, -166.71, -168.12, -170.25, -171.31, -165.29, -164.58, -163.52, -163.87, -161.04, -147.94, -141.56, -133.06, -118.89, -113.94, -106.14, -99.41, -83.12, -68.6, -59.04, -45.22, -33.54, -23.62, -5.2, 4.01, 10.03, 25.61, 34.46, 57.84, 76.26, 85.82, 107.78, 118.4, 120.18, 133.28, 147.45, 153.47, 164.09, 165.86, 170.47, 181.8, 184.64, 186.76, 189.24, 188.53, 185.34, 184.28, 181.09, 176.49, 174.72, 164.45, 153.82, 150.63, 139.65, 129.03, 124.43, 105.65, 97.51, 82.99, 66.69, 58.19, 44.74, 22.78, 12.86, -1.31, -19.37, -26.1, -44.52, -54.79, -72.85, -85.25, -91.98, -106.5, -121.02, -130.58, -142.27, -145.81, -153.96, -160.33, -163.87, -174.15, -177.69, -177.69, -182.29, -178.04, -176.62, -178.4, -177.69, -171.67, -163.52, -157.5, -150.06, -143.33, -136.6, -121.02, -108.27, -101.18, -85.25, -80.29, -64.35, -48.41, -38.85, -17.25, -1.66, 2.59, 23.13, 32.34, 51.47, 68.11, 74.49, 87.95, 107.78, 115.22, 127.61, 143.55, 147.45, 152.41, 155.95, 166.22, 176.49, 180.74, 183.22, 184.28, 186.05, 187.47, 191.72, 190.3, 182.86, 178.61, 173.3, 164.09, 161.26, 154.53, 141.43, 136.47, 117.34, 110.61, 98.22, 83.7, 72.72, 57.49, 43.67, 27.03, 16.76, 0.82, -12.29, -33.54, -35.66, -50.89, -69.31, -79.23, -98.35, -114.29, -118.19, -134.83, -140.85, -141.92, -155.02, -159.98, -166.71, -169.54, -170.25, -175.56, -182.65, -181.23, -177.33, -176.98, -173.79, -169.19, -168.48, -159.62, -149.0, -144.39, -129.16, -118.89, -116.41, -100.48, -90.21, -75.68, -59.04, -51.25, -36.02, -17.6, -8.74, 7.9, 27.74, 33.76, 46.51, 57.84, 77.32, 93.26, 101.05, 115.22, 127.26, 134.34, 148.51, 154.18, 166.93, 169.05, 169.41, 178.61, 186.41, 187.47, 186.76, 183.57, 183.22, 185.7, 184.28, 178.26, 173.66, 167.28, 155.24, 149.57, 143.55, 132.22, 125.84, 106.72, 91.13, 85.11, 71.3, 57.49, 48.28, 25.61, 8.61, 0.11, -18.31, -26.45, -40.62, -62.23, -69.66, -83.83, -98.71, -102.96, -116.06, -135.54, -141.56, -149.0, -154.31, -159.27, -167.42, -173.08, -178.04, -177.33, -178.4, -177.69, -176.98, -179.46, -174.85, -171.67, -167.06, -156.44, -151.12, -146.17, -132.0, -124.21, -107.91, -99.41, -85.6, -76.75, -67.18, -47.35, -32.83, -22.56, -5.2, 6.48, 15.69, 32.69, 42.96, 65.63, 76.61, 81.57, 99.63, 116.99, 125.13, 136.47, 139.65, 148.86, 164.8, 167.63, 175.07, 186.05, 187.47, 182.86, 189.59, 189.59, 188.53, 146.74, 140.72, 137.18, 137.53, 135.76, 133.63, 128.68, 116.63, 111.67, 105.65, 101.05, 89.36, 80.51, 73.78, 58.9, 46.86, 40.84, 31.28, 25.26, 6.48, -11.58, -15.83, -26.1, -36.02, -42.04, -60.1, -71.79, -75.68, -88.08, -90.56, -98.0, -114.29, -118.54, -120.66, -124.21, -125.62, -132.71, -142.27, -141.56, -137.31, -138.02, -134.83, -133.41, -133.77, -131.29, -123.5, -121.37, -110.04, -106.14, -102.25, -91.27, -84.89, -73.91, -57.62, -52.31, -46.29, -31.77, -23.62, -9.45, -0.6, 11.8, 20.65, 29.15, 46.51, 59.26, 65.28, 75.9, 84.05, 89.36, 100.7, 104.95, 118.4, 122.65, 123.72, 131.51, 139.65, 141.78, 144.97, 143.55, 140.72, 144.97, 144.61, 141.78, 140.01, 137.18, 127.61, 121.24, 119.82, 114.51, 110.26, 96.45, 84.05, 80.15, 70.59, 58.9, 53.59, 38.36, 24.19, 17.82, 3.65, -2.37, -11.93, -29.64, -37.79, -49.48, -61.87, -68.6, -78.87, -85.25, -94.81, -101.18, -106.85, -113.94, -121.37, -128.1, -133.77, -133.41, -134.48, -134.83, -135.54, -138.73, -136.6, -134.48, -131.29, -122.79, -119.96, -122.08, -113.58, -106.5, -96.58, -90.21, -81.35, -74.27, -67.89, -50.18, -39.2, -32.83, -19.02, -14.06, -1.31, 11.44, 18.53, 37.65, 47.92, 50.4, 63.51, 78.03, 84.4, 96.09, 100.34, 105.65, 116.63, 120.18, 128.68, 137.53, 139.3, 137.88, 141.07, 143.2, 147.09, 149.93, 145.68, 139.3, 139.65, 137.53, 131.86, 128.68, 118.4, 111.67, 103.88, 96.8, 93.97, 84.05, 65.28, 59.61, 48.99, 36.59, 31.99, 19.24, 11.09, -6.27, -18.66, -24.33, -31.06, -45.58, -55.5, -70.02, -77.1, -83.83, -93.39, -98.71, -109.69, -117.48, -121.73, -124.91, -125.98, -128.81, -138.73, -140.5, -138.37, -137.31, -135.54, -135.19, -134.83, -130.58, -122.08, -117.48, -110.39, -102.25, -100.12, -93.04, -81.0, -76.04, -61.16, -50.18, -45.93, -32.83, -18.31, -11.93, 5.42, 11.44, 17.82, 34.46, 42.61, 55.36, 69.53, 73.78, 81.92, 87.95, 101.76, 112.03, 115.93, 123.36, 128.32, 131.15, 137.18, 141.78, 144.26, 141.43, 138.59, 141.43, 145.68, 144.26, 141.07, 132.57, 129.38, 124.78, 115.57, 113.09, 109.9, 102.11, 85.47, 78.03, 73.07, 62.44, 49.69, 39.78, 25.96, 20.65, 9.67, -0.24, -7.68, -27.16, -42.04, -47.0, -58.68, -68.95, -75.33, -93.04, -97.64, -101.18, -110.75, -114.64, -121.02, -131.29, -132.35, -132.71, -135.54, -135.54, -137.31, -140.5, -139.08, -133.77, -132.71, -126.33, -121.02, -122.44, -114.64, -110.04, -101.18, -86.66, -80.64, -76.39, -64.7, -55.14, -40.62, -24.33, -20.43, -12.99, -5.56, 10.73, 23.84, 32.69, 45.8, 54.3, 59.26, 74.84, 88.3, 94.67, 101.05, 104.59, 116.99, 125.84, 128.68, 135.4, 138.59, 139.65, 143.2, 144.61, 145.32, 146.38, 146.38, 138.24, 136.47, 135.76, 131.51, 124.43, 119.11, 108.84, 106.01, 97.86, 90.42, 87.59, 72.01, 55.36, 51.47, 38.36, 25.96, 19.94, 0.82, -5.56, -14.41, -28.93, -35.66, -48.06, -65.41, -71.43, -78.87, -84.54, -91.62, -99.77, -108.27, -117.83, -122.79, -127.39, -130.58, -132.35, -136.96, -138.73, -138.02, -138.37, -133.06, -133.06, -138.37, -131.64, -124.21, -116.41, -108.62, -105.08, -100.12, -95.87, -83.48, -72.5, -65.06, -53.02, -43.81, -36.37, -20.43, -14.41, 1.53, 13.57, 17.82, 34.11, 48.28, 53.24, 68.11, 76.26, 80.15, 91.49, 97.86, 111.32, 120.88, 122.65, 125.49, 134.34, 137.53, 141.07, 147.09], "ucb": [-20.16, -24.39, -26.86, -30.38, -32.85, -34.26, -37.09, -39.2, -40.61, -42.38, -43.43, -44.49, -44.14, -43.79, -43.43, -44.14, -43.43, -41.32, -40.26, -38.14, -30.74, -26.5, -24.04, -23.33, -21.92, -18.74, -17.69, -15.22, -11.69, -8.87, -5.34, -1.11, 2.42, 7.0, 9.47, 11.24, 15.47, 17.94, 22.17, 24.29, 25.7, 29.93, 33.81, 35.22, 36.98, 38.75, 41.57, 43.69, 44.04, 45.8, 47.92, 47.21, 46.86, 48.27, 48.98, 48.27, 47.21, 45.45, 45.45, 44.39, 45.1, 44.74, 41.57, 35.22, 29.23, 26.76, 23.93, 23.58, 19.7, 16.17, 14.76, 11.94, 7.0, 5.59, 2.07, 1.36, -3.22, -6.75, -8.16, -9.93, -13.81, -15.22, -17.69, -19.8, -21.21, -24.39, -24.74, -25.8, -27.21, -28.97, -29.33, -29.33, -30.38, -31.09, -30.38, -29.33, -28.62, -28.27, -27.56, -23.33, -19.1, -14.16, -12.75, -12.04, -11.69, -11.69, -10.98, -8.87, -7.1, -3.93, -1.46, 0.3, 3.83, 5.59, 7.0, 10.88, 12.65, 14.41, 15.82, 18.29, 21.47, 22.52, 23.58, 24.99, 27.81, 28.52, 28.87, 29.93, 31.34, 31.69, 32.4, 32.4, 33.81, 33.81, 33.1, 33.1, 33.46, 33.1, 32.4, 30.99, 33.46, 33.81, 28.87, 23.23, 21.47, 19.7, 17.59, 15.12, 14.06, 13.0, 11.94, 9.12, 8.06, 5.59, 2.07, 1.36, 0.65, 0.65, -1.81, -4.99, -6.4, -7.81, -8.87, -9.93, -12.75, -12.4, -12.4, -14.16, -14.86, -15.22, -15.57, -15.92, -15.92, -15.57, -15.57, -16.63, -16.98, -15.57, -14.51, -13.1, -7.1, -0.76, -1.11, -2.17, -2.87, -2.52, -0.4, -0.05, -0.76, 0.65, 1.71, 3.12, 5.24, 5.59, 7.36, 7.71, 9.12, 9.83, 10.53, 12.29, 13.71, 13.71, 15.82, 16.88, 16.17, 16.17, 16.88, 18.64, 18.29, 17.59, 19.35, 21.11, 20.76, 19.0, 20.05, 20.41, 20.76, 20.41, 20.05, 19.35, 18.29, 17.94, 17.23, 16.88, 15.82, 14.41, 12.29, 11.94, 11.59, 9.83, 8.06, 8.06, 7.0, 5.95, 4.53, 2.77, 2.42, 1.01, -0.76, -0.4, -1.81, -3.58, -4.64, -4.99, -5.34, -5.69, -7.81, -7.46, -7.81, -8.52, -8.87, -9.93, -9.22, -9.22, -9.22, -9.57, -8.52, -10.28, -10.63, -8.16, -4.99, -3.93, -3.58, -5.69, -4.64, -2.17, -1.11, -1.11, 0.65, 2.07, 2.42, 4.18, 4.89, 6.3, 7.0, 7.36, 8.77, 9.47, 13.71, 16.88, 16.88, 15.47, 12.65, 11.94, 11.24, 11.24, 12.29, 11.59, 10.53, 11.59, 13.71, 14.06, 14.41, 14.76, 16.17, 13.0, 12.29, 12.65, 13.0, 13.35, 15.12, 16.17, 14.41, 9.83, 8.41, 7.0, 5.95, 6.3, 3.83, 3.12, 5.59, 5.95, 5.24, 4.53, 6.65, 7.0, 6.65, 4.89, 5.59, 6.3, 4.89, 4.89, 5.59, 7.71, 7.36, 5.59, 6.65, 9.12, 5.95, 4.89, 4.89, 5.24, 4.53, 4.18, 4.89, 5.59, 5.59, 5.59, 4.53, 4.89, 4.89, 3.48, 6.65, 6.65, 7.71, 5.59, 7.0, 7.71, 8.06, 5.95, 5.59, 5.24, 5.95, 5.24, 4.89, 5.95, 7.0, 6.3, 5.24, 5.24, 4.89, 5.59, 5.59, 6.3, 6.3, 5.95, 5.59, 5.95, 6.3, 5.59, 4.89, 5.59, 6.3, 7.0, 4.89, 4.53, 4.89, 5.59, 4.89, 0.3, -5.69, -5.69, 0.3, 8.41, 12.65, 16.53, 14.76, 12.29, 11.24, 10.18, 8.77, 7.0, 6.65, 5.95, 5.59, 4.18, 2.42, 2.42, 0.65, -2.52, -2.52, -4.28, -5.34, -5.34, -5.34, -5.69, -7.81, -9.22, -9.93, -9.93, -10.98, -10.63, -10.98, -9.57, -9.57, -9.93, -10.63, -9.93, -8.87, -10.63, -20.86, -28.62, -28.62, -24.04, -21.57, -15.57, -10.98, -10.63, -8.16, -4.28, -2.17, 0.65, 3.12, 4.89, 8.77, 10.88, 12.29, 15.12, 17.59, 20.05, 21.11, 22.17, 24.99, 27.11, 28.87, 29.58, 31.34, 35.93, 35.93, 35.57, 35.22, 37.69, 37.69, 36.28, 36.28, 36.63, 35.93, 34.87, 34.16, 28.87, 23.58, 19.0, 25.35, 28.52, 32.05, 32.05, 28.52, 26.05, 24.64, 20.41, 15.82, 13.71, 9.12, 4.18, 1.36, -2.17, -3.93, -9.22, -14.16, -15.57, -18.39, -22.27, -24.74, -27.92, -29.33, -31.79, -35.32, -35.67, -36.73, -39.2, -39.91, -41.32, -40.97, -41.67, -41.32, -42.38, -40.61, -38.5, -38.14, -41.32, -49.43, -52.61, -51.19, -42.73, -39.2, -30.74, -28.62, -24.39, -18.39, -14.86, -9.57, -4.64, -0.76, 5.59, 8.77, 14.06, 21.11, 23.93, 29.58, 34.52, 36.98, 42.98, 47.21, 48.62, 52.86, 54.97, 58.15, 59.56, 60.97, 64.5, 66.26, 66.61, 66.61, 67.67, 68.38, 66.61, 65.91, 64.85, 63.44, 62.03, 57.8, 54.97, 54.27, 48.62, 46.16, 42.28, 38.75, 35.57, 28.52, 23.93, 21.82, 17.94, 11.24, 11.24, 5.24, 1.71, -8.52, -14.16, -17.33, -21.92, -27.56, -31.09, -34.97, -39.91, -41.67, -45.55, -45.9, -48.02, -52.96, -54.02, -55.07, -55.78, -55.43, -56.49, -54.72, -54.72, -54.02, -54.37, -53.31, -50.49, -49.78, -46.26, -40.26, -38.85, -34.97, -33.56, -27.56, -22.27, -19.1, -14.51, -9.22, -5.69, 0.65, 6.65, 9.12, 15.47, 19.35, 24.29, 29.58, 31.69, 38.04, 37.69, 35.57, 38.4, 44.04, 56.74, 66.61, 71.2, 76.84, 78.25, 78.96, 80.72, 82.49, 82.13, 81.43, 81.78, 81.43, 79.31, 77.9, 74.37, 71.55, 69.43, 64.5, 59.91, 56.74, 51.45, 47.57, 39.45, 34.16, 30.99, 23.58, 15.12, 11.59, 5.95, 2.07, -7.1, -13.45, -16.63, -24.39, -37.44, -45.55, -60.37, -65.3, -67.07, -68.83, -69.54, -73.77, -79.06, -80.47, -82.94, -85.41, -85.76, -87.17, -86.82, -86.47, -87.17, -86.82, -83.64, -79.06, -77.65, -73.42, -69.18, -66.01, -60.01, -58.25, -50.49, -42.38, -38.5, -32.15, -22.27, -18.04, -8.16, 0.3, 4.89, 13.71, 18.29, 26.05, 35.22, 39.81, 44.04, 44.04, 45.8, 60.62, 76.49, 82.49, 91.66, 95.18, 102.24, 106.47, 107.18, 111.76, 113.17, 113.52, 112.47, 113.52, 113.17, 110.7, 108.59, 105.06, 101.88, 99.06, 92.71, 87.78, 83.9, 76.84, 71.55, 63.44, 54.97, 50.04, 39.45, 28.52, 23.93, 14.06, 3.83, -2.52, -12.4, -18.04, -27.56, -37.79, -44.49, -62.83, -80.47, -84.35, -87.52, -88.94, -95.28, -102.34, -104.45, -108.69, -113.63, -115.39, -118.21, -118.56, -119.62, -118.92, -118.56, -115.04, -111.86, -109.75, -106.57, -98.81, -95.28, -87.88, -80.12, -75.88, -66.71, -62.13, -53.31, -42.02, -35.67, -25.8, -14.16, -7.81, 5.95, 12.29, 23.93, 35.57, 42.98, 53.21, 57.8, 59.91, 66.97, 83.19, 91.66, 107.88, 114.23, 123.4, 129.4, 132.22, 137.86, 141.74, 143.15, 144.56, 145.27, 145.27, 142.45, 140.33, 137.86, 134.69, 130.81, 123.4, 117.05, 113.17, 104.35, 98.71, 89.54, 79.31, 72.96, 62.73, 49.68, 40.51, 27.46, 13.35, 7.36, -5.34, -12.4, -27.56, -40.61, -45.9, -61.78, -84.35, -94.58, -104.1, -110.8, -113.63, -121.39, -124.56, -134.08, -141.14, -144.31, -145.72, -148.54, -149.25, -151.01, -150.31, -149.6, -146.43, -143.96, -140.08, -133.02, -128.09, -121.39, -110.8, -105.51, -95.28, -89.99, -77.3, -61.78, -55.78, -43.43, -29.68, -22.27, -7.81, 0.65, 15.82, 31.69, 38.75, 52.5, 66.61, 70.49, 79.66, 91.3, 98.36, 119.87, 128.34, 139.98, 148.8, 153.73, 163.26, 168.2, 169.96, 173.84, 176.31, 176.66, 174.9, 175.25, 173.84, 167.84, 164.32, 157.97, 150.91, 145.97, 134.69, 128.69, 117.4, 105.06, 98.71, 83.9, 69.43, 62.38, 46.51, 30.28, 22.52, 5.95, -3.58, -18.74, -33.91, -43.08, -59.31, -75.88, -82.23, -95.28, -109.39, -116.09, -125.62, -129.85, -139.37, -147.84, -149.6, -155.25, -160.89, -163.01, -164.77, -165.83, -166.18, -164.42, -163.01, -157.71, -152.07, -148.9, -140.78, -130.91, -124.91, -115.04, -110.1, -95.99, -80.47, -74.83, -61.07, -43.08, -36.38, -21.92, -6.4, 2.77, 20.76, 27.81, 43.33, 59.91, 68.38, 83.54, 96.95, 104.35, 118.11, 124.46, 133.98, 145.27, 149.85, 157.97, 163.96, 166.08, 171.72, 174.54, 175.96, 175.6, 175.6, 175.25, 171.37, 168.2, 164.32, 155.85, 148.09, 134.33, 129.75, 127.63, 121.28, 114.58, 101.53, 87.78, 79.31, 62.38, 45.1, 37.69, 20.05, 11.24, -6.75, -24.04, -32.15, -50.14, -67.07, -74.47, -90.35, -105.16, -113.27, -124.91, -130.91, -141.84, -152.07, -156.66, -163.01, -169.35, -173.23, -175.7, -176.41, -177.82, -177.11, -176.41, -172.53, -167.59, -166.18, -158.42, -148.9, -144.31, -135.14, -128.44, -115.39, -101.63, -94.23, -79.06, -61.78, -54.02, -37.09, -19.8, -10.98, 7.0, 15.12, 32.05, 50.04, 58.85, 75.78, 90.6, 98.71, 113.88, 127.63, 133.28, 145.97, 152.32, 161.14, 168.9, 173.49, 180.89, 185.13, 186.18, 188.65, 189.71, 189.01, 186.54, 184.42, 180.89, 175.25, 171.02, 162.55, 153.38, 148.09, 135.04, 127.28, 114.94, 101.53, 93.07, 76.14, 59.91, 52.15, 34.52, 16.17, 8.06, -8.52, -18.39, -36.03, -52.96, -60.72, -76.24, -91.05, -98.46, -112.92, -122.09, -133.73, -144.31, -149.6, -157.71, -164.42, -167.94, -172.53, -177.11, -177.82, -178.53, -177.47, -175.35, -172.88, -171.47, -164.42, -156.66, -153.13, -143.25, -131.97, -125.26, -113.63, -107.63, -94.58, -77.3, -68.83, -51.55, -34.62, -25.45, -7.46, 1.36, 19.7, 35.93, 44.74, 61.32, 77.9, 86.37, 101.88, 115.64, 121.64, 135.75, 142.09, 153.03, 162.55, 167.14, 175.96, 181.6, 183.36, 187.95, 189.71, 189.36, 188.3, 187.24, 185.13, 179.84, 176.31, 168.55, 160.44, 155.14, 143.86, 138.21, 126.22, 112.47, 104.71, 89.19, 74.02, 65.55, 48.27, 30.99, 21.82, 4.18, -4.64, -23.33, -39.2, -47.31, -64.24, -79.76, -87.52, -101.63, -116.09, -123.85, -134.79, -140.08, -150.31, -159.13, -163.36, -169.0, -173.59, -176.06, -177.47, -177.82, -177.82, -176.06, -174.65, -168.65, -162.3, -159.48, -151.01, -140.08, -134.79, -123.5, -118.21, -103.75, -88.23, -81.53, -66.71, -48.73, -39.91, -22.62, -5.34, 3.12, 21.82, 30.99, 47.21, 64.85, 73.31, 89.19, 103.3, 111.41, 125.87, 132.22, 142.8, 154.44, 159.38, 168.9, 175.25, 179.48, 184.77, 187.24, 188.3, 189.01, 189.01, 188.3, 184.07, 180.19, 176.31, 169.25, 164.67, 154.44, 143.15, 137.16, 123.75, 117.05, 101.53, 87.07, 78.25, 62.03, 46.16, 38.04, 20.76, 11.24, -7.46, -24.04, -32.85, -51.19, -66.71, -73.77, -89.29, -104.81, -73.06, -78.71, -89.29, -99.16, -104.1, -111.16, -118.56, -122.8, -127.38, -130.2, -132.32, -136.2, -135.85, -135.14, -134.44, -134.08, -131.61, -126.68, -124.56, -118.92, -115.39, -107.28, -98.46, -93.87, -83.64, -71.65, -65.3, -54.72, -43.43, -36.38, -22.27, -16.28, -3.22, 11.59, 19.0, 31.69, 44.04, 51.09, 64.5, 76.14, 81.43, 93.07, 98.36, 107.88, 116.7, 120.93, 129.04, 134.33, 136.8, 141.04, 143.15, 145.62, 145.62, 145.62, 146.33, 144.56, 142.45, 138.92, 134.33, 131.16, 123.4, 118.46, 111.41, 101.53, 95.89, 84.6, 73.31, 68.38, 55.68, 41.22, 34.87, 22.52, 15.47, 0.65, -12.75, -19.1, -32.15, -46.26, -51.9, -62.83, -69.18, -81.18, -91.4, -96.34, -105.16, -113.27, -116.45, -122.8, -128.44, -130.56, -133.38, -134.44, -135.49, -136.2, -136.55, -134.44, -130.56, -128.44, -124.56, -117.51, -113.98, -106.22, -102.69, -92.46, -80.47, -75.88, -65.3, -52.25, -45.9, -32.85, -27.21, -13.81, 0.65, 7.0, 20.41, 34.16, 40.51, 53.92, 65.91, 72.26, 84.6, 90.6, 100.47, 110.0, 114.23, 122.69, 129.04, 131.87, 138.57, 142.45, 144.21, 144.92, 146.33, 147.03, 145.27, 143.86, 141.04, 137.86, 135.04, 129.04, 125.87, 118.82, 109.29, 104.71, 94.12, 83.9, 77.19, 64.14, 52.15, 45.45, 33.81, 26.4, 11.94, -0.76, -7.46, -20.51, -33.91, -40.61, -52.61, -65.66, -72.0, -81.88, -86.82, -97.05, -107.28, -110.8, -117.15, -123.5, -126.68, -131.26, -133.02, -134.79, -136.55, -136.55, -134.08, -132.32, -131.26, -127.73, -121.03, -118.56, -112.57, -110.1, -100.22, -89.99, -85.41, -75.18, -62.13, -55.78, -44.85, -31.79, -24.74, -10.63, -3.22, 9.47, 22.88, 30.28, 42.98, 54.62, 62.03, 75.08, 80.02, 91.3, 102.24, 106.82, 116.35, 123.05, 126.93, 134.69, 138.92, 141.04, 144.56, 145.27, 147.03, 145.97, 145.27, 144.56, 141.39, 139.27, 133.28, 127.63, 124.81, 116.7, 111.76, 103.3, 93.42, 86.72, 75.08, 63.79, 57.8, 44.39, 36.63, 22.88, 10.18, 3.48, -10.98, -24.04, -30.38, -43.08, -56.13, -62.13, -72.36, -78.35, -89.29, -99.16, -103.4, -111.86, -119.62, -123.15, -127.03, -129.14, -133.02, -135.49, -135.49, -134.79, -135.14, -134.44, -131.61, -125.62, -123.85, -118.92, -115.04, -106.92, -98.11, -94.23, -83.64, -71.65, -66.71, -55.07, -42.38, -35.67, -22.27, -15.92, -2.52, 12.65, 19.7, 32.75, 44.74, 51.8, 64.85, 70.85, 81.43, 93.07, 99.42, 108.59, 115.64, 120.23, 129.04, 134.33, 136.1, 141.04, 143.15, 145.97, 145.97, 146.68, 146.68, 143.51, 141.74, 137.51, 133.28, 129.75, 121.99, 118.11, 110.35, 101.53, 95.54, 84.6, 73.31, 67.67, 55.33, 47.57, 35.57, 22.88, 15.82, 0.3, -13.45, -18.74, -32.85, -46.96, -52.25, -63.89, -69.18, -81.18, -91.05, -94.58, -104.45, -113.98, -116.45, -122.8, -128.44, -130.56, -134.08, -134.44, -135.49, -136.55, -136.2, -134.08, -130.91, -128.44, -123.5, -120.33, -112.57, -105.51, -102.34, -92.46, -80.82, -75.88, -64.95, -52.25, -46.26, -33.91, -27.92, -14.51, 0.65, 7.0, 20.41, 34.52, 41.57, 54.62, 65.91, 72.96, 84.6, 90.25, 99.77, 110.0, 114.23, 123.05, 129.4, 131.87, 138.21, 140.33, 144.21, 146.33, 146.68, 148.09, 145.62, 144.21, 142.45, 138.21, 135.39, 127.99, 125.87, 118.46, 108.94, 104.0, 93.07, 83.19, 76.84, 64.5, 53.21, 46.86, 32.75, 26.05, 13.0, -0.05, -7.1, -21.57, -35.32, -41.32], "ia": [3.14, 3.14, 3.63, 3.63, 3.39, 3.39, 3.88, 3.88, 3.39, 2.9, 3.14, 3.88, 3.88, 3.39, 3.88, 4.37, 3.63, 3.39, 3.63, 3.88, 3.39, 2.9, 3.39, 4.13, 3.88, 2.9, 3.63, 4.37, 4.13, 4.37, 4.86, 5.85, 4.86, 3.39, 3.63, 4.13, 4.13, 3.63, 2.9, 3.39, 3.39, 3.39, 3.14, 4.37, 4.37, 4.37, 3.63, 4.13, 4.62, 4.13, 3.63, 3.39, 3.88, 3.63, 2.65, 3.14, 3.63, 3.63, 3.63, 3.88, 4.37, 3.39, 3.39, 3.63, 3.88, 4.62, 3.88, 3.88, 4.13, 3.88, 3.39, 3.39, 3.39, 3.88, 3.14, 2.65, 3.63, 4.13, 4.13, 3.39, 3.88, 4.37, 4.13, 3.39, 3.63, 4.13, 3.63, 2.4, 3.14, 3.63, 3.63, 3.39, 2.9, 3.63, 3.88, 3.63, 3.88, 4.37, 4.37, 3.39, 3.39, 3.63, 3.63, 3.39, 3.39, 3.39, 3.63, 3.14, 2.65, 3.63, 4.37, 4.37, 3.14, 2.9, 3.88, 4.13, 3.39, 3.39, 4.13, 3.88, 3.14, 3.39, 3.88, 3.63, 3.39, 3.14, 4.13, 4.13, 3.14, 3.63, 4.37, 4.37, 4.13, 3.39, 3.88, 4.13, 3.63, 3.39, 3.39, 3.63, 3.39, 2.65, 3.14, 3.63, 3.88, 3.63, 3.88, 4.86, 4.13, 4.13, 4.13, 4.62, 3.39, 2.9, 3.39, 4.37, 4.13, 4.13, 4.13, 3.63, 3.63, 3.39, 3.63, 4.13, 4.13, 3.63, 3.14, 4.37, 4.37, 3.14, 2.4, 3.14, 4.86, 5.11, 3.14, 3.63, 4.13, 4.13, 3.14, 3.63, 4.86, 4.62, 3.63, 3.63, 4.37, 4.37, 3.14, 3.39, 4.37, 3.88, 2.9, 3.14, 3.63, 4.13, 3.88, 4.13, 4.62, 4.86, 4.13, 3.39, 3.39, 4.37, 3.63, 3.14, 3.14, 3.63, 3.39, 2.65, 3.39, 4.13, 3.39, 4.13, 5.11, 4.37, 4.13, 3.14, 4.37, 5.11, 5.11, 2.9, 3.39, 5.11, 5.11, 4.13, 3.39, 3.39, 3.88, 3.39, 3.14, 3.88, 4.37, 3.88, 4.13, 4.13, 4.62, 3.88, 3.39, 3.39, 4.37, 4.37, 3.39, 3.63, 4.13, 4.13, 3.63, 3.39, 4.13, 3.88, 3.14, 3.63, 4.37, 4.37, 4.13, 4.37, 4.37, 3.39, 2.65, 2.65, 3.14, 3.88, 4.13, 3.63, 4.13, 4.62, 4.62, 4.37, 3.88, 2.9, 2.16, 1.42, 3.88, 4.13, 3.14, 2.4, 2.9, 3.39, 3.14, 2.65, 3.14, 4.62, 3.88, 3.39, 3.14, 4.13, 4.37, 4.13, 3.14, 3.88, 3.63, 4.13, 3.14, 4.13, 3.63, 3.14, 2.65, 3.88, 4.37, 3.63, 3.39, 3.39, 4.37, 3.63, 3.14, 3.63, 4.13, 3.39, 2.4, 3.14, 4.37, 4.37, 3.88, 2.9, 3.14, 3.88, 2.16, 2.4, 2.4, 3.63, 3.63, 3.39, 3.14, 3.39, 3.14, 2.65, 3.39, 3.63, 3.14, 2.16, 4.13, 4.62, 3.39, 3.14, 3.63, 5.11, 4.62, 3.39, 3.14, 3.63, 4.86, 4.13, 4.13, 4.62, 4.62, 3.14, 3.88, 4.37, 3.63, 2.9, 3.88, 4.37, 4.37, 3.63, 4.37, 4.13, 3.63, 3.14, 2.65, 3.63, 5.6, 5.6, 2.9, 3.14, 3.88, 5.11, 4.37, 3.88, 4.86, 4.62, 3.88, 4.62, 4.86, 4.37, 4.13, 3.14, 3.88, 4.37, 3.88, 3.14, 3.14, 4.13, 4.62, 4.37, 5.11, 5.11, 6.09, 4.86, 4.62, 4.13, 3.63, 2.65, 3.88, 4.37, 4.62, 2.9, 2.65, 3.39, 4.13, 3.63, 4.13, 4.37, 3.88, 4.62, 5.6, 5.36, 3.39, 3.39, 3.14, 3.63, 3.63, 2.9, 2.65, 3.63, 4.37, 4.37, 4.13, 5.11, 5.11, 4.13, 3.88, 3.88, 4.37, 3.63, 2.9, 3.63, 3.88, 3.63, 2.9, 3.39, 4.13, 3.88, 3.39, 3.88, 4.37, 4.62, 3.63, 3.88, 3.88, 3.88, 3.63, 3.39, 3.39, 3.88, 3.14, 2.65, 3.14, 4.13, 4.62, 2.9, 3.14, 3.63, 4.37, 5.11, 5.6, 4.62, 3.88, 2.9, 3.14, 3.63, 3.63, 2.65, 3.39, 4.13, 4.13, 3.39, 3.63, 4.13, 4.13, 3.39, 3.63, 3.88, 3.88, 3.14, 3.14, 3.14, 3.63, 3.14, 2.65, 3.14, 3.63, 3.88, 3.39, 3.39, 4.13, 3.63, 3.14, 3.39, 4.13, 3.63, 2.9, 3.39, 3.88, 3.63, 3.14, 3.14, 3.88, 3.88, 3.39, 2.9, 3.39, 4.13, 4.37, 3.88, 3.88, 3.88, 3.39, 3.14, 3.39, 3.63, 2.9, 2.65, 3.14, 3.63, 3.88, 3.39, 3.63, 4.62, 4.13, 3.39, 3.63, 4.13, 3.88, 3.14, 3.39, 3.88, 3.39, 3.14, 3.39, 3.88, 3.88, 3.39, 3.39, 3.88, 4.13, 4.13, 3.63, 3.88, 3.88, 3.39, 3.39, 3.63, 3.88, 3.88, 3.39, 3.88, 3.88, 3.39, 2.65, 2.9, 4.13, 3.88, 3.14, 3.14, 4.13, 3.39, 4.13, 4.62, 3.63, 3.88, 3.39, 3.14, 2.9, 4.13, 3.63, 3.39, 3.88, 5.11, 4.86, 3.88, 3.88, 4.13, 3.88, 3.14, 4.62, 5.36, 4.86, 3.88, 3.88, 3.63, 3.88, 3.63, 3.14, 4.13, 4.13, 3.63, 3.39, 4.13, 4.13, 2.9, 3.14, 4.13, 4.13, 3.14, 3.14, 3.63, 4.13, 3.39, 3.39, 4.13, 4.37, 4.13, 3.63, 3.63, 4.37, 3.88, 3.39, 2.65, 4.37, 4.13, 2.4, 3.39, 3.63, 3.39, 2.9, 3.39, 4.37, 4.13, 3.63, 3.63, 4.37, 4.37, 4.13, 3.63, 3.63, 3.63, 3.39, 3.39, 3.39, 3.88, 2.9, 2.4, 2.9, 3.63, 4.13, 3.63, 3.39, 4.37, 3.88, 3.14, 3.63, 3.88, 3.63, 2.65, 3.14, 3.88, 3.88, 3.39, 3.63, 4.62, 4.13, 3.39, 3.39, 3.88, 3.39, 3.88, 3.63, 3.88, 3.88, 3.14, 2.65, 2.9, 3.39, 3.39, 2.4, 3.39, 3.88, 4.13, 3.88, 3.63, 4.62, 4.13, 3.39, 2.9, 3.63, 2.9, 2.4, 2.4, 3.39, 3.88, 3.39, 3.14, 3.63, 4.13, 3.39, 3.39, 3.88, 4.13, 3.88, 3.39, 4.13, 3.88, 3.14, 2.65, 3.39, 3.39, 3.39, 3.14, 3.63, 4.37, 3.88, 3.14, 3.63, 4.86, 5.11, 3.88, 3.14, 3.88, 4.13, 3.39, 3.39, 3.88, 3.63, 3.14, 3.39, 3.39, 4.37, 3.63, 3.88, 4.13, 4.13, 5.11, 4.37, 4.37, 3.88, 3.14, 3.14, 3.39, 3.88, 3.88, 2.9, 2.9, 3.88, 4.13, 3.39, 3.63, 4.86, 4.13, 2.65, 3.39, 3.88, 4.62, 4.13, 4.86, 4.86, 4.86, 4.13, 2.9, 3.14, 3.39, 2.9, 2.9, 3.14, 3.63, 3.39, 3.63, 3.63, 4.13, 3.39, 2.9, 3.39, 3.88, 3.88, 2.9, 3.39, 4.13, 3.88, 3.88, 4.62, 5.11, 4.62, 3.63, 3.39, 3.88, 3.88, 3.63, 3.14, 3.88, 4.13, 2.9, 2.65, 3.39, 3.88, 4.37, 3.39, 3.39, 3.88, 4.37, 3.63, 3.14, 3.63, 2.9, 2.65, 3.39, 3.88, 3.39, 2.9, 2.9, 4.13, 3.88, 3.39, 4.13, 4.37, 4.86, 3.39, 3.39, 3.63, 3.63, 3.39, 3.14, 3.63, 3.39, 3.14, 2.9, 3.39, 3.63, 3.88, 2.9, 3.63, 4.13, 4.13, 3.39, 3.39, 3.88, 3.63, 2.16, 2.65, 3.63, 3.63, 2.65, 2.9, 5.11, 5.11, 4.13, 3.39, 3.39, 3.88, 3.39, 3.39, 4.13, 3.63, 3.63, 3.14, 3.39, 5.6, 4.62, 4.37, 2.9, 3.39, 3.39, 2.9, 3.39, 4.13, 3.39, 2.9, 3.63, 4.62, 3.63, 2.9, 3.63, 4.13, 3.88, 3.39, 2.9, 3.63, 3.63, 3.63, 3.88, 4.13, 4.62, 3.39, 3.63, 4.13, 4.86, 3.63, 2.9, 2.9, 3.39, 2.9, 2.4, 3.14, 3.88, 3.88, 2.9, 2.9, 3.14, 4.13, 4.13, 3.63, 3.63, 4.37, 3.63, 4.13, 3.39, 3.14, 3.14, 4.13, 4.62, 4.62, 3.39, 3.14, 3.14, 3.88, 3.63, 2.9, 4.13, 4.37, 4.13, 3.63, 3.39, 3.88, 3.39, 2.65, 3.39, 3.88, 3.63, 3.14, 3.39, 4.86, 4.62, 3.88, 4.62, 5.6, 4.86, 3.14, 3.14, 3.63, 3.39, 3.14, 2.9, 3.63, 3.39, 3.14, 3.14, 4.13, 4.62, 4.13, 3.63, 4.37, 4.62, 3.88, 3.14, 3.63, 4.13, 3.88, 2.9, 3.39, 3.88, 3.88, 3.39, 3.39, 4.37, 4.86, 4.13, 3.88, 4.62, 5.36, 4.13, 4.13, 3.63, 3.39, 3.14, 3.39, 3.39, 3.88, 3.14, 3.14, 3.39, 3.63, 3.88, 3.63, 3.88, 5.11, 4.37, 3.39, 3.63, 4.13, 3.88, 2.9, 3.39, 3.88, 3.88, 3.39, 3.63, 4.62, 4.13, 2.9, 3.63, 4.37, 4.37, 3.14, 3.39, 3.88, 4.13, 3.63, 2.9, 2.9, 3.39, 3.14, 3.14, 3.39, 4.13, 3.88, 3.39, 3.39, 4.37, 3.88, 3.39, 3.39, 4.13, 3.63, 2.9, 3.39, 3.88, 3.63, 3.14, 3.14, 4.13, 4.13, 3.14, 3.39, 3.88, 3.88, 3.88, 3.39, 3.88, 3.88, 3.14, 3.14, 3.39, 3.88, 3.88, 2.9, 3.14, 3.63, 3.63, 3.14, 3.14, 4.37, 3.88, 3.14, 3.63, 3.88, 4.13, 3.14, 3.14, 3.39, 3.63, 3.39, 4.13, 6.09, 5.36, 4.37, 3.14, 3.63, 3.88, 3.88, 4.13, 4.13, 3.88, 3.14, 2.65, 3.39, 3.88, 3.88, 3.88, 4.13, 4.62, 3.88, 3.14, 3.39, 4.62, 4.13, 3.14, 4.86, 5.36, 5.6, 3.39, 3.63, 3.88, 3.63, 3.14, 3.14, 3.63, 4.13, 2.9, 3.14, 3.88, 4.13, 4.13, 3.39, 3.39, 4.13, 3.63, 3.14, 3.14, 3.63, 3.63, 2.9, 3.39, 3.88, 3.63, 3.14, 3.63, 4.86, 4.37, 3.39, 3.39, 3.88, 3.63, 2.65, 3.14, 4.13, 3.88, 3.14, 3.39, 3.39, 4.13, 3.63, 3.63, 4.13, 4.62, 3.88, 3.39, 3.39, 4.13, 3.63, 3.14, 3.14, 3.63, 3.63, 2.65, 3.14, 4.13, 3.88, 3.63, 3.63, 4.13, 4.13, 3.63, 3.39, 3.88, 3.63, 3.14, 3.14, 4.13, 3.88, 3.14, 2.9, 3.14, 3.63, 3.88, 3.39, 4.13, 4.62, 4.62, 3.88, 3.63, 3.88, 3.63, 2.9, 3.39, 3.88, 3.63, 3.14, 3.63, 4.37, 3.88, 3.39, 3.63, 4.62, 4.13, 3.39, 3.63, 4.13, 3.63, 3.39, 3.14, 3.88, 4.37, 3.88, 3.39, 3.63, 4.13, 4.13, 4.13, 4.13, 4.62, 4.37, 4.86, 4.86, 4.37, 3.88, 3.14, 3.39, 3.63, 3.14, 2.9, 3.14, 3.88, 4.62, 3.88, 5.11, 4.37, 3.14, 2.65, 3.39, 4.13, 3.88, 3.39, 3.39, 4.37, 3.88, 3.39, 3.39, 3.88, 3.63, 2.65, 3.39, 3.88, 3.63, 3.14, 3.39, 4.13, 3.88, 3.14, 3.39, 4.13, 3.88, 2.9, 3.39, 3.88, 4.13, 3.39, 2.9, 2.9, 3.63, 3.39, 3.39, 4.13, 4.62, 4.13, 3.63, 3.63, 4.62, 3.88, 3.39, 3.39, 3.88, 3.63, 2.65, 2.9, 3.88, 4.13, 3.39, 3.63, 4.37, 3.88, 3.14, 3.63, 4.37, 4.13, 3.63, 3.14, 3.39, 3.39, 2.9, 3.39, 3.39, 3.39, 3.39, 2.4, 3.14, 3.63, 3.63, 3.14, 3.39, 4.86, 4.37, 3.39, 3.39, 3.88, 3.63, 2.65, 3.39, 3.88, 3.88, 3.39, 3.63, 4.37, 4.13, 3.14, 3.39, 3.88, 3.88, 3.88, 3.39, 3.88, 3.88, 3.14, 2.65, 3.14, 3.63, 3.88, 3.39, 3.88, 4.62, 4.37, 3.63, 3.88, 3.88, 3.63, 2.9, 3.39, 3.88, 3.63, 2.65, 2.9, 3.63, 3.39, 3.14, 3.14, 3.63, 4.13, 3.14, 3.39, 4.62, 4.37, 3.88, 3.39, 3.39, 4.13, 3.39, 2.9, 3.39, 4.13, 3.88, 3.14, 3.63, 4.37, 4.13, 3.39, 3.63, 4.62, 4.13, 3.14, 3.14, 3.39, 3.39, 3.14, 2.65, 3.39, 3.63, 3.39, 3.63, 3.88, 4.37, 3.63, 3.88, 3.88, 4.62, 4.13, 3.39, 3.63, 4.13, 3.14, 2.65, 3.39, 3.88, 3.88, 3.39, 3.39, 4.37, 4.13, 3.39, 3.63, 5.11, 4.62, 3.39, 3.63, 3.63, 3.39, 3.39, 3.14, 3.88, 3.88, 2.9, 3.14, 3.88, 4.13, 4.37, 3.39, 3.63, 4.13, 4.13, 3.39, 3.63, 3.88, 3.14, 2.65, 3.14, 3.63, 3.63, 2.9, 2.9, 3.88, 4.13, 3.39, 3.88, 4.13, 4.37, 3.39, 3.39, 3.88, 3.63, 3.14, 3.14, 3.88, 3.88, 3.14, 3.14, 3.63, 3.88, 4.37, 3.63, 4.13, 4.62, 4.13, 3.39, 3.63, 4.37, 4.13, 3.14, 3.39, 3.63, 3.39, 3.14, 3.39, 4.62, 4.13, 3.14, 3.39, 4.13, 3.88, 3.39, 3.39, 3.88, 3.63, 3.39, 3.39, 3.63, 3.88, 3.14, 3.14, 3.63, 3.88, 4.13, 3.63, 4.13, 4.62, 3.88, 3.14, 3.39, 4.13, 3.88, 3.14, 3.39, 3.88, 3.63, 3.14, 3.14, 4.13, 3.88, 3.14, 3.39, 3.88, 4.13, 3.39, 3.39, 3.88, 3.88, 3.39, 3.39, 3.39, 3.88, 3.39, 2.9, 3.14, 3.63, 3.63, 3.14, 3.39, 4.37, 3.88, 3.14, 3.39, 3.88, 3.63, 2.9, 3.14, 3.88, 3.63, 3.14, 3.14, 4.13, 4.13, 3.63, 3.63, 3.88, 4.13, 4.13, 3.39, 4.13, 4.37, 3.63, 3.39, 3.14, 3.63, 3.14, 2.65, 3.63, 4.13, 3.88, 3.14, 3.14, 3.88, 3.63, 3.14, 3.14, 3.63, 3.14, 2.4, 2.9, 3.88, 3.63, 3.14, 2.9, 3.63, 3.63, 3.63, 3.63, 4.37, 4.62, 4.13, 3.39, 3.88, 3.88, 3.39, 2.9, 3.14, 3.39, 3.39, 2.4, 3.63, 4.13, 3.88, 2.9, 3.14, 4.13, 4.13, 3.39, 3.14, 3.63, 3.63, 2.65, 2.9, 3.88, 3.88, 3.39, 3.63, 4.13, 4.37, 3.39, 3.39, 4.13, 4.37, 4.13, 3.39, 3.63, 3.88, 3.39, 3.14, 3.39, 3.88, 3.63, 2.9, 3.63, 4.13, 3.88, 3.39, 3.63, 4.37, 3.88, 3.14, 3.39, 3.88, 4.13, 3.14, 3.14, 3.63, 3.63, 3.14], "ic": [1.32, 1.07, 1.32, 1.07, 1.07, 1.81, 2.3, 1.81, 1.32, 1.56, 2.3, 1.56, 0.58, 1.07, 1.81, 1.56, 0.33, 1.07, 1.56, 1.81, 1.32, 1.32, 1.32, 1.81, 1.07, 1.07, 1.81, 1.81, 1.56, 2.06, 3.29, 3.04, 1.56, 0.58, 1.32, 1.81, 1.81, 1.07, 2.06, 2.06, 1.81, 1.32, 1.32, 2.06, 1.81, 0.58, 1.07, 1.81, 1.56, 0.33, 0.82, 1.32, 1.32, 1.32, 1.81, 1.56, 1.81, 1.07, 1.32, 1.81, 2.8, 2.3, 1.07, 1.07, 6.25, 5.26, 2.3, 1.32, 1.56, 1.81, 1.07, 1.56, 2.3, 1.81, 1.56, 1.81, 2.06, 1.81, 1.32, 1.81, 2.3, 1.56, 1.07, 0.82, 1.32, 1.32, 0.82, 1.32, 1.56, 1.56, 1.07, 1.56, 2.3, 2.06, 1.32, 1.32, 1.32, 2.06, 1.07, 0.33, 0.82, 1.56, 1.56, 0.82, 1.32, 2.3, 1.81, 1.07, 1.56, 2.3, 1.81, 1.07, 1.32, 2.06, 1.56, 1.07, 1.07, 1.81, 1.56, 0.82, 1.07, 1.32, 1.56, 1.56, 1.32, 2.06, 2.55, 2.06, 1.81, 1.81, 2.06, 1.32, 0.58, 0.82, 1.56, 1.56, 0.82, 1.32, 2.06, 1.81, 1.07, 1.56, 1.81, 1.56, 0.82, 1.32, 1.81, 1.56, 1.07, 1.07, 1.81, 1.32, 0.82, 0.82, 1.56, 1.56, 1.56, 0.82, 1.56, 2.06, 1.56, 1.32, 1.56, 2.06, 1.56, 0.33, 0.82, 1.32, 1.32, 0.82, 1.07, 1.81, 1.07, 0.82, 1.56, 1.81, 2.06, 0.82, 1.32, 2.3, 2.3, 1.81, 1.81, 1.56, 1.81, 0.82, 0.33, 0.82, 0.33, 0.08, -0.16, 1.81, 2.06, 1.32, 0.58, 1.32, 2.06, 1.56, 0.33, 0.58, 1.56, 1.56, 1.07, 2.3, 3.04, 2.55, 1.07, 1.81, 2.55, 2.55, 1.07, 0.33, 1.32, 1.56, 1.32, 1.81, 1.81, 2.3, 2.06, 1.81, 2.3, 1.56, 1.56, 0.82, 1.32, 2.3, 2.3, 1.56, 2.06, 1.81, 1.56, 0.33, 1.07, 2.3, 2.06, 1.81, 1.07, 1.32, 1.56, 1.32, 1.81, 1.81, 1.81, 1.56, 1.81, 1.81, 1.32, 0.33, 1.32, 1.32, 2.3, 1.56, 1.32, 1.07, 1.56, 1.56, 1.56, 2.06, 2.3, 1.81, 1.07, 1.32, -0.16, -0.41, 1.32, 1.56, 2.3, 1.56, 1.07, 0.82, 1.56, 1.32, 0.82, 0.82, 1.81, 2.06, 1.81, 1.32, 2.3, 3.04, 1.56, 1.07, 1.32, 2.06, 1.56, 0.33, -0.66, -0.16, 1.81, 1.07, 1.07, 1.81, 2.06, 1.32, 1.56, 1.81, 1.81, 1.07, 1.56, 2.06, 1.81, 1.56, 0.33, 0.58, 1.07, 0.82, 1.07, 1.56, 3.78, 3.78, 1.32, 1.81, 2.06, 2.06, 1.32, 1.56, 1.56, 1.32, 0.58, 1.32, 1.81, 1.56, 0.82, 1.07, 2.06, 1.81, 1.32, 1.56, 1.81, 2.06, 1.56, 1.81, 2.55, 2.06, 1.81, 2.3, 1.56, 1.56, 0.08, -0.41, 0.82, 1.56, 1.56, 2.3, 2.06, 2.3, 1.81, 0.82, 1.07, 2.8, 4.27, 3.29, 2.8, 2.06, 2.3, 1.56, 1.32, 2.3, 1.56, 0.58, 1.56, 1.81, 2.06, 1.32, 2.06, 2.55, 1.56, 0.82, 0.82, 0.33, 0.33, 0.33, 0.82, 0.82, 1.32, 1.81, 2.55, 3.29, 3.04, 2.06, 1.56, 2.06, 2.06, 1.56, 0.58, 0.58, 1.07, 1.32, 0.82, 0.82, 1.81, 1.81, 1.07, 1.32, 1.07, 1.56, 2.3, 1.81, 1.81, 1.81, 1.32, 1.32, 2.06, 2.06, 2.06, 0.82, 1.56, 2.3, 1.81, 1.56, 2.06, 2.55, 2.06, 1.32, 1.56, 2.06, 2.3, 1.81, 1.81, 2.55, 1.81, 1.56, 1.07, 1.32, 1.56, 0.82, 1.07, 1.81, 2.06, 1.56, 1.32, 2.06, 1.81, 1.07, 0.58, 1.32, 1.32, 1.56, 1.07, 1.32, 2.06, 1.81, 1.32, 1.56, 2.55, 2.06, 0.82, 1.32, 2.06, 1.81, 0.33, 0.82, 1.32, 1.32, 0.82, 1.32, 1.32, 1.32, 0.82, 1.07, 1.81, 2.3, 1.32, 1.32, 1.32, 1.81, 1.07, 0.33, 0.82, 1.56, 1.32, 0.58, 1.07, 1.81, 1.56, 0.82, 1.56, 2.3, 1.81, 0.58, 1.07, 1.81, 1.81, 1.32, 1.07, 1.81, 1.32, 0.82, 1.07, 1.32, 1.81, 2.06, 1.07, 1.56, 2.06, 1.32, 0.82, 1.07, 2.06, 1.32, 0.82, 1.32, 2.06, 1.32, 0.58, 1.07, 1.81, 1.32, 0.58, 1.56, 2.3, 2.06, 0.82, 1.56, 1.81, 1.56, 1.56, 1.56, 2.06, 1.56, 1.07, 0.58, 1.07, 1.32, 1.32, 1.07, 1.81, 2.3, 1.56, 1.56, 1.81, 2.06, 1.81, 1.07, 1.07, 1.81, 1.32, 0.58, 1.07, 1.81, 1.81, 1.07, 1.81, 1.81, 1.81, 0.58, 0.82, 1.81, 3.53, 3.29, 2.8, 2.06, 1.56, 1.07, 0.82, 1.56, 2.06, 2.06, 1.56, 1.81, 2.3, 1.81, 1.07, 1.56, 2.06, 2.3, 0.82, 0.82, 1.56, 1.81, 1.07, 1.56, 2.06, 1.81, 1.56, 2.3, 2.06, 1.81, 0.58, 0.82, 1.07, 1.56, 2.55, 2.06, 2.06, 2.06, 1.07, 1.07, 1.32, 1.56, 1.56, 1.07, 1.32, 2.06, 1.81, 1.07, 1.56, 2.06, 1.56, 0.82, 1.56, 2.06, 1.56, 1.07, 1.07, 2.55, 2.55, 1.56, 1.32, 2.06, 1.56, 1.32, 1.32, 2.3, 2.3, 1.32, 0.82, 1.07, 1.81, 1.07, 0.58, 1.32, 1.81, 1.56, 1.07, 1.32, 2.3, 1.81, 1.07, 1.56, 2.06, 1.56, 0.33, 0.82, 1.81, 1.56, 1.07, 1.32, 2.06, 1.56, 0.82, 0.58, 1.81, 2.3, 2.06, 1.56, 1.81, 2.06, 1.32, 1.07, 1.07, 1.81, 1.56, 0.58, 1.07, 1.56, 1.32, 1.32, 1.81, 2.3, 1.81, 1.32, 1.81, 2.06, 1.56, 0.58, 1.32, 1.56, 1.32, 0.82, 1.32, 1.07, 1.56, 0.82, 0.82, 1.07, 1.32, 1.56, 1.32, 1.81, 2.3, 1.56, 0.82, 1.56, 1.81, 1.56, 0.33, 1.07, 1.56, 1.56, 1.07, 1.56, 2.3, 2.06, 1.32, 1.81, 2.06, 1.81, 0.58, 1.07, 1.81, 1.81, 1.07, 1.56, 1.56, 2.3, 1.32, 1.07, 1.56, 1.07, 1.32, 1.32, 1.56, 2.06, 1.56, 1.32, 2.06, 1.81, 1.32, 0.33, 1.32, 2.06, 1.81, -0.9, -0.41, 2.55, 1.81, 0.82, 1.56, 1.81, 2.8, 2.3, 1.07, 2.06, 2.06, 1.07, 1.07, 1.32, 1.56, 0.82, 0.82, 1.07, 1.56, 1.32, 1.56, 1.56, 2.06, 1.56, 0.82, 1.56, 2.8, 2.3, 1.07, 1.07, 1.81, 1.32, 1.32, 1.56, 2.06, 1.81, 1.32, 1.56, 1.81, 1.81, 2.55, 1.81, 0.82, 0.82, 0.08, 0.58, 0.58, 1.07, 1.32, 0.82, 1.32, 2.06, 1.81, 1.81, 1.56, 2.06, 1.81, 1.07, 2.3, 2.55, 2.55, 0.82, 1.32, 2.06, 1.56, 1.07, 1.56, 1.56, 2.06, 1.81, 2.06, 1.56, 1.56, 1.56, 1.07, 1.81, 1.32, 1.56, 1.56, 1.81, 1.56, 1.56, 1.07, 1.32, 1.81, 1.56, 1.56, 1.56, 0.82, 0.58, 0.08, 1.56, 2.06, 1.32, 0.58, 1.07, 1.56, 1.32, 1.32, 1.56, 1.07, 1.56, 1.07, 1.32, 1.81, 1.56, 1.32, 1.07, 1.32, 2.06, 1.32, 0.58, 1.07, 1.81, 1.56, 1.56, 2.3, 3.04, 1.07, 0.33, 0.58, 3.29, 3.04, 1.56, 2.3, 2.8, 2.06, 1.32, 1.07, 1.32, 1.56, 1.07, 1.32, 1.81, 1.56, 0.58, 0.82, 1.56, 2.06, 1.81, 1.56, 1.81, 1.81, 1.32, 0.33, 0.82, 1.32, 1.32, 0.58, 1.07, 1.07, 0.58, 1.56, 2.3, 2.06, 2.3, 1.81, 2.3, 0.08, 0.82, 2.3, 1.07, 2.06, 2.06, 1.56, 1.56, 1.56, 1.32, 1.56, 0.58, 1.32, 1.56, 1.07, 1.81, 2.3, 2.3, 1.56, 1.32, 1.81, 2.06, 1.56, 1.07, 1.56, 2.55, 2.3, 1.56, 1.32, 1.56, 2.3, 1.32, 1.56, 1.56, 1.81, 1.56, 1.81, 2.3, 1.81, 1.81, 1.56, 1.56, 1.32, 1.32, 0.82, 1.81, 2.3, 1.56, 1.32, 1.56, 2.06, 1.81, 0.82, 1.32, 2.06, 1.56, 0.82, 1.07, 2.06, 1.56, 1.07, 1.32, 1.56, 1.81, 0.82, 1.32, 4.03, 4.03, 1.56, 1.07, 1.07, 1.56, 0.82, 0.08, 0.82, 1.81, 2.06, 1.07, 1.81, 2.06, 1.81, 0.82, 1.56, 2.3, 1.81, 0.82, 1.32, 1.56, 1.56, 1.07, 1.07, 2.06, 1.56, 1.07, 1.56, 1.56, 2.06, 1.32, 1.32, 1.81, 2.06, 1.32, 1.32, 1.07, 1.81, 1.32, 0.58, 1.32, 1.56, 1.56, 1.07, 1.32, 2.3, 1.56, 1.07, 1.81, 2.3, 1.81, 0.82, 1.32, 1.56, 1.32, 0.82, 1.07, 1.81, 1.56, 0.82, 1.32, 1.56, 2.06, 2.06, 1.56, 1.81, 2.3, 1.56, 1.32, 1.32, 1.81, 0.82, 0.58, 1.32, 1.81, 1.32, 0.82, 1.32, 2.3, 1.56, 1.07, 2.06, 2.3, 2.06, 0.82, 1.32, 1.81, 1.32, 0.82, 0.82, 1.32, 1.32, 0.82, 1.81, 2.3, 2.06, 1.81, 1.56, 2.06, 2.3, 1.56, 1.32, 1.56, 1.32, 1.32, 0.33, 1.32, 1.81, 1.56, 1.07, 1.32, 2.06, 2.06, 1.32, 1.07, 1.32, 1.32, 1.07, 1.56, 1.81, 1.81, 1.32, 1.07, 1.07, 1.56, 1.07, 0.82, 1.07, 1.32, 1.32, 0.82, 1.32, 2.06, 1.56, 0.82, 1.56, 1.81, 1.56, 0.58, 1.56, 2.3, 1.56, 0.82, 1.32, 2.06, 1.81, 1.32, 1.56, 1.81, 1.81, 1.32, 1.81, 2.3, 1.81, 1.07, 1.32, 1.07, 1.32, 0.82, 0.82, 1.32, 2.06, 1.81, 1.32, 1.56, 2.3, 1.81, 1.07, 1.56, 2.3, 1.81, 0.82, 1.07, 1.81, 1.56, 0.82, 1.07, 2.06, 1.56, 1.07, 1.56, 1.56, 1.81, 1.32, 1.32, 2.06, 1.81, 1.32, 1.07, 1.07, 1.56, 1.32, 0.58, 1.32, 1.81, 1.81, 1.32, 1.07, 1.56, 1.81, 1.07, 1.32, 1.81, 1.81, 0.33, 0.82, 1.56, 1.56, 1.07, 1.56, 2.3, 2.06, 1.07, 1.56, 2.06, 2.06, 1.81, 1.56, 1.81, 2.06, 1.07, 0.33, 0.82, 1.56, 1.32, 0.82, 1.81, 1.81, 1.81, 1.81, 1.56, 2.06, 2.06, 2.55, 2.3, 2.55, 2.06, 1.32, 2.3, 2.8, 2.06, 1.32, 1.81, 2.3, 3.53, 2.3, 1.81, 2.55, 1.56, 1.81, 1.32, 1.81, 3.04, 1.07, 1.56, 1.81, 1.32, 0.58, 1.32, 1.81, 1.32, 0.82, 1.07, 1.81, 1.56, 0.82, 1.07, 1.56, 1.81, 1.32, 1.56, 2.3, 2.06, 1.07, 0.82, 0.82, 1.56, 1.07, 0.82, 1.32, 2.06, 1.81, 1.32, 1.07, 1.81, 1.56, 0.82, 1.56, 2.3, 1.81, 1.07, 1.32, 1.81, 1.56, 1.07, 1.07, 1.81, 1.32, 0.82, 1.32, 1.56, 1.81, 1.81, 1.32, 1.81, 2.06, 1.07, 1.07, 0.82, 1.56, 1.32, 0.82, 1.32, 1.81, 1.81, 1.07, 1.32, 2.06, 1.81, 1.07, 1.56, 1.81, 1.56, 0.58, 1.32, 2.06, 1.32, 0.82, 0.82, 1.56, 1.56, 0.58, 0.58, 1.56, 1.32, 0.82, 1.32, 2.06, 2.06, 1.56, 1.07, 1.56, 1.81, 1.56, 0.33, 0.82, 1.32, 1.32, 0.58, 1.07, 2.06, 1.81, 1.07, 1.56, 1.81, 1.56, 0.58, 0.82, 1.32, 1.32, 0.82, 1.32, 1.07, 1.56, 0.82, 0.58, 1.56, 2.06, 1.81, 1.56, 1.56, 2.3, 1.81, 0.82, 1.32, 1.81, 1.56, 0.33, 0.58, 1.32, 1.32, 0.82, 1.32, 2.3, 2.06, 1.07, 1.32, 1.81, 1.81, 1.07, 1.32, 1.81, 1.32, 0.82, 1.07, 1.32, 1.56, 1.07, 0.82, 1.32, 2.06, 1.81, 1.32, 1.56, 2.06, 1.56, 0.82, 1.32, 1.56, 1.32, 0.58, 1.07, 2.06, 1.56, 0.82, 1.56, 2.3, 1.81, 1.32, 1.81, 2.3, 2.06, 1.56, 1.56, 2.3, 1.81, 1.07, 1.07, 1.32, 1.56, 1.32, 0.82, 1.56, 2.3, 1.81, 1.32, 1.56, 2.06, 1.56, 0.58, 1.56, 1.81, 1.56, 0.82, 1.32, 2.3, 2.06, 1.32, 1.56, 2.3, 1.81, 1.07, 1.32, 1.81, 1.56, 1.07, 1.07, 1.81, 1.81, 0.82, 0.58, 1.07, 1.32, 1.32, 1.07, 1.56, 2.06, 1.56, 1.32, 1.56, 2.3, 1.81, 0.82, 1.32, 1.56, 1.56, 0.82, 1.07, 2.06, 1.56, 0.82, 1.32, 1.56, 1.81, 1.07, 1.32, 1.81, 2.06, 1.56, 1.32, 1.32, 2.06, 1.32, 0.82, 1.07, 1.32, 1.32, 0.82, 1.56, 2.06, 1.81, 1.07, 1.56, 2.3, 1.81, 0.58, 1.07, 1.81, 1.81, 0.82, 1.07, 1.56, 1.32, 0.82, 1.32, 1.56, 1.81, 1.07, 1.56, 1.81, 2.3, 1.81, 1.81, 1.81, 1.81, 1.32, 1.07, 1.32, 1.32, 1.32, 0.82, 1.32, 2.06, 1.81, 1.07, 1.56, 2.06, 1.81, 0.58, 1.07, 1.56, 1.32, 0.82, 1.32, 2.06, 1.56, 1.07, 1.32, 1.56, 1.56, 1.32, 0.82, 1.81, 2.06, 1.32, 1.56, 1.56, 1.81, 1.07, 0.58, 1.32, 1.81, 1.56, 1.07, 1.32, 2.3, 1.81, 1.07, 1.32, 2.3, 2.06, 1.07, 1.32, 1.81, 1.32, 1.07, 0.82, 1.32, 1.32, 0.82, 0.82, 1.56, 1.81, 1.81, 1.32, 1.81, 2.06, 1.56, 1.32, 1.32, 1.81, 1.81, 1.07, 1.32, 1.81, 1.56, 0.82, 1.32, 2.06, 1.81, 1.07, 1.56, 1.81, 1.81, 0.82, 1.32, 1.81, 1.81, 1.32, 0.82, 0.82, 1.56, 1.07, 0.82, 1.56, 1.56, 1.56, 1.32, 2.3, 2.3, 1.81, 1.07, 1.56, 1.81, 1.56, 0.82, 1.32, 2.06, 1.56, 0.82, 1.32, 2.06, 2.06, 1.07, 1.32, 1.81, 2.06, 1.32, 1.32, 1.56, 1.81, 1.07, 0.82, 0.82, 1.32, 1.07, 1.07, 1.81, 1.56, 1.81, 1.32]}
    data2 = {"uab": [9.32, 10.38, 6.48, 7.19, 7.9, 7.19, 10.38, 8.96, 0.82, 0.46, 4.71, 4.01, 4.71, 0.82, -2.02, -0.6, -0.6, -1.31, 2.23, -0.95, -4.49, -4.49, -3.08, -2.37, -2.72, -4.49, -5.91, -3.08, -2.37, -2.02, -1.66, -3.79, -6.27, -4.49, -5.2, -3.08, -0.24, -3.08, -4.85, -3.08, -1.66, 0.11, 0.82, -4.14, -3.79, 0.11, -0.95, 1.53, 5.42, 1.17, 0.11, 2.94, 4.36, 8.61, 9.67, 6.84, 3.65, 8.61, 8.61, 10.03, 10.03, 8.61, 7.19, 10.73, 11.09, 13.92, 13.92, 7.19, 8.26, 10.03, 9.32, 11.8, 10.73, 6.84, 6.48, 9.32, 10.03, 13.21, 11.44, 4.71, 6.84, 11.09, 10.73, 10.73, 9.67, 4.36, 4.01, 4.71, 3.3, 8.61, 5.42, 0.46, -0.95, 2.59, 3.65, 5.42, 3.3, -4.49, -3.08, -4.14, -4.14, -2.37, -1.31, -3.79, -3.79, -3.08, -0.6, -0.95, -6.62, -5.56, -3.79, -1.66, -1.66, -0.95, -4.14, -4.85, -2.02, -2.72, -2.72, 0.82, -2.37, -5.2, -2.37, -0.95, 0.11, 1.88, -0.24, -0.24, 2.94, 2.94, 7.19, 8.61, 6.84, 4.01, 6.48, 6.48, 7.9, 7.55, 3.65, 5.78, 6.84, 6.84, 11.8, 11.8, 8.26, 8.26, 9.32, 12.51, 16.76, 17.11, 9.67, 11.09, 13.57, 9.32, 10.38, 11.09, 9.32, 7.9, 7.9, 7.55, 10.38, 6.13, 0.46, 2.23, 5.78, 6.48, 6.84, 5.07, 0.11, 2.59, 2.59, 4.36, 7.19, 5.42, -1.31, -3.43, -0.6, -1.31, -0.24, -3.79, -3.79, 1.88, 8.96, 10.03, 11.44, 6.48, 4.36, 4.71, 6.13, 6.13, 5.78, 2.59, 1.17, 4.36, 4.36, 5.07, 5.78, 3.3, -0.95, 1.88, 2.23, 5.78, 6.13, 4.01, 1.17, 2.23, 3.65, 5.42, 5.78, 0.82, 2.23, 4.36, 4.01, 6.13, 6.13, 0.11, -0.24, 3.65, 3.3, 5.42, 4.01, -0.95, 2.23, 6.84, 4.71, 6.84, 8.26, 3.3, 2.59, 5.42, 5.78, 9.67, 5.07, -0.6, 1.53, 3.3, 3.65, 5.07, 5.07, 0.46, 2.59, 3.65, 4.71, 7.9, 5.78, -0.95, 0.46, 5.07, 4.36, 4.36, 1.88, 1.88, 3.65, 5.78, 2.59, 6.48, 3.65, -0.24, 1.53, 4.36, 5.42, 6.13, 1.17, 0.11, 3.3, 4.71, 5.42, 7.19, 4.36, -0.24, 4.36, 5.78, 5.42, 5.42, 1.53, 1.53, 2.23, 3.65, 5.42, 6.13, 2.59, 0.46, 2.94, 2.59, 4.71, 8.26, 1.17, -1.31, 2.23, 2.94, 5.07, 4.36, -0.24, 0.11, 2.59, 1.53, 7.19, 9.32, 5.42, 1.88, 5.42, 4.01, 6.84, 4.36, 0.46, 1.53, 3.65, 2.23, 3.65, 4.36, -0.24, 1.17, 2.59, 5.07, 7.55, 5.07, -1.66, 0.11, 5.07, 5.42, 5.07, 3.3, -0.24, 0.82, 1.53, 2.94, 5.42, 1.17, -5.91, -13.35, -13.7, -9.81, -5.2, -7.33, -7.33, -4.14, -3.08, -5.2, -4.14, -4.85, -9.1, -9.1, -9.1, -9.45, -10.16, -13.35, -13.35, -11.58, -13.35, -21.85, -26.45, -37.08, -37.79, -32.83, -26.81, -23.62, -21.85, -25.39, -23.27, -15.83, -14.77, -11.58, -8.74, -12.29, -11.93, -8.04, -6.97, 0.82, 3.3, -0.24, -0.24, 8.61, 10.03, 14.28, 15.69, 11.44, 17.46, 21.36, 23.13, 26.32, 27.38, 27.03, 30.21, 31.99, 32.69, 35.53, 34.11, 29.86, 30.57, 28.09, 24.19, 26.67, 36.94, 39.07, 41.19, 43.32, 41.9, 42.96, 36.59, 30.57, 29.86, 30.57, 28.8, 26.32, 23.84, 15.69, 13.21, 12.51, 9.32, 5.78, 0.46, -9.1, -9.45, -10.16, -14.06, -14.06, -18.66, -25.04, -26.81, -29.64, -29.29, -29.64, -34.95, -41.33, -41.33, -40.97, -40.62, -40.97, -47.7, -53.02, -62.93, -66.48, -64.7, -58.33, -56.56, -54.79, -50.89, -47.35, -41.68, -39.2, -40.62, -37.08, -27.52, -25.75, -19.02, -16.18, -15.12, -7.33, -2.72, 2.23, 12.51, 16.4, 18.17, 18.88, 25.96, 32.69, 38.01, 41.19, 40.13, 43.67, 50.05, 52.53, 57.49, 61.03, 59.61, 59.26, 61.74, 62.09, 65.28, 58.19, 51.47, 56.42, 67.76, 70.24, 74.49, 72.72, 64.57, 63.15, 62.44, 58.19, 54.3, 48.63, 38.36, 36.94, 34.46, 27.03, 24.9, 17.46, 8.96, 5.42, -0.6, -6.27, -9.81, -21.14, -29.64, -33.54, -37.79, -40.27, -44.52, -53.73, -57.98, -59.39, -64.0, -64.35, -65.06, -68.6, -75.68, -72.5, -73.2, -81.71, -94.1, -100.48, -96.58, -91.62, -83.12, -77.45, -74.62, -74.62, -69.66, -65.77, -60.1, -47.7, -44.16, -42.39, -39.91, -26.45, -17.25, -9.81, -2.02, 1.17, 6.84, 18.17, 27.03, 32.34, 41.55, 41.55, 48.28, 60.32, 63.51, 72.36, 73.07, 73.42, 79.8, 86.17, 90.42, 94.32, 95.74, 92.55, 92.55, 91.49, 86.17, 92.55, 96.09, 99.28, 99.99, 99.99, 95.74, 93.97, 86.88, 75.19, 71.65, 65.99, 61.03, 57.49, 45.09, 36.24, 29.51, 22.78, 17.82, 8.61, -6.27, -13.7, -23.27, -26.81, -33.54, -40.27, -46.64, -64.0, -68.6, -71.79, -77.1, -84.89, -89.5, -94.81, -95.52, -98.71, -98.35, -99.06, -104.37, -107.91, -106.85, -104.02, -98.0, -96.93, -100.48, -99.41, -89.5, -83.83, -78.87, -71.08, -68.25, -65.41, -54.79, -50.18, -38.14, -28.22, -25.75, -17.95, -4.14, 0.46, 14.28, 23.13, 23.49, 34.11, 41.9, 50.05, 61.38, 65.99, 70.59, 79.09, 85.11, 91.49, 101.05, 101.76, 101.76, 104.59, 110.26, 110.61, 113.09, 114.15, 109.55, 108.84, 109.9, 107.78, 106.36, 102.47, 96.09, 92.9, 88.3, 83.7, 77.67, 67.4, 60.32, 52.17, 48.63, 39.42, 30.21, 23.84, 9.32, 4.01, 0.11, -14.06, -27.87, -38.85, -58.68, -64.35, -68.95, -70.73, -71.79, -82.77, -95.87, -98.0, -101.89, -104.02, -109.33, -115.35, -116.77, -118.54, -121.73, -122.08, -119.6, -122.79, -121.37, -115.71, -113.23, -105.43, -100.12, -100.83, -95.87, -82.41, -79.23, -69.66, -61.52, -58.33, -45.93, -36.72, -25.04, -13.7, -9.1, -10.87, -4.49, 5.07, 24.55, 35.88, 52.88, 63.86, 71.3, 85.82, 95.38, 102.82, 112.03, 114.51, 118.05, 128.68, 130.45, 138.95, 141.78, 138.24, 141.43, 144.61, 142.49, 141.78, 138.24, 133.63, 130.45, 129.38, 126.2, 120.88, 114.51, 99.99, 93.26, 88.65, 76.61, 72.01, 59.61, 44.38, 38.01, 25.61, 11.44, 2.23, -21.5, -40.27, -43.45, -48.41, -52.66, -64.0, -80.64, -88.08, -97.64, -108.62, -110.39, -117.48, -132.0, -135.54, -139.79, -141.92, -144.39, -147.94, -150.06, -152.89, -150.42, -150.42, -145.81, -142.27, -141.92, -137.66, -133.06, -123.85, -110.75, -105.08, -99.77, -89.85, -81.35, -69.31, -60.45, -45.22, -35.31, -28.22, -11.93, -4.14, 2.94, 17.46, 32.34, 44.38, 66.69, 75.19, 92.9, 104.95, 107.78, 120.53, 133.63, 137.18, 149.93, 154.88, 156.3, 162.32, 166.93, 172.24, 175.78, 175.07, 169.76, 170.82, 171.53, 165.51, 165.16, 157.72, 147.09, 143.55, 135.4, 126.55, 120.88, 104.95, 86.88, 81.22, 69.53, 61.74, 46.86, 30.57, 19.94, -4.49, -30.35, -36.02, -44.52, -50.54, -71.08, -83.83, -88.43, -101.18, -115.35, -124.56, -139.44, -148.64, -154.31, -158.56, -163.52, -176.27, -181.58, -180.87, -181.23, -180.52, -181.58, -187.96, -184.42, -176.27, -168.12, -161.75, -152.54, -146.87, -145.81, -128.46, -116.77, -106.5, -92.33, -89.14, -72.5, -52.66, -43.81, -29.29, -18.31, -12.99, -2.37, 20.3, 33.05, 59.97, 72.36, 87.59, 107.07, 117.34, 132.57, 147.45, 151.7, 163.03, 177.2, 180.39, 189.95, 196.68, 203.05, 199.86, 201.28, 205.89, 208.01, 207.66, 200.22, 191.36, 186.76, 184.28, 178.26, 170.11, 157.01, 146.03, 133.28, 120.18, 113.09, 99.63, 89.01, 66.69, 52.17, 43.67, 20.3, -5.91, -21.5, -44.87, -58.68, -65.77, -76.39, -84.18, -109.33, -133.06, -136.25, -148.64, -159.98, -167.77, -182.65, -190.08, -196.81, -204.6, -205.67, -207.44, -214.52, -217.0, -213.46, -210.98, -208.15, -202.48, -201.06, -194.33, -180.87, -175.21, -160.33, -145.1, -140.85, -127.39, -106.85, -97.29, -75.68, -66.83, -52.66, -31.06, -18.31, 2.23, 24.55, 35.53, 52.88, 62.09, 83.34, 102.47, 114.86, 133.63, 144.61, 153.11, 170.11, 183.57, 189.59, 197.74, 199.51, 209.78, 217.93, 219.7, 223.59, 221.82, 217.57, 216.16, 214.74, 212.97, 207.3, 200.22, 185.7, 178.61, 176.14, 160.55, 145.68, 136.47, 115.22, 107.07, 91.13, 72.36, 63.51, 39.78, 16.05, 6.84, -12.99, -33.89, -48.77, -81.35, -95.16, -108.62, -123.14, -129.52, -140.14, -162.81, -173.44, -183.71, -195.04, -200.35, -211.69, -215.94, -223.73, -225.15, -226.21, -227.27, -226.92, -230.46, -227.98, -224.08, -212.75, -200.0, -195.4, -188.31, -170.96, -161.39, -147.94, -126.33, -115.71, -102.6, -93.39, -72.5, -49.12, -36.37, -17.6, -10.16, -0.24, 26.32, 56.07, 72.36, 98.22, 106.72, 127.97, 150.28, 159.13, 180.39, 195.97, 198.8, 212.97, 221.12, 233.87, 243.07, 246.62, 247.68, 252.99, 255.47, 252.28, 250.16, 246.97, 238.12, 234.22, 227.49, 217.93, 212.97, 194.91, 173.3, 166.22, 150.28, 141.07, 122.65, 97.86, 84.76, 62.8, 42.26, 30.21, -0.24, -37.08, -49.12, -65.41, -73.91, -94.81, -116.06, -128.81, -152.54, -169.89, -179.1, -194.33, -209.56, -220.54, -235.42, -238.25, -246.75, -252.42, -254.9, -260.56, -261.63, -260.21, -257.73, -252.77, -243.21, -240.73, -235.77, -223.38, -207.79, -200.71, -181.58, -166.35, -153.96, -133.77, -122.08, -98.35, -76.04, -68.25, -45.93, -23.97, -17.95, 2.94, 32.34, 47.21, 81.57, 96.8, 118.4, 144.26, 157.72, 178.61, 199.16, 209.43, 229.26, 238.47, 251.57, 259.01, 264.32, 275.66, 282.74, 285.58, 284.51, 279.55, 279.2, 276.72, 272.12, 267.16, 254.05, 245.2, 231.74, 217.93, 207.66, 194.55, 172.59, 154.18, 131.51, 121.59, 94.67, 69.53, 55.01, 21.36, -10.52, -27.16, -51.95, -60.81, -85.96, -112.16, -122.08, -145.81, -170.6, -181.58, -204.6, -224.08, -232.23, -249.94, -253.83, -263.4, -280.4, -285.0, -286.77, -289.61, -289.25, -289.25, -289.25, -284.65, -275.79, -271.54, -258.79, -244.63, -240.38, -225.85, -203.9, -192.56, -167.42, -155.02, -140.14, -113.23, -95.52, -68.25, -39.56, -26.1, -9.45, 14.28, 32.34, 66.69, 85.11, 115.22, 142.84, 158.07, 186.05, 209.78, 221.82, 241.66, 253.7, 263.26, 279.91, 285.93, 300.1, 307.18, 306.83, 313.2, 316.39, 316.74, 315.33, 311.78, 296.2, 290.18, 284.87, 271.41, 255.12, 245.2, 221.12, 201.99, 192.43, 169.76, 158.43, 127.26, 95.03, 82.28, 55.72, 28.44, 13.57, -17.95, -51.25, -65.41, -92.68, -105.79, -129.52, -163.17, -178.04, -197.87, -219.48, -229.4, -247.81, -256.67, -272.25, -282.17, -287.48, -293.86, -297.4, -299.88, -304.13, -305.19, -303.77, -295.63, -292.79, -286.42, -272.96, -264.46, -249.58, -228.69, -217.71, -199.29, -175.21, -162.1, -131.64, -116.77, -90.91, -65.77, -50.54, -15.47, 10.38, 25.61, 52.88, 64.57, 92.9, 124.07, 137.88, 168.34, 190.3, 197.39, 220.05, 243.43, 252.99, 275.66, 282.03, 287.7, 301.51, 307.18, 313.91, 319.22, 317.45, 313.2, 313.91, 309.66, 305.06, 300.1, 282.74, 265.74, 258.66, 242.37, 224.3, 215.09, 189.95, 174.01, 151.7, 125.84, 113.8, 84.4, 47.21, 29.51, 2.94, -25.04, -39.56, -68.95, -84.54, -110.04, -134.83, -151.83, -172.37, -195.4, -211.33, -234.71, -247.81, -255.61, -269.77, -278.27, -292.09, -298.46, -298.11, -305.54, -304.48, -303.42, -305.19, -305.54, -295.63, -278.63, -269.42, -257.38, -251.0, -241.44, -215.94, -192.21, -180.52, -157.5, -145.46, -117.48, -89.14, -76.04, -47.0, -20.08, -8.39, 23.49, 57.13, 71.3, 102.47, 116.63, 138.95, 165.86, 179.68, 211.2, 235.64, 243.78, 252.64, 263.26, 278.49, 293.37, 300.45, 306.83, 308.95, 311.08, 316.74, 318.16, 314.62, 305.76, 299.39, 290.89, 280.97, 276.01, 260.78, 236.34, 224.3, 207.3, 182.86, 169.76, 147.09, 132.93, 102.11, 73.07, 58.55, 32.69, 4.71, -16.54, -49.83, -63.29, -89.85, -116.77, -132.0, -160.69, -181.23, -186.9, -209.56, -231.52, -241.79, -264.11, -272.25, -281.46, -290.67, -293.86, -301.29, -309.09, -308.73, -305.9, -301.65, -296.69, -288.54, -286.77, -275.09, -259.86, -252.77, -232.58, -214.17, -204.96, -179.81, -165.29, -141.21, -111.46, -98.71, -74.27, -42.75, -26.45, 1.88, 33.4, 48.99, 73.07, 85.82, 117.34, 145.32, 158.78, 182.16, 203.05, 216.51, 238.47, 257.6, 266.1, 276.01, 279.55, 294.08, 309.31, 312.49, 316.03, 306.83, 308.95, 305.76, 306.47, 297.62, 293.72, 286.64, 268.57, 254.05, 246.97, 230.32, 206.95, 191.01, 161.61, 150.99, 126.2, 98.57, 85.82, 55.01, 23.84, 8.96, -21.14, -47.0, -61.16, -87.37, -101.18, -126.33, -161.39, -171.67, -195.04, -219.83, -230.46, -246.4, -256.31, -269.06, -281.81, -291.02, -300.94, -303.07, -305.19, -305.54, -305.54, -306.96, -299.17, -294.21, -285.0, -269.42, -262.33, -252.42, -231.17, -218.77, -196.46, -172.73, -162.1, -140.14, -125.27, -94.81, -64.35, -47.0, -15.83, 5.78, 19.94, 51.82, 65.99, 101.05, 124.78, 133.28, 163.38, 189.95, 201.28, 222.89, 240.24, 249.1, 267.87, 276.01, 288.76, 302.58, 305.41, 307.53, 316.39, 319.58, 320.28, 314.62, 309.31, 296.91, 293.01, 281.68, 271.05, 264.32, 244.85, 220.76, 210.14, 187.11, 175.78, 153.11, 120.88, 105.3, 78.38, 48.99, 36.59, 7.55, -27.52, -41.33, -68.6, -82.41, -108.98, -137.31, -153.25, -180.17, -200.35, -211.69, -229.75, -247.46, -258.44, -275.09, -281.11, -292.79, -296.69, -298.81, -307.67, -308.38, -305.9, -304.84, -299.88, -291.38, -283.94, -276.15, -263.04, -246.4, -234.0, -212.75, -196.81, -185.83, -155.37, -142.62, -113.94, -90.56, -78.87, -43.45, -12.64, 2.94, 32.34, 59.97, 73.07, 99.99, 117.7, 148.16, 174.36, 183.93, 201.28, 227.49, 239.89, 257.6, 267.16, 282.03, 290.53, 294.78, 307.18, 317.81, 322.06, 314.97, 310.01, 311.08, 306.12, 301.51, 292.66, 276.01, 267.87, 257.24, 239.89, 230.68], "ucb": [-2.52, -1.81, -1.46, -1.11, -2.52, -2.17, -1.11, -0.76, -2.17, -0.76, 0.65, 0.65, -0.05, 1.01, 1.71, 2.07, 2.07, 2.42, 3.48, 3.48, 3.12, 4.18, 4.89, 6.3, 6.3, 6.3, 8.06, 9.12, 8.77, 8.77, 9.47, 10.88, 10.53, 9.83, 10.88, 11.94, 11.59, 11.24, 11.94, 13.0, 11.94, 11.59, 11.59, 13.0, 12.65, 11.59, 11.24, 11.59, 11.94, 11.59, 11.59, 11.94, 10.88, 9.12, 8.77, 9.12, 9.12, 8.41, 6.3, 7.0, 7.36, 5.95, 4.89, 4.89, 4.53, 3.48, 2.77, 2.42, 2.42, 2.07, 1.01, 1.36, 1.71, 0.3, -0.05, -0.4, -0.76, -1.11, -2.17, -2.87, -1.81, -1.81, -2.17, -2.87, -2.17, -1.46, -0.76, -1.46, -1.46, 0.3, 0.3, -0.05, 0.3, 1.01, 0.65, 0.65, 2.07, 3.48, 3.12, 2.77, 3.12, 3.48, 4.89, 5.24, 5.24, 6.65, 7.71, 8.41, 8.41, 8.77, 10.18, 9.83, 9.83, 10.53, 10.88, 11.59, 10.88, 11.24, 12.29, 11.94, 11.59, 12.65, 13.35, 12.65, 11.59, 11.94, 12.65, 12.29, 12.29, 11.59, 11.94, 11.59, 10.53, 9.83, 9.47, 9.12, 8.77, 7.36, 7.71, 8.06, 6.65, 5.24, 5.59, 5.95, 4.89, 3.83, 3.83, 3.83, 2.42, 1.01, 1.36, 1.71, 0.3, -0.4, -0.76, -0.4, -1.11, -1.81, -2.17, -1.81, -1.81, -1.81, -2.17, -1.81, -1.81, -2.17, -2.87, -0.76, 0.3, -0.76, -1.46, -0.4, 0.65, 0.65, 0.3, 1.01, 2.42, 2.42, 2.07, 3.12, 5.24, 10.53, 12.29, 11.59, 9.47, 7.36, 6.65, 6.3, 6.3, 5.95, 5.24, 4.53, 5.24, 5.95, 5.59, 4.53, 5.24, 6.3, 5.59, 5.24, 5.95, 6.3, 6.3, 4.89, 5.95, 6.3, 5.95, 5.24, 4.89, 5.95, 6.3, 5.24, 4.89, 5.24, 5.59, 5.95, 5.59, 6.3, 6.65, 5.95, 5.59, 5.24, 5.95, 5.24, 4.89, 5.59, 6.65, 5.95, 4.89, 5.24, 5.59, 5.24, 4.89, 5.59, 6.3, 5.59, 5.24, 4.89, 5.95, 5.95, 6.3, 5.59, 5.59, 5.59, 5.24, 4.53, 5.24, 5.59, 5.59, 4.18, 4.89, 5.59, 5.59, 4.18, 4.89, 5.95, 5.59, 4.89, 5.59, 5.95, 5.59, 5.24, 5.95, 6.65, 5.95, 5.59, 4.89, 5.24, 6.65, 5.59, 4.89, 5.59, 5.95, 5.59, 4.89, 5.24, 6.3, 5.24, 4.53, 5.59, 6.3, 5.95, 4.18, 4.89, 5.24, 5.24, 4.53, 4.53, 5.59, 5.59, 4.89, 5.24, 5.59, 6.3, 4.89, 4.89, 5.59, 6.65, 5.95, 5.59, 5.59, 5.95, 5.24, 4.53, 5.24, 6.3, 5.59, 4.18, 4.89, 5.95, 5.59, 5.59, 5.59, 6.3, 5.95, 4.89, 4.89, 6.3, 6.3, 5.59, 4.89, 5.95, 6.3, 5.59, 4.89, 5.24, 5.59, 5.24, 0.3, -9.93, -14.51, -15.92, -12.04, -8.87, -4.28, -3.58, -2.52, -0.76, 0.3, 1.36, 2.07, 3.83, 5.59, 6.3, 6.65, 8.06, 9.12, 10.53, 8.77, 5.95, 1.71, 7.36, 13.0, 22.52, 28.87, 30.28, 32.05, 32.05, 33.81, 35.22, 35.22, 34.87, 35.93, 36.28, 35.93, 35.22, 34.52, 34.52, 33.81, 31.69, 31.34, 30.99, 28.52, 25.7, 24.64, 22.88, 21.82, 18.29, 15.12, 13.71, 11.24, 7.71, 5.24, 3.12, 0.3, -1.11, -4.99, -5.69, -8.87, -21.21, -28.97, -34.97, -32.85, -32.85, -33.56, -33.56, -34.97, -37.44, -38.85, -40.26, -40.26, -40.97, -42.38, -42.02, -41.32, -40.61, -39.91, -38.85, -36.38, -35.32, -33.56, -30.74, -29.33, -25.45, -22.98, -21.92, -17.69, -15.22, -10.98, -7.46, -4.99, 0.65, 4.53, 6.65, 10.53, 13.35, 17.94, 21.47, 23.93, 21.82, 20.05, 23.58, 35.93, 47.57, 51.09, 56.03, 57.8, 61.32, 63.79, 64.85, 65.55, 66.97, 67.67, 66.97, 65.55, 66.26, 65.55, 64.14, 61.32, 59.21, 58.15, 53.92, 49.33, 47.92, 44.39, 41.22, 35.22, 29.93, 27.46, 21.82, 15.47, 12.29, 7.0, 1.36, -1.81, -8.16, -10.98, -15.92, -24.39, -31.79, -46.96, -52.96, -54.37, -55.78, -57.54, -58.95, -63.19, -66.01, -68.83, -69.54, -70.59, -72.71, -72.71, -72.0, -71.65, -70.95, -69.18, -66.36, -65.3, -62.48, -58.95, -56.84, -51.9, -46.61, -43.79, -37.09, -33.56, -27.56, -21.57, -17.69, -9.22, -1.81, 0.65, 8.77, 17.23, 20.76, 27.46, 31.69, 36.98, 35.57, 35.57, 44.04, 60.62, 66.61, 75.78, 78.96, 85.31, 89.54, 91.66, 93.77, 96.95, 97.65, 98.36, 98.36, 98.71, 98.0, 95.89, 92.71, 89.89, 88.48, 83.19, 75.78, 73.31, 67.67, 60.97, 57.09, 49.68, 45.8, 38.04, 28.17, 23.93, 16.53, 7.71, 2.07, -6.75, -10.98, -19.1, -28.27, -33.56, -48.73, -66.36, -72.36, -77.65, -79.41, -80.82, -86.47, -89.99, -93.87, -96.69, -99.16, -102.34, -103.04, -103.04, -103.04, -102.69, -101.63, -98.81, -96.69, -93.87, -88.94, -85.76, -79.41, -73.42, -69.89, -61.42, -56.49, -48.02, -39.2, -33.91, -23.33, -13.81, -8.87, 1.71, 13.35, 18.29, 27.46, 33.1, 43.69, 52.5, 56.38, 65.55, 74.37, 78.25, 85.31, 92.71, 96.59, 101.18, 103.3, 107.18, 111.06, 112.82, 113.88, 114.94, 114.23, 113.88, 112.82, 110.0, 107.18, 105.41, 99.77, 93.77, 90.95, 84.95, 77.9, 72.96, 64.85, 60.97, 51.09, 40.51, 36.63, 27.46, 16.17, 10.88, -0.05, -9.93, -15.22, -26.5, -31.79, -40.61, -49.78, -54.02, -63.19, -70.24, -73.42, -80.47, -84.0, -88.58, -92.46, -94.93, -99.87, -101.63, -102.34, -103.75, -104.45, -103.75, -101.28, -99.87, -97.4, -93.17, -89.99, -84.35, -79.06, -76.59, -77.3, -78.71, -75.18, -61.42, -53.66, -38.85, -27.21, -21.92, -9.22, 3.48, 9.12, 20.05, 26.4, 39.45, 50.04, 54.62, 65.55, 76.49, 81.43, 89.89, 99.42, 104.0, 109.64, 112.47, 118.11, 124.11, 125.16, 126.93, 128.69, 129.4, 129.75, 127.99, 126.22, 123.75, 123.05, 117.05, 104.35, 99.42, 96.59, 96.24, 94.48, 89.19, 84.95, 73.67, 60.62, 54.97, 43.69, 30.64, 23.23, 9.83, -3.58, -10.98, -25.09, -31.09, -42.73, -55.07, -61.42, -73.42, -83.29, -87.88, -98.11, -106.92, -110.8, -117.15, -120.33, -126.68, -130.2, -130.2, -133.38, -135.49, -134.79, -133.02, -132.32, -129.85, -125.26, -122.8, -125.97, -130.91, -127.73, -114.33, -100.22, -93.52, -79.76, -73.42, -59.66, -46.61, -39.55, -24.74, -9.57, -2.52, 12.29, 28.17, 35.93, 49.68, 56.38, 70.49, 84.6, 90.25, 101.53, 113.17, 119.52, 129.04, 133.28, 140.68, 148.44, 150.56, 154.44, 157.61, 159.38, 160.79, 159.38, 159.02, 157.61, 156.56, 151.62, 143.51, 136.45, 124.46, 119.87, 118.46, 115.64, 112.11, 100.47, 86.01, 79.31, 64.85, 48.62, 39.81, 23.93, 8.77, -0.05, -16.98, -24.74, -40.26, -55.78, -63.89, -78.71, -91.76, -98.46, -110.8, -122.8, -128.44, -137.61, -142.55, -150.66, -156.3, -158.42, -162.65, -165.47, -165.83, -164.42, -164.06, -163.01, -158.07, -154.89, -150.66, -153.48, -154.54, -148.9, -134.44, -126.68, -110.1, -101.99, -86.11, -71.3, -62.83, -45.55, -27.92, -19.1, -0.76, 19.0, 27.46, 45.1, 53.21, 69.79, 88.13, 95.89, 109.64, 123.75, 130.45, 143.86, 149.5, 159.73, 168.9, 172.78, 180.54, 186.54, 189.71, 192.18, 191.83, 190.77, 191.83, 191.83, 186.18, 180.89, 176.31, 161.49, 146.68, 143.15, 141.04, 134.69, 129.04, 113.88, 106.12, 90.25, 71.9, 61.67, 44.04, 26.05, 15.82, -4.64, -13.81, -32.5, -51.55, -61.07, -79.41, -95.99, -104.81, -121.39, -135.85, -142.2, -154.19, -160.18, -171.12, -178.53, -182.05, -188.75, -193.69, -195.1, -195.81, -195.81, -195.46, -191.93, -188.4, -183.46, -179.94, -179.58, -180.29, -171.47, -163.71, -145.02, -135.14, -117.15, -99.16, -89.64, -69.18, -49.08, -39.55, -19.1, 3.12, 14.06, 33.81, 42.98, 63.09, 83.9, 93.77, 111.76, 129.75, 138.57, 154.09, 168.2, 175.25, 188.65, 193.94, 202.41, 210.52, 214.75, 219.69, 222.16, 223.22, 223.22, 222.51, 218.63, 213.34, 210.52, 203.11, 192.53, 186.89, 174.9, 161.49, 154.44, 138.21, 129.75, 112.82, 93.77, 83.54, 63.79, 43.69, 33.1, 11.94, -8.52, -18.39, -39.2, -50.14, -70.24, -88.94, -98.81, -117.15, -133.38, -140.78, -155.6, -162.3, -175.0, -184.87, -189.46, -198.63, -204.98, -207.1, -209.21, -211.68, -212.39, -210.27, -208.15, -203.92, -198.63, -193.69, -183.11, -172.88, -167.59, -160.89, -155.6, -149.6, -129.85, -117.86, -94.23, -71.65, -60.72, -39.2, -16.63, -5.69, 16.53, 26.76, 49.68, 71.9, 82.49, 101.88, 122.69, 133.63, 150.91, 167.49, 175.96, 191.12, 196.77, 207.7, 218.99, 224.28, 230.27, 233.8, 235.92, 238.39, 237.68, 236.27, 232.74, 230.27, 223.92, 212.64, 203.47, 188.3, 180.54, 177.01, 167.49, 160.44, 143.86, 123.75, 112.82, 91.66, 69.08, 57.09, 32.05, 9.47, -2.52, -27.56, -40.26, -62.48, -84.0, -95.28, -117.51, -137.26, -145.72, -164.06, -181.7, -188.75, -202.51, -208.86, -220.5, -229.67, -232.84, -237.43, -242.37, -244.13, -243.43, -241.31, -238.13, -233.55, -229.67, -221.56, -220.15, -220.85, -210.27, -189.11, -178.53, -158.07, -146.43, -123.5, -101.63, -89.99, -66.01, -40.61, -28.27, -3.93, 22.17, 35.22, 60.26, 72.61, 96.59, 120.58, 132.22, 153.38, 173.13, 183.01, 202.06, 209.82, 223.92, 237.68, 244.38, 253.2, 259.55, 262.72, 268.01, 269.43, 268.37, 267.31, 265.55, 260.25, 251.44, 245.79, 229.92, 212.99, 208.05, 200.29, 188.3, 177.72, 157.26, 144.92, 121.99, 96.95, 84.6, 57.09, 31.34, 19.0, -8.16, -22.62, -48.73, -73.77, -86.11, -112.21, -135.85, -146.43, -168.65, -189.81, -198.98, -215.91, -223.67, -238.84, -250.83, -255.77, -263.88, -270.94, -271.64, -273.05, -274.82, -273.41, -269.88, -264.24, -254.36, -248.36, -247.66, -245.54, -230.73, -219.79, -196.87, -184.17, -159.13, -135.14, -122.8, -96.69, -69.18, -55.78, -28.27, 0.65, 15.47, 44.04, 58.15, 85.66, 113.17, 125.87, 150.56, 174.9, 186.54, 208.41, 227.1, 235.56, 253.2, 261.67, 274.01, 284.24, 289.18, 296.58, 299.41, 300.11, 300.82, 300.11, 295.88, 287.77, 283.89, 271.89, 252.49, 242.62, 230.27, 220.4, 212.99, 192.89, 181.25, 157.61, 130.81, 116.7, 87.42, 59.56, 45.45, 15.47, -15.22, -30.38, -58.6, -73.77, -102.69, -129.5, -142.2, -169.0, -193.69, -204.63, -224.38, -234.25, -252.95, -268.12, -274.82, -286.1, -295.27, -298.45, -302.68, -305.15, -304.8, -302.68, -299.86, -292.45, -284.34, -279.05, -264.94, -249.07, -240.6, -221.91, -199.34, -187.34, -162.65, -151.37, -124.56, -95.64, -81.18, -49.78, -20.51, -8.52, 22.17, 36.98, 65.91, 95.18, 109.64, 135.75, 162.55, 176.31, 200.29, 221.46, 232.04, 252.85, 263.43, 278.6, 288.12, 294.47, 303.64, 311.05, 314.22, 317.04, 317.04, 314.93, 308.58, 305.75, 297.64, 285.65, 278.95, 262.72, 244.03, 234.51, 212.64, 202.41, 179.48, 153.38, 139.63, 112.11, 84.6, 70.49, 39.81, 9.47, -4.99, -30.38, -45.9, -76.24, -107.98, -121.03, -147.84, -173.94, -185.23, -205.68, -227.55, -237.78, -254.71, -262.47, -276.23, -288.22, -292.81, -299.15, -304.09, -305.15, -304.09, -302.33, -297.74, -292.81, -288.22, -276.23, -261.77, -254.71, -238.49, -217.68, -206.39, -184.17, -172.18, -146.78, -119.27, -105.16, -78.71, -48.73, -32.85, -2.17, 26.76, 44.04, 74.02, 88.13, 113.88, 140.68, 153.73, 180.19, 204.17, 214.75, 236.98, 246.5, 263.43, 278.95, 284.94, 298.35, 306.81, 309.28, 314.57, 317.39, 316.34, 312.81, 311.05, 305.4, 296.23, 289.88, 276.13, 260.61, 251.08, 230.63, 210.17, 198.88, 175.6, 162.55, 135.75, 109.29, 94.83, 65.2, 33.81, 19.0, -10.28, -25.45, -55.78, -81.18, -95.28, -122.44, -152.78, -165.47, -188.05, -210.98, -222.26, -241.31, -249.77, -265.65, -279.75, -285.05, -293.86, -300.57, -303.03, -305.86, -305.5, -303.39, -298.8, -295.63, -285.75, -274.46, -267.76, -252.6, -232.84, -222.61, -202.51, -191.58, -166.89, -140.43, -128.09, -100.93, -72.0, -57.54, -28.62, 1.01, 17.23, 48.27, 60.97, 89.54, 118.46, 133.28, 160.44, 183.36, 196.06, 219.69, 230.98, 249.67, 266.96, 274.72, 289.18, 298.7, 301.88, 309.99, 315.98, 316.69, 315.28, 315.28, 312.46, 304.34, 299.05, 287.41, 273.31, 265.55, 247.91, 228.51, 218.28, 195.0, 181.95, 156.56, 130.45, 117.05, 88.13, 58.85, 43.69, 14.41, -0.4, -31.79, -60.01, -74.12, -102.69, -130.2, -142.55, -168.3, -192.63, -204.98, -226.14, -234.96, -252.6, -268.82, -274.82, -286.1, -295.63, -299.51, -304.09, -305.15, -305.5, -303.39, -300.92, -293.51, -283.99, -278.34, -264.94, -248.36, -239.19, -220.15, -210.27, -187.34, -162.65, -150.31, -124.56, -93.87, -79.41, -50.84, -24.04, -9.22, 22.88, 36.98, 65.55, 95.54, 110.0, 137.51, 163.26, 176.66, 201.7, 223.22, 233.45, 253.2, 261.31, 277.89, 290.24, 295.17, 305.4, 312.46, 314.57, 315.98, 317.39, 316.34, 309.99, 305.75, 297.64, 286.36, 279.65, 262.72, 244.38, 235.21, 213.34, 202.06, 177.72, 152.68, 138.92, 111.06, 83.19, 68.02, 39.1, 8.77, -6.4, -36.38, -50.49, -80.12, -108.33, -121.03, -147.49, -173.94, -186.64, -208.86, -218.38, -238.13, -257.18, -264.24, -277.29, -288.57, -293.86, -300.21, -303.74, -304.45, -304.8, -303.03, -298.8, -292.1, -287.51, -275.87, -261.41, -253.65, -236.72, -216.97, -206.74, -183.11, -171.12, -147.13, -119.62, -104.81, -76.59, -48.37, -33.21, -1.81, 12.65, 41.22, 70.85, 86.72, 114.94, 141.39, 155.5, 180.89, 204.17, 214.75, 236.27, 245.44, 264.49, 280.01, 286.0, 300.46, 309.63, 313.51, 314.93, 316.69, 317.04, 313.87, 311.05, 303.99, 295.17, 288.12, 274.36, 258.14, 249.32, 230.98, 220.04, 198.53, 175.6, 162.9, 134.69, 106.82, 93.07, 62.73, 32.75, 18.29, -11.34, -25.09, -55.07, -84.7, -98.46, -125.97, -153.13, -166.53, -190.16, -212.39, -223.32, -243.43, -251.18, -266.35, -280.11, -285.75, -293.51], "ia": [3.88, 3.14, 2.65, 3.63, 3.88, 3.88, 3.14, 3.63, 4.13, 4.13, 3.63, 3.88, 4.62, 4.13, 3.14, 3.39, 3.63, 3.63, 2.9, 2.9, 3.39, 3.88, 3.39, 3.39, 3.63, 3.88, 3.14, 3.63, 3.88, 4.13, 4.13, 3.39, 3.14, 4.37, 3.63, 2.9, 3.14, 3.63, 3.63, 2.9, 3.39, 3.88, 3.39, 2.9, 3.63, 4.86, 4.37, 3.63, 3.63, 3.88, 3.88, 3.39, 3.39, 4.13, 4.13, 3.14, 2.9, 3.39, 3.88, 3.14, 2.65, 2.9, 3.63, 3.63, 2.9, 3.39, 4.62, 4.13, 3.39, 3.39, 4.37, 4.13, 3.39, 3.39, 3.88, 3.88, 3.14, 2.9, 3.88, 3.63, 3.39, 3.39, 4.13, 4.13, 3.88, 3.39, 4.37, 5.11, 4.13, 3.63, 3.14, 4.13, 3.88, 3.14, 3.39, 3.88, 3.88, 3.39, 3.63, 4.62, 4.13, 3.39, 3.39, 3.63, 4.13, 3.39, 3.39, 4.13, 4.13, 3.88, 3.63, 3.39, 3.88, 3.39, 2.9, 3.39, 3.63, 3.63, 2.65, 3.14, 3.63, 4.13, 3.39, 3.63, 4.37, 3.88, 3.14, 3.39, 4.13, 3.88, 3.14, 3.14, 3.88, 3.88, 3.14, 3.14, 3.39, 3.88, 3.39, 3.14, 3.88, 4.62, 4.37, 3.63, 3.88, 4.37, 3.88, 3.14, 3.39, 4.13, 3.88, 3.14, 2.9, 3.39, 3.88, 3.39, 3.14, 4.13, 4.13, 3.39, 3.63, 4.13, 4.13, 4.13, 3.63, 4.13, 4.13, 3.14, 3.14, 3.39, 3.63, 3.39, 2.65, 2.9, 3.39, 3.88, 3.39, 3.63, 4.37, 3.63, 3.14, 3.39, 3.88, 3.88, 3.39, 3.63, 3.88, 3.63, 3.14, 3.14, 3.88, 3.63, 3.14, 2.65, 3.14, 3.63, 3.63, 3.14, 4.37, 5.11, 4.13, 3.39, 3.14, 3.88, 3.63, 3.14, 3.39, 4.13, 3.63, 2.65, 3.14, 3.88, 3.88, 3.14, 2.9, 3.39, 4.13, 3.63, 3.63, 4.13, 4.37, 4.13, 3.63, 3.39, 3.63, 3.14, 2.65, 2.9, 3.63, 3.88, 2.9, 3.14, 3.88, 3.88, 3.39, 3.63, 4.37, 3.88, 3.14, 3.63, 4.13, 4.13, 3.63, 3.14, 3.63, 3.39, 3.14, 2.9, 2.9, 3.63, 2.9, 2.4, 3.63, 4.13, 4.13, 3.63, 3.88, 4.37, 3.88, 3.14, 3.63, 4.37, 3.88, 2.9, 3.39, 3.63, 3.39, 2.9, 3.14, 3.63, 3.88, 3.39, 3.39, 4.13, 4.37, 4.37, 3.88, 3.88, 4.13, 3.63, 3.14, 3.39, 3.88, 3.63, 2.65, 3.39, 3.88, 3.88, 2.9, 3.14, 4.13, 4.13, 3.39, 3.63, 4.13, 4.62, 3.63, 3.63, 3.63, 3.39, 3.39, 3.39, 3.39, 3.88, 3.39, 2.9, 3.14, 3.63, 4.13, 3.39, 3.88, 4.37, 4.13, 3.39, 3.63, 4.62, 4.37, 3.39, 3.14, 3.63, 3.39, 3.39, 3.14, 3.88, 3.88, 3.14, 3.14, 3.39, 3.88, 3.39, 3.63, 4.13, 4.62, 4.37, 3.88, 3.88, 4.13, 3.14, 2.4, 3.39, 3.88, 3.63, 2.65, 3.14, 4.13, 3.88, 3.39, 3.88, 4.86, 4.13, 3.39, 3.63, 4.13, 4.37, 4.13, 3.39, 3.63, 3.88, 3.63, 3.39, 3.39, 3.63, 3.63, 2.4, 3.39, 4.13, 3.63, 2.65, 2.65, 3.88, 4.37, 3.88, 3.88, 3.88, 3.63, 2.9, 3.39, 3.88, 3.39, 2.65, 3.14, 3.39, 3.88, 3.39, 3.39, 3.39, 3.63, 3.88, 3.63, 3.88, 4.37, 3.88, 3.14, 3.39, 4.13, 3.88, 3.14, 3.39, 4.13, 3.88, 2.65, 2.9, 3.63, 3.63, 3.39, 3.63, 4.13, 4.37, 3.14, 3.39, 3.88, 4.13, 3.63, 3.39, 3.63, 4.13, 3.39, 2.9, 3.39, 3.88, 3.88, 2.9, 2.9, 3.88, 3.88, 3.14, 3.63, 4.62, 4.13, 3.39, 3.63, 3.88, 3.63, 3.63, 3.14, 3.88, 3.63, 2.65, 2.4, 3.14, 3.63, 4.13, 3.39, 3.88, 4.37, 4.13, 3.63, 3.63, 4.37, 3.88, 3.14, 3.39, 3.88, 3.88, 2.65, 3.14, 3.88, 3.63, 3.14, 3.14, 4.13, 4.13, 3.39, 3.63, 4.13, 4.37, 4.37, 3.88, 4.13, 4.37, 3.39, 2.9, 3.39, 3.88, 3.63, 2.65, 3.39, 3.88, 3.63, 3.14, 3.39, 4.37, 4.13, 3.63, 3.63, 3.88, 4.13, 3.39, 3.39, 3.88, 3.88, 3.39, 3.39, 3.39, 3.88, 3.39, 2.65, 3.14, 3.88, 4.13, 3.39, 3.63, 4.62, 4.62, 3.88, 3.88, 4.13, 3.88, 3.14, 3.39, 3.88, 3.39, 2.9, 3.39, 3.88, 3.88, 3.39, 3.14, 3.63, 3.88, 3.14, 3.39, 3.88, 4.37, 4.13, 3.39, 3.63, 4.13, 3.14, 2.65, 3.14, 3.88, 3.63, 2.65, 2.9, 3.63, 4.13, 3.39, 3.88, 4.37, 3.88, 3.14, 3.63, 4.13, 4.13, 3.63, 3.14, 3.88, 3.88, 3.14, 3.14, 3.39, 3.63, 3.39, 3.63, 3.88, 4.37, 3.88, 3.39, 3.14, 4.37, 3.88, 3.63, 3.88, 3.63, 3.39, 2.65, 3.14, 3.88, 3.63, 3.39, 2.9, 3.39, 3.88, 3.39, 2.9, 3.39, 4.13, 4.13, 3.39, 3.88, 4.13, 3.63, 3.14, 3.14, 3.63, 3.63, 2.65, 3.14, 3.63, 3.63, 3.39, 3.63, 4.62, 4.62, 3.39, 3.39, 4.13, 4.13, 3.39, 3.63, 4.13, 4.13, 3.14, 2.9, 3.14, 3.39, 3.14, 2.9, 3.39, 3.63, 3.88, 3.14, 3.63, 4.62, 4.37, 3.63, 3.63, 4.37, 4.13, 3.39, 3.39, 4.13, 3.63, 3.14, 3.14, 3.88, 3.88, 3.39, 2.9, 3.39, 4.13, 4.37, 3.88, 4.13, 4.37, 3.63, 3.39, 3.14, 3.88, 3.63, 2.9, 3.39, 3.88, 3.39, 2.4, 2.4, 3.39, 3.88, 3.39, 3.39, 3.63, 4.13, 3.39, 3.39, 3.88, 3.63, 3.63, 3.39, 3.88, 3.63, 3.14, 2.65, 3.14, 3.63, 3.63, 2.9, 3.63, 3.88, 3.88, 3.14, 3.39, 4.13, 3.88, 3.39, 3.63, 4.13, 3.88, 3.14, 3.39, 3.63, 3.39, 2.9, 2.9, 3.14, 3.88, 3.39, 3.39, 4.13, 4.13, 4.13, 3.63, 3.88, 4.37, 3.88, 3.39, 3.88, 4.37, 3.88, 2.65, 3.14, 3.63, 3.63, 3.14, 3.14, 4.13, 4.13, 3.39, 3.14, 3.63, 4.13, 4.13, 3.63, 4.13, 4.62, 3.63, 3.14, 3.14, 3.63, 3.14, 2.65, 3.39, 3.88, 3.88, 2.9, 3.39, 4.13, 4.13, 3.39, 3.63, 4.13, 4.13, 3.39, 3.63, 4.13, 3.63, 3.39, 3.39, 3.88, 3.63, 2.9, 3.14, 3.39, 3.63, 3.63, 2.9, 3.63, 4.13, 3.88, 3.63, 3.39, 4.13, 3.63, 3.14, 3.14, 3.63, 3.39, 2.65, 3.14, 3.88, 3.88, 3.39, 3.39, 3.39, 3.63, 3.14, 3.14, 3.88, 3.63, 3.39, 3.39, 3.39, 3.88, 3.39, 2.9, 3.39, 3.88, 3.88, 2.65, 3.39, 3.88, 3.88, 3.39, 3.63, 4.62, 3.88, 3.14, 3.63, 4.13, 3.88, 3.63, 3.39, 3.39, 3.39, 3.14, 3.39, 3.39, 3.88, 3.39, 2.9, 3.39, 3.88, 4.13, 3.88, 3.63, 4.62, 4.13, 3.39, 3.39, 3.63, 3.14, 2.4, 3.14, 4.13, 3.88, 3.39, 2.9, 3.88, 3.88, 3.39, 3.39, 4.37, 4.62, 4.37, 3.39, 4.62, 5.36, 5.11, 5.11, 3.88, 3.63, 2.9, 2.65, 3.39, 4.37, 4.86, 3.88, 4.13, 4.13, 3.88, 3.39, 3.88, 4.37, 4.37, 2.9, 3.14, 4.37, 4.13, 4.13, 3.88, 3.88, 4.62, 3.63, 3.63, 3.63, 3.63, 4.13, 3.39, 3.63, 4.13, 4.13, 3.39, 3.39, 4.62, 4.37, 3.39, 3.39, 3.88, 3.88, 2.9, 3.39, 3.88, 3.63, 3.14, 3.39, 3.63, 3.63, 3.39, 3.63, 3.88, 4.37, 4.62, 4.13, 3.39, 3.88, 3.39, 2.9, 2.9, 3.63, 3.88, 3.14, 3.39, 4.37, 3.63, 3.14, 4.13, 5.11, 4.62, 3.88, 3.88, 4.37, 4.13, 3.63, 3.39, 3.63, 3.39, 3.14, 3.14, 3.39, 3.63, 3.88, 2.65, 3.14, 3.88, 4.13, 3.39, 3.39, 4.37, 4.13, 3.63, 3.14, 3.63, 3.88, 3.14, 3.39, 3.88, 3.63, 3.39, 2.9, 3.63, 3.63, 3.39, 3.39, 3.63, 3.88, 3.88, 3.14, 3.63, 3.88, 3.63, 3.14, 3.39, 3.88, 3.63, 2.65, 3.39, 3.88, 3.63, 2.65, 2.9, 3.63, 3.63, 3.39, 3.63, 3.88, 4.13, 3.39, 3.63, 3.63, 3.63, 3.63, 3.14, 3.39, 3.88, 3.14, 2.65, 3.14, 3.63, 3.63, 3.14, 3.39, 4.62, 4.13, 3.14, 3.39, 4.37, 4.13, 2.9, 3.39, 3.88, 3.63, 3.39, 3.39, 3.88, 3.88, 3.14, 3.14, 3.39, 3.88, 3.39, 3.39, 3.63, 4.13, 3.88, 3.63, 3.63, 4.62, 3.88, 3.39, 3.14, 3.63, 3.39, 2.9, 3.14, 3.63, 3.88, 3.39, 2.9, 3.88, 3.88, 3.39, 3.63, 3.88, 3.88, 3.88, 3.63, 4.37, 4.13, 3.14, 3.39, 3.39, 3.88, 3.88, 2.9, 3.39, 4.13, 3.88, 3.14, 3.63, 4.62, 4.37, 3.63, 3.63, 3.88, 3.88, 3.14, 3.14, 3.88, 3.88, 3.39, 3.39, 3.39, 3.88, 3.14, 2.65, 3.63, 4.13, 3.88, 3.39, 4.37, 4.86, 4.13, 3.39, 3.14, 3.63, 3.14, 2.65, 3.39, 3.88, 3.63, 3.14, 2.9, 3.63, 3.63, 3.39, 3.63, 3.88, 3.88, 3.14, 3.39, 3.88, 4.37, 3.88, 3.39, 3.39, 3.88, 2.9, 2.4, 3.39, 3.88, 3.88, 2.65, 2.9, 4.62, 4.62, 3.88, 3.39, 4.62, 4.13, 2.9, 3.39, 3.63, 3.63, 3.63, 3.39, 3.63, 4.13, 3.39, 3.14, 3.39, 4.13, 3.88, 3.39, 3.88, 4.37, 4.13, 3.39, 3.39, 4.37, 3.88, 3.14, 3.39, 3.88, 3.88, 2.9, 3.39, 3.88, 3.63, 3.14, 3.63, 4.13, 5.36, 4.37, 4.37, 3.63, 4.62, 5.85, 4.62, 3.88, 3.88, 3.14, 2.65, 3.63, 4.13, 3.88, 2.65, 2.9, 3.39, 3.39, 2.9, 3.39, 4.62, 4.37, 3.39, 3.63, 3.63, 3.63, 3.14, 3.39, 3.88, 3.88, 3.14, 3.14, 3.39, 3.88, 3.39, 2.9, 3.39, 3.88, 3.88, 3.14, 3.39, 4.62, 4.13, 3.39, 3.14, 4.13, 3.88, 3.39, 3.39, 3.88, 3.63, 2.9, 2.65, 3.39, 3.39, 3.39, 2.9, 3.14, 4.13, 4.13, 3.39, 4.13, 4.37, 3.63, 3.39, 3.39, 3.88, 3.63, 2.9, 3.63, 4.13, 3.63, 2.9, 3.14, 4.13, 3.88, 3.14, 3.63, 4.62, 4.37, 3.39, 3.39, 4.13, 3.63, 3.39, 3.39, 3.63, 3.63, 3.14, 2.65, 3.39, 3.88, 3.39, 2.65, 3.39, 3.88, 3.88, 3.63, 3.39, 3.39, 3.14, 2.65, 3.14, 3.63, 3.88, 3.14, 3.39, 3.88, 3.88, 2.9, 3.63, 3.88, 4.37, 4.62, 4.62, 4.86, 4.13, 4.37, 3.88, 3.63, 4.37, 3.88, 3.39, 3.39, 3.88, 3.63, 2.65, 2.9, 3.39, 3.63, 3.14, 3.14, 4.13, 4.13, 3.39, 3.63, 4.13, 3.88, 3.88, 3.39, 3.88, 3.88, 3.14, 2.65, 2.65, 3.14, 2.9, 2.65, 3.63, 4.13, 3.88, 4.86, 5.36, 6.09, 3.63, 3.14, 3.63, 3.88, 3.14, 2.9, 2.9, 3.63, 4.86, 4.62, 4.62, 4.13, 3.88, 2.9, 2.65, 3.39, 3.63, 3.63, 2.9, 3.63, 4.13, 4.13, 3.39, 3.14, 3.88, 3.63, 3.39, 5.36, 5.85, 3.14, 2.65, 3.14, 4.37, 3.63, 2.9, 3.39, 3.63, 3.63, 3.14, 3.39, 4.37, 3.88, 3.63, 3.88, 3.88, 4.37, 4.13, 3.39, 3.39, 3.88, 3.63, 2.65, 3.39, 3.88, 4.13, 3.39, 3.39, 3.88, 3.88, 3.39, 3.63, 4.62, 4.37, 4.62, 4.86, 5.11, 3.39, 3.14, 3.14, 3.39, 4.13, 2.65, 2.65, 3.63, 4.62, 4.13, 3.63, 3.63, 4.62, 4.13, 3.39, 3.39, 3.88, 3.63, 2.9, 3.14, 3.88, 4.13, 3.63, 3.39, 3.88, 3.88, 3.14, 3.63, 4.13, 4.62, 4.13, 3.39, 4.37, 4.86, 3.88, 3.14, 3.39, 3.88, 3.63, 2.65, 3.39, 3.88, 4.13, 2.9, 3.39, 4.13, 3.88, 3.14, 3.39, 4.13, 3.39, 2.65, 3.39, 4.13, 4.37, 4.13, 3.88, 3.88, 3.88, 3.14, 2.4, 2.9, 3.63, 3.63, 3.39, 3.63, 4.13, 4.13, 3.63, 3.39, 4.37, 4.13, 3.14, 3.14, 3.63, 3.39, 3.39, 3.88, 4.86, 4.13, 3.39, 3.39, 4.62, 4.62, 4.13, 4.13, 4.62, 4.37, 4.62, 3.63, 3.88, 4.62, 4.37, 3.14, 2.9, 3.39, 3.39, 2.65, 3.39, 3.88, 3.63, 3.14, 3.14, 4.37, 4.13, 3.39, 3.39, 4.13, 4.37, 4.13, 3.39, 3.63, 3.63, 3.63, 3.14, 2.65, 3.14, 3.14, 2.65, 3.88, 4.86, 4.86, 3.39, 3.63, 4.62, 4.13, 3.39, 3.63, 4.13, 4.37, 3.63, 3.39, 3.88, 3.63, 3.14, 3.14, 4.13, 4.13, 3.39, 3.14, 3.88, 4.13, 3.88, 3.88, 4.37, 4.37, 3.63, 3.39, 3.14, 3.63, 3.63, 2.65, 3.39, 3.88, 3.39, 2.65, 2.9, 3.63, 3.63, 3.39, 3.14, 3.63, 4.37, 3.39, 3.39, 3.88, 3.39, 3.14, 3.14, 3.39, 3.88, 3.14, 2.65, 3.63, 3.88, 3.88, 2.65, 3.39, 3.88, 3.88, 3.14, 3.63, 4.62, 4.13, 3.14, 3.14, 3.63, 3.39, 3.39, 3.14, 3.88, 3.63, 2.9, 3.63, 3.88, 3.88, 3.39, 3.63, 3.88, 4.62, 4.13, 3.63, 3.88, 4.37, 3.14, 2.65, 3.39, 3.88, 3.63, 2.65, 2.9, 3.88, 3.88, 3.14, 3.63, 4.37, 4.13, 3.39, 2.65, 3.39, 4.37, 4.37, 3.63, 4.62, 4.62, 4.13, 3.39, 3.39, 3.63, 3.39, 2.4, 3.88, 4.62, 5.11, 4.37, 4.37, 4.13, 4.13, 3.39, 3.14, 3.88, 2.9, 2.16, 3.39, 4.37, 3.88, 3.63, 2.9, 2.9, 3.39, 3.63, 3.14, 3.14, 4.13, 4.13, 3.39, 3.88, 3.88, 3.63], "ic": [1.56, 1.07, 1.56, 2.06, 1.81, 1.07, 1.56, 2.06, 1.81, 1.07, 1.56, 1.56, 1.56, 1.07, 1.07, 1.32, 1.56, 0.82, 0.82, 1.56, 1.81, 2.06, 1.56, 1.81, 2.3, 1.81, 1.07, 1.56, 1.81, 1.56, 0.33, 0.82, 1.32, 1.32, 0.82, 1.07, 2.06, 1.56, 0.82, 1.32, 1.56, 1.81, 1.07, 1.56, 1.81, 2.06, 1.56, 1.81, 1.56, 1.81, 1.07, 0.82, 1.32, 2.06, 1.56, 0.58, 1.07, 2.06, 1.56, 0.82, 1.56, 2.55, 2.06, 1.07, 1.32, 2.3, 1.56, 1.32, 1.81, 2.06, 1.81, 0.82, 1.32, 1.56, 1.81, 1.81, 1.07, 1.81, 2.3, 1.81, 1.56, 1.56, 2.3, 1.81, 1.07, 1.56, 2.3, 1.56, 0.82, 1.07, 2.06, 1.56, 0.82, 1.07, 1.32, 1.56, 1.07, 1.32, 2.06, 2.06, 1.81, 1.32, 1.81, 2.3, 1.32, 0.58, 1.07, 1.56, 1.32, 0.58, 1.32, 1.56, 1.56, 0.82, 1.32, 2.06, 1.81, 1.07, 1.56, 1.81, 1.81, 0.82, 1.32, 1.56, 1.56, 1.07, 1.07, 1.07, 1.56, 1.07, 0.82, 1.32, 1.81, 1.81, 1.32, 1.56, 2.3, 2.06, 1.32, 1.81, 2.06, 1.56, 0.33, 0.82, 1.56, 1.56, 1.07, 1.32, 2.06, 1.56, 0.82, 1.32, 1.56, 2.06, 1.81, 1.32, 1.81, 2.3, 1.56, 1.32, 1.32, 2.06, 1.32, 0.58, 0.58, 1.32, 1.32, 0.82, 1.32, 2.06, 1.32, 1.07, 1.81, 2.06, 1.81, 1.07, 1.32, 2.06, 2.06, 1.81, 1.32, 1.56, 1.32, 0.82, 0.82, 1.32, 1.32, 1.56, 1.32, 2.06, 1.81, 1.81, 1.81, 1.81, 2.3, 1.81, 1.07, 1.56, 1.81, 1.81, 0.82, 1.32, 2.06, 1.81, 0.82, 1.07, 1.07, 1.32, 0.82, 1.07, 1.81, 1.81, 1.56, 1.56, 1.81, 2.06, 1.32, 0.58, 1.07, 1.81, 1.32, 0.08, 1.07, 1.81, 1.81, 1.07, 1.07, 2.06, 2.06, 1.07, 1.32, 1.81, 2.3, 1.81, 1.56, 2.3, 2.06, 1.32, 0.82, 0.58, 1.32, 1.07, 0.82, 1.32, 2.06, 1.81, 0.82, 1.32, 2.06, 1.81, 1.07, 1.56, 1.81, 1.56, 1.07, 1.81, 2.3, 1.81, 1.32, 1.07, 1.56, 1.56, 1.07, 1.07, 1.81, 1.81, 1.81, 1.32, 1.81, 2.3, 2.06, 1.81, 1.81, 1.81, 1.56, 0.33, 0.82, 1.56, 1.56, 0.82, 1.07, 2.06, 1.56, 0.82, 1.07, 1.32, 1.81, 1.07, 1.32, 2.06, 1.81, 1.32, 1.56, 1.56, 2.06, 1.32, 0.58, 0.82, 1.56, 1.32, 0.82, 1.32, 2.06, 1.81, 1.07, 1.56, 2.3, 2.06, 1.07, 1.32, 2.06, 2.06, 0.58, 1.07, 1.56, 1.56, 1.07, 1.07, 1.32, 1.32, 0.82, 0.82, 1.56, 2.3, 1.81, 1.81, 2.06, 2.3, 1.56, 1.32, 1.81, 2.06, 1.81, 0.58, 0.82, 1.56, 1.56, 0.82, 1.07, 2.06, 1.81, 1.07, 1.07, 1.56, 1.81, 1.81, 1.81, 2.3, 2.3, 1.32, 1.32, 1.07, 1.81, 1.56, 0.58, 1.07, 1.56, 1.32, 0.82, 0.82, 1.32, 1.32, 0.82, 1.56, 1.81, 2.06, 1.07, 1.56, 2.3, 1.56, 1.07, 1.07, 1.56, 1.56, 0.82, 0.58, 1.32, 1.81, 1.56, 0.82, 1.56, 1.81, 1.56, 1.07, 1.56, 2.06, 1.56, 0.82, 1.56, 1.81, 1.56, 0.82, 1.32, 1.81, 1.56, 1.07, 1.32, 1.56, 1.81, 1.07, 1.32, 1.81, 2.06, 1.32, 1.07, 1.07, 1.81, 1.07, 0.33, 1.07, 1.81, 1.56, 0.33, 0.82, 1.56, 1.81, 1.07, 1.56, 2.3, 2.06, 1.32, 1.81, 2.3, 1.81, 1.32, 0.82, 1.56, 1.56, 1.07, 1.32, 1.07, 1.32, 1.32, 0.58, 1.32, 2.06, 1.81, 1.32, 1.32, 2.06, 1.56, 1.07, 1.81, 2.3, 1.81, 0.82, 1.07, 1.56, 1.56, 1.07, 1.07, 1.81, 1.56, 0.82, 0.82, 1.32, 1.81, 1.56, 1.32, 1.81, 2.06, 1.56, 0.82, 1.32, 1.81, 1.81, 0.58, 0.82, 1.56, 1.56, 0.82, 1.32, 2.06, 1.81, 1.07, 1.32, 1.56, 1.81, 1.07, 1.56, 2.06, 1.81, 1.56, 1.32, 1.32, 1.56, 0.82, 0.58, 1.07, 1.32, 1.32, 0.82, 1.32, 2.06, 1.81, 1.07, 1.56, 2.3, 1.56, 0.58, 1.07, 1.56, 1.32, 0.82, 0.82, 1.81, 1.81, 1.07, 1.32, 1.32, 1.81, 1.07, 1.07, 1.81, 2.3, 1.81, 1.32, 1.56, 2.06, 1.32, 0.82, 1.07, 1.81, 2.06, 1.32, 1.07, 1.81, 1.56, 0.82, 1.32, 2.06, 1.81, 1.07, 1.56, 1.81, 2.06, 1.81, 2.06, 2.3, 2.06, 1.56, 1.56, 1.56, 1.81, 1.56, 0.58, 1.56, 2.06, 1.81, 1.07, 1.32, 2.3, 2.06, 1.56, 2.06, 1.81, 1.81, 1.07, 1.56, 2.06, 1.56, 1.07, 1.32, 1.07, 1.32, 0.82, 0.82, 1.56, 1.81, 1.81, 1.32, 1.81, 2.06, 1.32, 0.82, 1.32, 1.81, 1.56, 0.33, 1.07, 1.81, 1.81, 1.07, 1.07, 1.81, 1.56, 0.82, 1.07, 1.32, 1.81, 0.82, 1.32, 1.81, 2.06, 1.81, 1.81, 1.81, 2.06, 1.07, 0.82, 1.56, 1.81, 1.81, 1.07, 1.56, 2.3, 1.81, 1.07, 1.07, 1.56, 1.81, 0.82, 1.56, 1.81, 2.06, 1.56, 1.32, 2.06, 1.56, 1.07, 1.07, 1.07, 1.32, 1.32, 0.82, 1.56, 2.3, 1.81, 1.32, 1.56, 2.06, 1.32, 0.82, 1.56, 2.3, 1.32, 0.08, 0.82, 1.56, 1.32, 0.82, 1.07, 1.32, 1.81, 1.07, 1.07, 1.81, 1.81, 1.81, 1.56, 2.06, 2.06, 1.07, 0.58, 1.32, 1.81, 1.56, 0.33, 0.82, 1.56, 1.81, 1.07, 1.32, 2.3, 1.81, 1.07, 1.32, 1.81, 1.56, 0.33, 0.82, 1.56, 1.81, 1.32, 1.07, 1.07, 1.81, 1.07, 0.82, 1.32, 1.56, 1.56, 0.82, 1.07, 2.06, 1.56, 0.82, 1.56, 2.06, 1.56, 0.82, 1.07, 1.56, 1.32, 0.82, 1.07, 1.81, 1.32, 1.07, 1.56, 1.81, 1.81, 1.81, 1.81, 2.3, 2.55, 2.06, 1.81, 1.56, 1.81, 1.07, 0.33, 0.82, 1.32, 1.32, 0.58, 1.07, 2.06, 1.81, 1.07, 1.07, 2.06, 1.81, 1.07, 1.32, 1.81, 2.06, 1.81, 1.81, 2.06, 1.56, 0.82, 0.33, 0.82, 1.56, 1.56, 0.82, 1.56, 2.06, 1.81, 1.56, 1.56, 2.3, 1.81, 0.58, 1.07, 1.81, 1.56, 0.58, 1.07, 1.56, 1.56, 1.07, 1.32, 1.32, 1.56, 0.58, 1.07, 1.81, 1.81, 1.81, 1.56, 1.56, 2.06, 1.07, 0.33, 0.82, 1.56, 1.56, 0.58, 1.32, 2.06, 1.56, 1.07, 1.56, 2.06, 1.32, 0.82, 1.56, 2.06, 1.81, 1.07, 1.32, 1.81, 1.81, 1.07, 1.56, 1.56, 2.06, 1.07, 0.82, 1.32, 2.06, 1.56, 0.82, 1.32, 2.3, 1.56, 0.82, 1.32, 2.06, 1.81, 0.58, 1.32, 1.81, 1.56, 1.07, 0.82, 1.56, 1.56, 1.07, 1.32, 1.32, 1.81, 2.06, 1.32, 1.81, 2.06, 1.81, 1.56, 1.32, 1.81, 1.32, 0.82, 1.07, 1.32, 1.07, 1.81, 2.3, 3.29, 1.81, 1.32, 1.32, 1.81, 1.81, 1.81, 2.06, 2.3, 2.3, 2.3, 1.56, 2.06, 2.3, 1.56, 1.56, 2.3, 2.3, 2.3, 1.56, 2.3, 2.8, 2.06, 1.32, 1.56, 2.3, 1.81, 0.82, 1.32, 2.06, 2.06, 1.07, 1.56, 2.3, 1.81, 1.07, 0.82, 0.82, 1.56, 0.82, 1.07, 1.81, 1.32, 1.32, 1.07, 1.56, 2.06, 1.32, 0.58, 1.32, 1.56, 1.56, 0.33, 0.82, 1.56, 1.32, 0.82, 0.82, 1.56, 1.32, 0.82, 1.56, 1.81, 2.06, 1.81, 2.06, 3.04, 2.8, 1.56, 1.07, 1.32, 1.56, 0.82, 0.33, 1.07, 1.81, 1.32, 1.32, 1.56, 2.3, 2.06, 1.32, 1.81, 2.06, 1.81, 1.07, 1.56, 2.06, 1.81, 1.32, 0.82, 1.32, 1.32, 0.82, 0.82, 1.56, 1.81, 1.81, 1.56, 2.06, 2.3, 1.81, 1.56, 1.56, 1.81, 1.56, 1.07, 1.56, 1.81, 1.32, 0.08, 0.58, 1.81, 1.81, 1.07, 1.32, 1.56, 2.06, 1.07, 1.32, 1.56, 1.81, 1.81, 1.56, 1.56, 1.81, 1.07, 0.58, 1.07, 1.56, 1.56, 0.82, 1.32, 2.06, 1.56, 0.82, 1.56, 2.3, 1.56, 0.58, 1.32, 1.56, 1.56, 1.56, 1.32, 1.56, 1.56, 0.82, 1.07, 1.32, 1.32, 0.58, 0.82, 1.81, 2.3, 1.56, 1.07, 1.56, 2.55, 2.06, 1.32, 1.56, 1.81, 1.32, 0.33, 0.82, 1.32, 1.07, 0.58, 1.07, 2.06, 1.56, 0.82, 0.82, 1.32, 1.81, 1.81, 1.81, 2.3, 2.3, 1.56, 1.32, 1.32, 1.81, 1.56, 0.33, 0.82, 1.56, 1.56, 1.32, 1.81, 2.3, 2.06, 1.07, 1.56, 1.81, 1.81, 1.32, 1.81, 2.06, 1.56, 1.56, 1.32, 1.32, 1.56, 1.07, 0.82, 1.32, 1.81, 1.81, 0.82, 1.56, 2.06, 1.81, 1.07, 1.56, 2.3, 1.81, 1.32, 1.81, 2.3, 1.81, 1.56, 1.07, 1.32, 1.32, 0.58, 1.07, 1.32, 1.81, 1.07, 0.82, 1.56, 2.06, 1.81, 1.56, 1.56, 2.3, 1.32, 0.82, 1.56, 1.81, 1.81, 0.82, 1.07, 1.56, 1.32, 0.82, 1.07, 1.81, 1.81, 1.56, 2.06, 2.3, 1.56, 1.32, 1.07, 1.56, 1.81, 1.56, 1.81, 1.56, 2.3, 2.55, 2.8, 2.8, 3.04, 2.55, 1.07, 1.32, 2.06, 1.81, 1.32, 2.06, 2.06, 1.81, 0.58, 1.07, 1.56, 1.56, 1.07, 1.32, 1.32, 1.56, 1.07, 0.82, 1.81, 1.56, 1.32, 1.07, 1.81, 2.06, 1.07, 0.33, 1.07, 3.29, 3.04, 1.56, 1.07, 1.56, 1.32, 0.58, 1.07, 2.3, 2.06, 1.32, 1.56, 1.81, 2.06, 1.07, 1.56, 1.81, 2.06, 1.56, 1.56, 1.07, 1.81, 1.07, 0.82, 1.32, 1.56, 1.56, 0.33, 0.82, 1.81, 1.81, 1.07, 1.56, 2.55, 2.06, 1.07, 1.32, 1.81, 1.32, 0.82, 0.82, 1.56, 1.32, 0.58, 1.07, 1.07, 1.32, 1.56, 1.07, 1.81, 2.3, 1.81, 1.32, 1.32, 2.3, 1.56, 0.82, 1.07, 1.81, 1.56, 0.58, 1.32, 2.3, 1.81, 1.07, 1.56, 2.3, 2.06, 1.07, 1.56, 2.06, 1.56, 1.56, 1.56, 2.06, 2.06, 1.32, 1.07, 1.56, 1.81, 1.81, 0.82, 1.56, 2.06, 1.56, 1.07, 1.56, 2.3, 1.56, 0.82, 1.81, 2.3, 1.81, 1.07, 1.81, 2.06, 1.32, 0.82, 0.82, 0.82, 1.32, 0.82, 0.58, 1.32, 1.81, 1.81, 1.32, 1.32, 2.06, 1.56, 0.82, 1.56, 2.55, 2.06, 1.07, 2.55, 3.29, 1.81, 1.07, 1.32, 1.81, 1.56, 1.07, 1.32, 1.81, 1.81, 1.32, 1.56, 2.06, 2.3, 1.81, 1.81, 1.81, 2.55, 2.06, 0.82, 1.07, 1.32, 1.32, 0.82, 1.32, 2.3, 1.81, 1.81, 2.3, 2.06, 1.32, 0.33, 1.07, 1.81, 1.56, 1.32, 1.56, 2.3, 3.04, 1.81, 1.07, 1.32, 1.56, 1.81, 1.32, 1.56, 2.06, 1.56, 1.81, 1.81, 2.3, 1.81, 1.32, 1.81, 2.3, 1.56, 0.82, 1.56, 2.3, 2.06, 1.56, 0.58, 0.08, 0.58, 1.32, 1.56, 1.81, 1.81, 1.81, 1.32, 1.81, 2.06, 2.3, 1.56, 2.06, 1.81, 1.56, 0.33, 1.07, 1.81, 1.81, 1.07, 1.07, 1.81, 1.56, 1.07, 1.81, 2.3, 1.32, 0.58, 1.56, 1.81, 2.06, 1.81, 2.06, 2.06, 1.32, 0.58, 0.58, 1.32, 1.56, 1.56, 0.58, 1.07, 1.56, 1.07, 0.58, 1.32, 2.3, 1.56, 0.58, 1.32, 2.3, 1.56, 1.07, 0.82, 1.32, 1.32, 0.82, 1.32, 1.32, 1.56, 1.56, 0.82, 1.32, 1.81, 1.56, 1.32, 1.32, 1.81, 1.07, 0.33, 1.56, 2.3, 2.3, 0.82, 1.07, 1.81, 1.56, 1.07, 0.82, 1.32, 1.81, 1.32, 1.56, 2.55, 2.8, 2.3, 1.07, 1.81, 1.81, 2.06, 1.32, 1.32, 1.56, 1.32, 0.82, 1.07, 1.81, 1.56, 1.07, 2.06, 2.8, 2.55, 0.82, 1.32, 2.06, 1.81, 1.07, 1.81, 2.55, 3.29, 2.55, 1.81, 1.32, 1.81, 1.32, 0.82, 1.81, 2.3, 2.3, 1.32, 1.56, 3.04, 2.3, 1.32, 1.56, 2.3, 2.06, 1.56, 1.81, 2.55, 1.32, 1.56, 1.56, 2.06, 1.56, 1.07, 1.32, 1.56, 2.06, 2.06, 1.56, 1.81, 2.06, 1.32, 0.82, 0.58, 1.56, 1.32, 0.82, 1.32, 1.81, 1.32, -0.16, 0.33, 0.08, 0.82, 1.07, 2.3, 2.8, 2.3, 0.58, 1.32, 1.81, 1.56, 1.07, 1.07, 1.56, 1.56, 0.82, 0.58, 1.32, 1.56, 1.32, 0.82, 1.81, 2.3, 1.81, 1.32, 1.56, 2.06, 1.56, 0.58, 1.32, 1.81, 1.32, 0.33, 0.58, 1.56, 1.56, 0.82, 1.32, 1.56, 1.81, 1.07, 0.82, 1.32, 2.06, 2.06, 1.56, 1.56, 1.81, 1.07, 0.82, 1.32, 1.81, 3.04, 1.56, 1.07, 1.56, 1.56, 0.82, 1.56, 2.3, 2.06, 1.32, 1.81, 2.06, 1.81, 0.82, 1.32, 2.06, 1.56, 0.82, 1.07, 1.32, 1.56, 1.07, 1.07, 1.81, 2.3, 1.81, 1.07, 1.32, 1.81, 1.32, 0.58, 1.56, 2.06, 1.81, 0.82, 1.07, 1.56, 1.32, 0.82, 1.07, 1.56, 1.32, 1.32, 1.56, 1.56, 1.81, 1.81, 0.58, 0.82, 1.07, 0.33, 1.07, 2.55, 2.8, 2.55, 0.58, 1.07, 1.56, 1.56, 1.56, 2.8, 3.29, 1.81, 1.32, 1.56, 1.32, 1.56, 0.82, 1.56, 2.3, 2.55, 1.56, 0.82, 0.82, 1.56, 2.06, 1.32, 1.07, 1.56, 2.06, 1.81, 2.06, 2.3, 1.81, 0.82, 1.56, 1.81, 1.32, 0.82, 1.07, -0.16, -0.66, 0.58]}
    for _ in range(10):
        r = actionFile(data2, 2)
        print(r)