from dataclasses import dataclass
from pot_libs.sanic_api import Model
from pot_libs.sanic_api.column import Float, Str, List, Int, Dict, Opt
from pot_libs.common.components.fields import Cid


@dataclass
class BasicInfoReq(Model):
    page_size: int = Opt(Int("页面大小").eg(10))
    page_num: int = Opt(Int("当前页面").eg(1))


@dataclass
class BasicInfoResp(Model):
    rows: list = List("基本信息").eg({
        "pid": "监测点id",
        "mtid": "监测点id",
        "equipment_address": "设备地址",
        "equipment_code": "设备编码",
        "root_address": "房屋地址",
        "longitude": "经度",
        "latitude": "纬度",
        "insurer": "王五",
        "insurer_phone": "责任人电话"
    })
    total: int = Int("总量")


@dataclass
class StbDataResp(Model):
    rows: str = Str("基本信息").eg("")
    total: int = Int("cid").eg(78)


@dataclass
class StbDataReq(Model):
    type: str = Str("类型").eg("appliance or electric or soe")
    # cid: int = Int("cid").eg(78)


@dataclass
class SupplementReq(Model):
    cid: int = Int("cid").eg(78)
    start: str = Str("开始时间").eg("2021-12-29 00:00:00")
    end: str = Str("开始时间").eg("2021-12-29 06:00:00")
    type: str = Str("类型").eg("appliance or electric")


@dataclass
class RiskCount(Model):
    security_user: int = Opt(Int("安全用户").eg(10))
    risk_user: int = Opt(Int("风险用户").eg(2))


@dataclass
class ContentName(Model):
    ele_overload: int = Opt(Int("用电超载").eg(10))
    high_power_app: int = Opt(Int("大功率电器").eg(2))
    illegal_ele_app: int = Opt(Int("违规电器").eg(2))
    power_quality: int = Opt(Int("电能质量").eg(2))
    ele_car_battery: int = Opt(Int("电能质量").eg(2))


@dataclass
class HomeDataResp(Model):
    risk_distribution: RiskCount = Opt(RiskCount)
    content_distribution: ContentName = Opt(ContentName)
    electric_use_score: float = Opt(Float("用电安全指数").eg(90.3))

    total_tenant: int = Opt(Int("接入住户").eg(20))
    online_rate: float = Opt(Float("在线率").eg(0.8))
    safe_day: float = Opt(Float("平均安全运行").eg(11.1))
    total_power: float = Opt(Float("累计监测用电").eg(96000))
    total_alarm: int = Opt(Int("累计报警次数").eg(5))


@dataclass
class HomeLstAlarmReq(Model):
    cid: Opt(Cid)
    importance: list = Opt(List("报警等级,默认:[1, 2, 3]").eg([1, 2, 3]))
    page_size: int = Opt(Int("每页记录数").eg(10))
    page_num: int = Opt(Int("当前页码").eg(1))
    start: str = Opt(Str("开始时间").eg("2021-02-01 00:00:00"))
    end: str = Opt(Str("结束时间").eg("2021-02-28 23:59:59"))


@dataclass
class HomeAlarmStatsReq(Model):
    cid: Opt(Cid)
    importance: list = Opt(List("报警等级,默认:[1, 2, 3]").eg([1, 2, 3]))
    page_size: int = Opt(Int("每页记录数").eg(10))
    page_num: int = Opt(Int("当前页码").eg(1))
    start: str = Opt(Str("开始时间").eg("2021-02-01 00:00:00"))
    end: str = Opt(Str("结束时间").eg("2021-02-28 23:59:59"))


@dataclass
class HomeAlarmStatsResp(Model):
    ele_overload: dict = Dict("线路过载").eg(
        {"slots": ["00-01", "00-02", "00-03"], "value": [1, 2, 3]})
    illegal_ele_app: dict = Dict("违规电器").eg(
        {"slots": ["00-01", "00-02", "00-03"], "value": [1, 2, 3]})
    power_quality: dict = Dict("电能质量").eg(
        {"slots": ["00-01", "00-02", "00-03"], "value": [1, 2, 3]})
