from pot_libs.logger import log
from pot_libs.mysql_util.mysql_util import MysqlUtil
from pot_libs.sanic_api import summary

# prd文档: 搜索以客户名称简称为准
from unify_api.constants import Product
from unify_api.modules.common.components.select_company_cps import \
    CompanyRequest, CompanyResponse, SelectCompany, CmReq, CmRes
from unify_api.modules.common.procedures.cids import get_cids, get_proxy_cids
from unify_api.modules.common.service.select_company_service import \
    company_model_service


@summary('选择工厂')
async def post_select_company(req, body: CompanyRequest) -> CompanyResponse:
    product = body.product
    if product in [Product.AndianUManage.value,
                   Product.RecognitionElectric.value,
                   Product.ZhidianUManage.value]:
        user_id = req.ctx.user_id
        proxy_id = body.proxy_id
        # cids = await get_cids(user_id, product)
        cids = await get_proxy_cids(user_id, product, proxy_id)
        log.info(f"post_select_company {user_id}: {cids}")
        async with MysqlUtil() as conn:
            sql = "SELECT cid,shortname,fullname from company where cid in %s"
            sel_company = []
            if cids:
                sel_company = await conn.fetchall(sql=sql, args=(tuple(cids),))
            com_info_list = []
            for com in sel_company:
                sc = SelectCompany(**com)
                com_info_list.append(sc)
            resp = CompanyResponse(select_company=com_info_list)
            return resp

    # 1.获取用户下的cid
    cid_list = body.cid_list
    province = body.province
    input_str = body.input_str
    # 2.根据参数查数据库
    try:
        async with MysqlUtil() as conn:
            if province == "全国":
                sql = f"SELECT cid, shortname, fullname from company where " \
                      f"cid in %s and shortname LIKE '%%{input_str}%%'"
                sel_company = await conn.fetchall(sql=sql,
                                                  args=(tuple(cid_list),))
            else:
                sql = f"SELECT cid, shortname, fullname from company where " \
                      f"cid in %s " \
                      f"and province = %s and shortname LIKE '%%{input_str}%%'"
                sel_company = await conn.fetchall(sql=sql, args=(
                    cid_list, province))
    except:
        log.error(f"{sql}查询失败")
        return CompanyResponse().db_error()
    if not sel_company:
        return CompanyResponse(select_company=[])
    # 3.返回
    com_info = []
    for com in sel_company:
        sc = SelectCompany(**com)
        com_info.append(sc)
    resp = CompanyResponse(select_company=com_info)
    return resp


@summary('工厂模型信息')
async def post_company_model(req, body: CmReq) -> CmRes:
    """智电U首页工厂模型"""
    cid = body.cid
    return await company_model_service(cid)
