import json
import pytest
from unify_api.tests.constants_t import post_request, get_request


# 运维报警搜索 state表示 0待关注 1 已忽略  w_type 0全部 1丢失 2延迟 3异常
class TestWarningSearch:
    url = "/unify-api/zhiwei-u/select/warning-search"

    @pytest.mark.parametrize('data', [{
        "page_size": 20, "page_num": 1, "user_id": 88, "state": 0}, {
        "page_size": 20, "page_num": 1, "prod_id": 3, "user_id": 88,
        "state": 1},
        {"page_size": 20, "page_num": 1, "cid": 44, "user_id": 88, "state": 1},
        {"page_size": 2, "page_num": 1, "w_type": 2, "user_id": 88, "state": 0},
        {"page_size": 20, "page_num": 1, "sid": "A1904000583", "user_id": 88,
         "state": 1}, {
        "page_size": 20, "page_num": 1, "start": "2021-07-10 00:00:00",
        "end": "2021-07-10 23:59:59", "user_id": 88, "state": 0}
    ])
    @pytest.mark.asyncio
    async def test_warning_search(self, data):
        resp_str, status = await post_request(self.url, data)
        assert status == 200
        resp_dict = json.loads(resp_str)
        assert resp_dict["data"]["is_power"] == 2


# 运维工单搜索 详情页传工单id
class TestOrderSearch:
    url = "/unify-api/zhiwei-u/select/order-search"

    @pytest.mark.parametrize('data', [{
        "page_size": 20, "page_num": 1, "user_id": 88, "state": 0}, {
        "page_size": 20, "page_num": 1, "prod_id": 3, "user_id": 88,
        "state": 1},
        {"page_size": 20, "page_num": 1, "cid": 44, "user_id": 88, "state": 1},
        {"page_size": 2, "page_num": 1, "w_type": 2, "user_id": 88, "state": 0},
        {"page_size": 20, "page_num": 1, "sid": "A1904000583", "user_id": 88,
         "create_user_id": 88, "w_origin": 1}, {
        "page_size": 20, "page_num": 1, "start": "2021-07-10 00:00:00",
        "end": "2021-07-10 23:59:59", "user_id": 88, "state": 0}
    ])
    @pytest.mark.asyncio
    async def test_order_search(self, data):
        resp_str, status = await post_request(self.url, data)
        assert status == 200
        resp_dict = json.loads(resp_str)
        assert isinstance(resp_dict["data"]["total"], int)


# 我的待办
class TestMyselfDo:
    url = "/unify-api/zhiwei-u/select/myself-do"

    @pytest.mark.parametrize('data', [{
        "page_size": 20, "page_num": 1, "user_id": 88, "state": 0}, {
        "page_size": 20, "page_num": 1, "prod_id": 3, "user_id": 88,
        "state": 1},
        {"page_size": 20, "page_num": 1, "cid": 44, "user_id": 88, "state": 1},
        {"page_size": 2, "page_num": 1, "w_type": 2, "user_id": 88, "state": 0},
        {"page_size": 20, "page_num": 1, "sid": "A1904000583", "user_id": 88,
         "create_user_id": 88, "w_origin": 1}, {
        "page_size": 20, "page_num": 1, "start": "2021-07-10 00:00:00",
        "end": "2021-07-10 23:59:59", "user_id": 88, "state": 0}
    ])
    @pytest.mark.asyncio
    async def test_order_search(self, data):
        resp_str, status = await post_request(self.url, data)
        assert status == 200
        resp_dict = json.loads(resp_str)
        assert isinstance(resp_dict["data"]["total"], int)
