import json
import pytest
from unify_api.tests.constants_t import TOKEN, HTTP_PREFIX
from pot_libs.aiohttp_util.aiohttp_utils import AioHttpUtils


@pytest.mark.parametrize('data', [
    {
        "location_ids": [765, 766, 767, 768, 769],
        "point_id": 327,
        "enable": 1
    },
])
@pytest.mark.asyncio
async def test_point_alarm_setting(data):
    """
    获取某监测点告警设置列表
    """

    resp_str, status = await AioHttpUtils().post(
        url=f"{HTTP_PREFIX}/unify-api/alarm-manager/alarm-setting"
            f"/point-alarm-setting",
        data=data,
        timeout=10,
        headers={"Authorization": f"Bearer {TOKEN}"}
    )
    assert status == 200
    resp_str = json.loads(resp_str)
    assert resp_str["data"]["point_alarm_settings"]

