import os
import sys


base_path = os.path.abspath('../../')
sys.path.append(base_path)
sys.path.append(f'{base_path}/pot_libs')

from unify_api.modules.users.views.auth import auth_blueprint
from unify_api.modules.wechat_message.views.register import wechat_blueprint
from pot_libs.web_driver import main, Apps
from unify_api.modules.common.procedures.login_auth import auth_verify, \
    auth_verify_cid
from unify_api.modules.users.views.recive_refresh_token import \
    refresh_blueprint


def before_app_start(app):
    app.middleware('request')(auth_verify)
    app.middleware('request')(auth_verify_cid)
    app.blueprint(wechat_blueprint)
    app.blueprint(auth_blueprint)
    app.blueprint(refresh_blueprint)


if __name__ == '__main__':
    main(Apps.web, before_app_start)
