from dataclasses import dataclass
from pot_libs.sanic_api import Model
from pot_libs.sanic_api.column import Int, List, Str, Dict, Float, Opt


@dataclass
class AlarmRecordReq(Model):
    cid: int = Int("工厂id").eg(117)
    importance: list = Opt(List("级别 1， 2， 3").eg([1, 3]))
    pm_type: str = Opt(Str("pm类型  pm2.5 pm10").eg("pm2.5"))
    start: str = Opt(Str("开始时间").eg("2021-11-01 00:00:00"))
    end: str = Opt(Str("结束时间").eg("2021-11-30 23:59:59"))
    page_size: int = Int("每页记录数").eg(20)
    page_num: int = Int("当前页码").eg(1)


@dataclass
class AlarmRecord(Model):
    event_datetime: str = Str('报警时间').eg("2021-07-10 11:01")
    tsp_id: int = Int('tsp_id').eg(1)
    name: str = Str('tsp_name').eg("二号大门")
    importance: int = Int('报警等级').eg(2)
    message: str = Str('报警消息').eg("PM2.5超过115，该指标等级为中度污染")
    pm_type: str = Str('所属类别').eg("PM2.5")


@dataclass
class AlarmRecordResp(Model):
    total: int = Int('总量').eg(1)
    rows: list = List('信息').items(AlarmRecord)
