# -*- coding:utf-8 -*-
"""
DATE：2024/3/7 11:08

"""
from pot_libs.mysql_util.mysql_util import MysqlUtil


async def load_contact_records(page_num, page_size, s_dts, e_dts):
    offsets = 0 if page_num == 0 else (page_num - 1) * page_size
    ts_conds = []
    if s_dts:
        ts_conds.append(f"create_time>='{str(s_dts)}'")
    if e_dts:
        ts_conds.append(f"create_time<'{str(e_dts)}'")

    conds_str = " WHERE " + " AND ".join(ts_conds) if ts_conds else ""
    async with MysqlUtil(db="official_web") as conn:
        sql = f"SELECT count(*) FROM official_web.contact_record {conds_str};"
        total = await conn.fetch_value(sql)

        sql = f"SELECT * FROM official_web.contact_record {conds_str} " \
              f"ORDER BY create_time DESC, id LIMIT %s OFFSET %s;"
        records = await conn.fetchall(sql, (page_size, offsets))
        return total, records
