from pot_libs.mysql_util.mysql_util import MysqlUtil
from unify_api.utils.time_format import get_start_end_by_tz_time_new


async def load_compy_power(cid, start, end):
    start, _ = get_start_end_by_tz_time_new(start)
    _, end = get_start_end_by_tz_time_new(end)
    sql = f"""
        select p,kwh,create_time from company_15min_power
        where cid = %s and create_time BETWEEN %s and %s
        order by create_time asc
    """
    async with MysqlUtil() as conn:
        datas = await conn.fetchall(sql=sql, args=(cid, start, end))
    return datas


async def load_spfv_price(cid, start, end):
    start, _ = get_start_end_by_tz_time_new(start)
    _, end = get_start_end_by_tz_time_new(end)
    sql = f"""
            select avg(charge) charge,avg(kwh) kwh from company_15min_power
            where cid = %s and create_time BETWEEN %s and %s
        """
    async with MysqlUtil() as conn:
        data = await conn.fetchone(sql=sql, args=(cid, start, end))
    return data.get('charge', 0), data.get('kwh', 0)
