# -*- coding:utf-8 -*-
from pot_libs.logger import log
from pot_libs.sanic_api import summary
from pot_libs.mysql_util.mysql_util import MysqlUtil
from unify_api.modules.common.components.common_cps import CidReq
from unify_api.modules.common.procedures.points import point_to_mid
from unify_api.modules.common.service.list_point_service import (
    list_storey_service, list_tsp_point_service, list_point_level_service,
    list_point_inline_service, load_list_point
)
from unify_api.modules.common.components.list_points_cps import (
    ListPointRequest,
    ListPointResponse,
    CommonPoint,
    CommonLocation,
    Inline, LsRep, LtpRep, LplResp, LpiResp
)
from unify_api.modules.users.procedures.jwt_user import jwt_user


@summary('获取监测点,进线列表')
async def post_list_point(req, body: ListPointRequest) -> ListPointResponse:
    cid = body.cid
    if not cid or cid < 0:
        return ListPointResponse().param_error()

    user_id = jwt_user(req)
    return await load_list_point(user_id, cid)


@summary('获取楼层-识电u')
async def post_list_storey(req, body: ListPointRequest) -> LsRep:
    cid = body.cid
    return await list_storey_service(cid)


@summary('获取TSP监测点-扬尘')
async def post_list_tsp_point(req, body: ListPointRequest) -> LtpRep:
    cid = body.cid
    return await list_tsp_point_service(cid)


@summary('新版监测点-包含进线变压器层级')
async def post_list_point_level(req, body: CidReq) -> LplResp:
    cid = body.cid
    return await list_point_level_service(cid)


@summary('新版监测点-进线')
async def post_list_point_inline(req, body: CidReq) -> LpiResp:
    cid = body.cid
    return await list_point_inline_service(cid)
