import functools
from sanic import response
from functools import wraps


def check_request_for_authorization_status(request):
    """auth认证"""
    return True


def authorized():
    def decorator(f):
        @wraps(f)
        async def decorated_function(request, *args, **kwargs):
            # run some method that checks the request
            # for the client's authorization status
            is_authorized = check_request_for_authorization_status(request)

            if is_authorized:
                # the user is authorized.
                # run the handler method and return the response
                res = await f(*args, **kwargs)
                return res
            else:
                # the user is not authorized.
                return response.json({'status': 'not_authorized'}, 403)
        return decorated_function
    return decorator
