import json
import pytest
from unify_api.tests.constants_t import post_request, get_request


#  根据sid pid返回参数
class TestSidToParams(object):
    url = "/unify-api/zhiwei-u/data-operations/sid-to-params"

    @pytest.mark.parametrize('data', [
        {"pid": 21}, {"sid": "A1904000109"}, {"pid": 21, "sid": "A1904000109"}
    ])
    @pytest.mark.asyncio
    async def test_sid_to_params(self, data):
        resp_str, status = await post_request(self.url, data)
        assert status == 200
        resp_dict = json.loads(resp_str)
        assert isinstance(resp_dict["data"]["data"], dict)


#  根据mtid 返回基本信息
class TestMtidToInfo(object):
    url = "/unify-api/zhiwei-u/data-operations/mtid-to-info"

    @pytest.mark.parametrize('data', [
        {"mtid": 18}
    ])
    @pytest.mark.asyncio
    async def test_mtid_to_info(self, data):
        resp_str, status = await post_request(self.url, data)
        assert status == 200
        resp_dict = json.loads(resp_str)
        assert isinstance(resp_dict["data"], dict)

    @pytest.mark.parametrize('data', [
        {"mtid": 0}, {"mtid": 10000}
    ])
    @pytest.mark.asyncio
    async def test_mtid_to_info_error(self, data):
        resp_str, status = await post_request(self.url, data)
        assert status == 200
        resp_dict = json.loads(resp_str)
        assert resp_dict["data"]["success"] == 0
