import json
import pytest
from unify_api.tests.constants_t import TOKEN, HTTP_PREFIX
from pot_libs.aiohttp_util.aiohttp_utils import AioHttpUtils


@pytest.mark.parametrize('data', [
    {
          "cid": 44,
          "start": "2020-09-01 00:00:00",
          "end": "2020-09-30 23:59:59",
          "inline_id": 42
    }
])
@pytest.mark.asyncio
async def test_load_forecast(data):
    """
    负荷预测
    """
    resp_str, status = await AioHttpUtils().post(
        url=f"{HTTP_PREFIX}/unify-api/load-analysis/load-forecast"
            f"/load-forecast",
        data=data,
        timeout=10,
        headers={"Authorization": f"Bearer {TOKEN}"}
    )
    assert status == 200
    resp_str = json.loads(resp_str)
    print(resp_str)
    assert all([resp_str["data"]["pred_data"], resp_str["data"]["real_data"],
                resp_str["data"]["deviation_list"],
                resp_str["data"]["deviation_power_list"]])
