import json
import pytest
from unify_api.tests.constants_t import TOKEN, HTTP_PREFIX
from pot_libs.aiohttp_util.aiohttp_utils import AioHttpUtils


@pytest.mark.parametrize('data', [
    {
        "cid": 44,
        "point_id": -1,
        "date_type": "day",
        "start": "2020-07-30 00:00:00",
        "end": "2020-07-30 23:59:59"
    },
])
@pytest.mark.asyncio
async def test_power_charge_stati(data):
    """
    电量电费统计曲线
    """
    resp_str, status = await AioHttpUtils().post(
        url=f"{HTTP_PREFIX}/unify-api/elec-charge/elec-statistics"
            f"/power-charge-stati",
        data=data,
        timeout=10,
        headers={"Authorization": f"Bearer {TOKEN}"}
    )
    assert status == 200
    resp_str = json.loads(resp_str)
    assert all([resp_str["data"]["kwh"], resp_str["data"]["yesterday_p"],
                resp_str["data"]["charge"], resp_str["data"]["today_p"]])


@pytest.mark.parametrize('data', [
    {
        "cid": 44,
        "point_id": -1,
        "date_type": "day",
        "start": "2020-07-30 00:00:00",
        "end": "2020-07-30 23:59:59"
    },
])
@pytest.mark.asyncio
async def test_max_p(data):
    """
    小程序最高负荷/web最大需量
    """
    resp_str, status = await AioHttpUtils().post(
        url=f"{HTTP_PREFIX}/unify-api/elec-charge/elec-statistics"
            f"/max-p",
        data=data,
        timeout=10,
        headers={"Authorization": f"Bearer {TOKEN}"}
    )
    assert status == 200
    resp_str = json.loads(resp_str)
    assert all([resp_str["data"]["maxp"], resp_str["data"]["date_time"]])


@pytest.mark.parametrize('data', [
    {
        "cid": 44,
        "point_id": -1,
        "date_type": "day",
        "start": "2020-07-30 00:00:00",
        "end": "2020-07-30 23:59:59"
    },
])
@pytest.mark.asyncio
async def test_power_charge_min_max(data):
    """
    电量电费/最多最少最高负荷
    """
    resp_str, status = await AioHttpUtils().post(
        url=f"{HTTP_PREFIX}/unify-api/elec-charge/elec-statistics"
            f"/power-charge-min-max",
        data=data,
        timeout=10,
        headers={"Authorization": f"Bearer {TOKEN}"}
    )
    assert status == 200
    resp_str = json.loads(resp_str)
    assert all([resp_str["data"]["max_p"], resp_str["data"]["max_kwh"],
                resp_str["data"]["min_kwh"], resp_str["data"]["max_charge"],
                resp_str["data"]["min_charge"]])
