import json
import pytest
from unify_api.tests.constants_t import TOKEN, HTTP_PREFIX
from pot_libs.aiohttp_util.aiohttp_utils import AioHttpUtils


@pytest.mark.parametrize('data', [
    {
        "filter": {
            "equals": [
                {"field": "point_id", "value": -1},
                {"field": "cid", "value": 43}
            ],
            "ranges": [
                {
                    "field": "quarter_time",
                    "start": "2020-07-30 00:00:00",
                    "end": "2020-07-30 23:59:59"
                }
            ]
        }
    },
])
@pytest.mark.asyncio
async def test_power_overview(data):
    """电量电费信息"""
    resp_str, status = await AioHttpUtils().post(
        url=f"{HTTP_PREFIX}/unify-api/elec-charge/elec-charge"
            f"/power-overview",
        data=data,
        timeout=10,
        headers={"Authorization": f"Bearer {TOKEN}"}
    )
    assert status == 200
    resp_str = json.loads(resp_str)
    assert type(resp_str["data"]["power"]["s"]) in (int, float)


@pytest.mark.parametrize('data', [
    {
        "cid": 118
    },
])
@pytest.mark.asyncio
async def test_price_policy(data):
    """分时电价"""
    resp_str, status = await AioHttpUtils().post(
        url=f"{HTTP_PREFIX}/unify-api/elec-charge/elec-charge"
            f"/price-policy",
        data=data,
        timeout=10,
        headers={"Authorization": f"Bearer {TOKEN}"}
    )
    assert status == 200
    resp_str = json.loads(resp_str)
    assert all([resp_str["data"]["price_info"][0]["term"],
                resp_str["data"]["price_info"][0]["period"],
                resp_str["data"]["price_info"][0]["duration"],
                resp_str["data"]["price_info"][0]["ele_price"]])


@pytest.mark.parametrize('data', [
    {
        "cid": 44,
        "point_id": -1,
        "date_type": "day",
        "start": "2020-07-30 00:00:00",
        "end": "2020-07-30 15:00:00"
    },
])
@pytest.mark.asyncio
async def test_aver_elec_price(data):
    """平均电价和增长率"""
    resp_str, status = await AioHttpUtils().post(
        url=f"{HTTP_PREFIX}/unify-api/elec-charge/elec-charge"
            f"/aver-elec-price",
        data=data,
        timeout=10,
        headers={"Authorization": f"Bearer {TOKEN}"}
    )
    assert status == 200
    resp_str = json.loads(resp_str)
    assert all([resp_str["data"]["this_power"]["charge"],
                resp_str["data"]["this_power"]["kwh"]])


@pytest.mark.parametrize('data', [
    {
        "cid": 118,
        "point_id": -1,
    },
])
@pytest.mark.asyncio
async def test_index_charge(data):
    """首页今日本月电量电费"""
    resp_str, status = await AioHttpUtils().post(
        url=f"{HTTP_PREFIX}/unify-api/elec-charge/elec-charge"
            f"/index-charge",
        data=data,
        timeout=10,
        headers={"Authorization": f"Bearer {TOKEN}"}
    )
    assert status == 200
    resp_str = json.loads(resp_str)
    assert all([resp_str["data"]["today_spvf"]["power"]["p"],
                resp_str["data"]["today_spvf"]["power"]["f"],
                resp_str["data"]["today_spvf"]["power"]["v"]])


@pytest.mark.parametrize('data', [
    {
        "cid_list": [32, 36],
        "date_type": "day",
        "start": "2020-07-30 00:00:00",
        "end": "2020-07-30 23:59:59"
     }
])
@pytest.mark.asyncio
async def test_power_overview_proxy(data):
    """电量电费信息-管理版"""
    resp_str, status = await AioHttpUtils().post(
        url=f"{HTTP_PREFIX}/unify-api/elec-charge/elec-charge"
            f"/power-overview-proxy",
        data=data,
        timeout=10,
        headers={"Authorization": f"Bearer {TOKEN}"}
    )
    assert status == 200
    resp_str = json.loads(resp_str)
    assert all([resp_str["data"]["power_rate"], resp_str["data"]["avg_price"],
               resp_str["data"]["last_charge"], resp_str["data"]["last_power"]])


@pytest.mark.parametrize('data', [
    {
        "cid_list": [32, 36],
        "date_type": "day",
        "start": "2020-07-30 00:00:00",
        "end": "2020-07-30 23:59:59"
    },
    {
        "cid_list": [32, 36],
        "date_type": "month",
        "start": "2020-07-01 00:00:00",
        "end": "2020-07-30 23:59:59"
    }
])
@pytest.mark.asyncio
async def test_power_sort_proxy(data):
    """用电排名-管理版"""
    resp_str, status = await AioHttpUtils().post(
        url=f"{HTTP_PREFIX}/unify-api/elec-charge/elec-charge"
            f"/power-sort-proxy",
        data=data,
        timeout=10,
        headers={"Authorization": f"Bearer {TOKEN}"}
    )
    assert status == 200
    resp_str = json.loads(resp_str)
    assert all([resp_str["data"]["kwh"], resp_str["data"]["charge"],
                resp_str["data"]["price"]])


@pytest.mark.parametrize('data', [
    {
        "cid": 44,
        "storeys": [1, 2, 3],
        "start": "2020-05-01 00:00:00",
        "end": "2021-03-10 23:59:59",
        "product": 4
    }
])
@pytest.mark.asyncio
async def test_kwh_points(data):
    """电量统计-监测点"""
    resp_str, status = await AioHttpUtils().post(
        url=f"{HTTP_PREFIX}/unify-api/elec-charge/elec-charge"
            f"/kwh-points",
        data=data,
        timeout=10,
        headers={"Authorization": f"Bearer {TOKEN}"}
    )
    assert status == 200
    resp_str = json.loads(resp_str)
    assert len(resp_str["data"]["kwh_data"])


@pytest.mark.parametrize('data', [
    {
        "cid": 44,
        "point_list": [439, 440, 441, 442, 443, 444, 445, 446, 447],
        "start": "2021-05-01 00:00:00",
        "end": "2021-05-27 23:59:59"
    }
])
@pytest.mark.asyncio
async def test_kwh_card_level(data):
    """电量统计-监测点"""
    resp_str, status = await AioHttpUtils().post(
        url=f"{HTTP_PREFIX}/unify-api/elec-charge/elec-charge"
            f"/kwh-card-level",
        data=data,
        timeout=10,
        headers={"Authorization": f"Bearer {TOKEN}"}
    )
    assert status == 200
    resp_str = json.loads(resp_str)
    assert all([resp_str["data"]["transformer"],
                resp_str["data"]["feeder"],
                resp_str["data"]["power_dist"]])
