from pot_libs.sanic_api import summary
from unify_api.modules.zhiwei_u import config
from pot_libs.common.components.responses import Success
from unify_api.modules.zhiwei_u.service.warning_operations_service import \
    warning_state_focus_service, warning_state_ignore_service, \
    select_user_service, warning_to_order_service, get_product_service, \
    select_point_service
from unify_api.modules.zhiwei_u.components.warning_operations_cps import \
    SelectUserReq, SelectUserResp, WarningStateIgnoreReq, ProductResp, \
    WarningStateFocusReq, SelecPointReq

# 运维报警


@summary('返回平台')
async def get_product(req) -> ProductResp:
    return await get_product_service(config.PRODUCT)


@summary('平台选择客户')
async def post_select_user(req, body: SelectUserReq) -> SelectUserResp:
    prod_id = body.prod_id
    return await select_user_service(prod_id)


@summary('报警类型 工单类型')
async def get_warning_type(req) -> ProductResp:
    return await get_product_service(config.ERROR_TYPE)


@summary('平台、客户选择监测点')
async def post_select_point(req, body: SelecPointReq) -> SelectUserResp:
    cid = body.cid
    return await select_point_service(cid)


@summary('运维报警状态改变为已忽略')
async def post_warning_state_ignore(req, body: WarningStateIgnoreReq) \
        -> Success:
    ids = body.id
    remark = body.remark
    return await warning_state_ignore_service(ids, remark)


@summary('运维报警 已忽略撤销')
async def post_warning_state_focus(req, body: WarningStateFocusReq) -> Success:
    ids = body.id
    return await warning_state_focus_service(ids)


@summary('运维报警 转为工单')
async def post_warning_to_order(req, body: WarningStateFocusReq) -> Success:
    ids = body.id
    try:
        user_id = req.ctx.user_id
    except:
        user_id = req.json.get("user_id")
    return await warning_to_order_service(ids, user_id, config.W_ORIGIN_AUTO)
