from pot_libs.sanic_api import summary
from pot_libs.logger import log
from unify_api.modules.zhiwei_u.service.select_service import \
    warning_search_service, order_search_service, myself_do_service
from unify_api.modules.zhiwei_u.components.select_cps import \
    WarningSearchReq, WarningSearchResp, OrderSearchReq, OrderSearchResp

# 搜索模块


@summary('运维报警搜索 state表示 0待关注 1 已忽略  w_type 0全部 1丢失 2延迟 3异常')
async def post_warning_search(req, body: WarningSearchReq) -> \
        WarningSearchResp:
    page_size = body.page_size
    page_num = body.page_num
    start = body.start
    end = body.end
    state = body.state
    try:
        user_id = req.ctx.user_id
    except:
        user_id = req.json.get("user_id")
    return await warning_search_service(req.json, start, end, state, user_id,
                                        page_num, page_size)


@summary('运维工单搜索 详情页传工单id')
async def post_order_search(req, body: OrderSearchReq) -> \
        OrderSearchResp:
    page_size = body.page_size
    page_num = body.page_num
    start = body.start
    end = body.end
    try:
        user_id = req.ctx.user_id
    except:
        user_id = req.json.get("user_id")
    return await order_search_service(req.json, start, end, page_num,
                                      page_size, user_id)


@summary('我的待办')
async def post_myself_do(req, body: OrderSearchReq) -> \
        OrderSearchResp:
    page_size = body.page_size
    page_num = body.page_num
    start = body.start
    end = body.end
    try:
        userid = req.ctx.user_id
    except:
        userid = req.json.get("user_id")
    return await myself_do_service(req.json, start, end, page_num,
                                   page_size, userid)



