from pot_libs.mysql_util.mysql_util import MysqlUtil
from pot_libs.settings import SETTING


async def install_sheet_by_cid(cid):
    sql = "select * from install_sheet where cid = %s and is_deleted = 0 " \
          "order by create_time desc"
    async with MysqlUtil(db=SETTING.mysql_zhiwei_u_db) as conn:
        install_list = await conn.fetchall(sql, args=(cid,))
    return install_list


async def install_sheet_by_sheet_id(sheet_id):
    sql = "select * from install_sheet where id = %s and is_deleted = 0"
    async with MysqlUtil(db=SETTING.mysql_zhiwei_u_db) as conn:
        install_dic = await conn.fetchone(sql, args=(sheet_id,))
    return install_dic


async def install_sheet_by_sheet_ids(sheet_id_list):
    sql = "select * from install_sheet where id in %s and is_deleted = 0"
    async with MysqlUtil(db=SETTING.mysql_zhiwei_u_db) as conn:
        install_list = await conn.fetchall(sql, args=(tuple(sheet_id_list),))
    return install_list


async def update_install_sheet(doc_name, sheet_id):
    sql = "UPDATE install_sheet set doc_name = %s where id = %s " \
          "and is_deleted = 0"
    async with MysqlUtil(db=SETTING.mysql_zhiwei_u_db) as conn:
        affect_num = await conn.execute(sql, args=(doc_name, sheet_id))
    return affect_num


async def delete_install_sheet(sheet_id):
    """逻辑删除"""
    sql = "UPDATE install_sheet set is_deleted = 1 where id = %s"
    async with MysqlUtil(db=SETTING.mysql_zhiwei_u_db) as conn:
        affect_num = await conn.execute(sql, args=(sheet_id,))
    return affect_num


async def data_warn_record_by_state(state):
    sql = "select * from data_warn_record where state = %s"
    async with MysqlUtil(db=SETTING.mysql_zhiwei_u_db) as conn:
        warn_record_list = await conn.fetchall(sql, args=(state,))
    return warn_record_list


async def data_order_record_by_state(state):
    sql = "select * from data_order_record where state = %s"
    async with MysqlUtil(db=SETTING.mysql_zhiwei_u_db) as conn:
        order_record_list = await conn.fetchall(sql, args=(state,))
    return order_record_list
