import ujson
from sanic import Blueprint, response
from sanic.views import HTTPMethodView

from pot_libs.aiohttp_util.aiohttp_utils import AioHttpUtils
from pot_libs.logger import log
from pot_libs.settings import SETTING
from unify_api.modules.users.procedures.jwt_user import jwt_user
from unify_api.modules.common.dao.common_dao import load_user_lang
from unify_api.modules.users.procedures.login_pds import wechat_login, \
    web_login, third_login, web_third_login, app_login, validation_login

auth_blueprint = Blueprint("auth", url_prefix="/unify-api")


class AuthView(HTTPMethodView):
    """jwt auth, 也是登录逻辑"""

    async def post(self, request, *args, **kwargs):
        args = request.json
        log.info(f"转发authenticate request.json = {request.json}")
        client_name = args.get("client_name")
        client_lang = args.get("lang")
        host = request.host
        if not client_name:
            return response.json({"code": 40001, "data": None,
                                  "message": "miss param client_name"},
                                 status=200)
        if args.get("user_name") == "balabala" and args.get(
                "password") == "balabala":
            resp_str, status_code = await AioHttpUtils().post(
                SETTING.auth_url,
                {"user_name": "balabala", "password": "balabala",
                 "client_name": client_name, "db": SETTING.mysql_db},
                timeout=50,
            )
            print(f"resp_str = {resp_str} status={status_code}")
            return response.json(ujson.loads(resp_str), status=200)

        user_id = jwt_user(request)
        lang = await load_user_lang(user_id)
        if not lang:
            lang = client_lang

        if client_name == "wechat":
            # 微信登录逻辑
            status_code, resp_body = await wechat_login(args, host)
            if status_code == 401:
                # 自定义状态码
                resp_body["code"] = 40001
        elif client_name == "web":
            status_code, resp_body = await web_login(args, host, lang)
            if status_code == 401:
                resp_body["code"] = 40001
        elif client_name == "script":
            # 第三方脚本登录
            status_code, resp_body = await third_login(args, host, lang)
            if status_code == 401:
                resp_body["code"] = 40001
        elif client_name == "app":
            # app登录逻辑
            status_code, resp_body = await app_login(args, host)
            if status_code == 401:
                # 自定义状态码
                resp_body["code"] = 40001
        elif client_name == "password":
            # 第三方用户名密码登录
            status_code, resp_body = await web_third_login(args, host, lang)
            if status_code == 401:
                resp_body["code"] = 40001
        elif client_name == "validation":
            # 手机验证码登录
            status_code, resp_body = await validation_login(args, host, lang)
            if status_code == 401:
                resp_body["code"] = 40001
        else:
            # 不存在的客户端
            status_code, resp_body = 401, {"code": 40001, "data": None,
                                           "message": "non-existent client"}
        log.info(f"AuthView client_name:{client_name} "
                 f"status_code:{status_code}, resp_body:{resp_body}")
        return response.json(resp_body, status=200)


auth_blueprint.add_route(AuthView.as_view(), "/auth")
