from pot_libs.sanic_api import summary
from pot_libs.utils.exc_util import ParamException
from unify_api.modules.ulock.components.lock_cps import BlReq, BlResp, LiResp, \
    LiReq
from unify_api.modules.ulock.dao.lock_dao import u_lock_by_mac, u_lock_by_id
from unify_api.modules.ulock.procedures.lock_pds import lock_required


@summary('配电柜锁-根据id获取锁')
@lock_required()
async def post_box_lock(req, body: BlReq) -> BlResp:
    lock_id = body.id
    lock_dic = await u_lock_by_id(lock_id)
    if not lock_dic:
        raise ParamException(message="mac can not find data")
    secret_key = lock_dic.get("secret_key")
    secret_key_list = secret_key.split(",")
    secret_key_list = list(map(int, secret_key_list))

    password = lock_dic.get("password")
    password_list = password.split(",")
    password_list = list(map(int, password_list))
    return BlResp(
        secret_key=secret_key_list,
        password=password_list
    )


@summary('配电柜锁-根据mac获取id')
async def post_lock_id(req, body: LiReq) -> LiResp:
    """获取id给前端, 不校验user开锁权限"""
    mac = body.mac
    lock_dic = await u_lock_by_mac(mac)
    if not lock_dic:
        raise ParamException(message="mac can not find data")
    return LiResp(
        id=lock_dic.get("id")
    )
