from dataclasses import dataclass

from pot_libs.sanic_api import Model
from pot_libs.sanic_api.column import Float, Str, List, Int, Dict


@dataclass
class AlgorithmInput(Model):
    point_id: float = Float("监测点id").eg(21)
    req_date: str = Str("分析日期").eg("2020-11-30")
    detail: int = Int("内部详细的算法识别数据还是不详细的, 1是详细 0 -不详细").eg(1)


@dataclass
class RunPeriodtem(Model):
    time_period: list = List("运行周期").items(Str("运行周期").eg("8:00"))
    running_devices: list = List("运行设备列表").items(Str("运行设备").eg("电冰箱"))


@dataclass
class RunTimeItem(Model):
    device: str = Str("设备").eg("冰箱")
    run_time: float = Float("运行时长, 单位小时").eg(1)
    pchange_times: float = Float("功率波动次数").eg(1)
    power: float = Float("用电 单位kwh").eg(100)


@dataclass
class ElectricActionItem(Model):
    action_name: str = Str("动作名").eg("开启电冰箱")
    action_time: list = Str("动作发生时间").eg("2020-12-01 08:00:00")


@dataclass
class AlgorithmOutput(Model):
    time_slot: list = List("横轴").items(Str("时间, 1分钟一个点").eg("08:00"))
    p_slot: list = List("纵轴").items(Float("功率大小").eg("12"))
    electric_actions: list = List("用电设备").items(ElectricActionItem)
    run_period_list: list = List("运行时段").items(RunPeriodtem)
    runtime_list: list = List("运行时间统计").items(RunTimeItem)
    electric_action_groups: list = List("15min报警识别统计列表")


@dataclass
class WcReq(Model):
    point_id: float = Float("监测点id").eg(391)
    req_date: str = Str("分析日期").eg("2021-03-30")
    product: int = Int("product 1-知电 2-安电 3-安电管理 4-识电U").eg(4)


@dataclass
class WcResp(Model):
    time_slot: list = List("横轴").items(Str("时间, 1分钟一个点").eg("08:00"))
    p_slot: list = List("纵轴").items(Float("功率大小").eg("12"))
    electric_actions: dict = Dict("用电设备").eg(
        {"04:02": [{"type": "开启电冰箱", "value": "大功率电器"}]})


@dataclass
class AbcResp(Model):
    power_swing: dict = Dict("功率波动").eg(
        {"0-300": 0, "300-500": 0, "500-800": 0, "800-1000": 0, "1000": 0})
    safety_eval: dict = Dict("安全评价").eg(
        {"first_alarm_cnt": "一级报警数",
         "second_alarm_cnt": "二级报警数",
         "third_alarm_cnt": "三级报警数",
         "alarm_score": "报警分数",
         "electric_use_score": "用电安全指数",
         })
    behavior_illegal_app: list = List("违规电器行为统计").eg(
        [{"name": "电动车电池", "value": 2}, {"name": "热得快", "value": 1}])


@dataclass
class AbcReq(Model):
    point_id: float = Float("监测点id").eg(391)
    product: int = Int("product 1-知电 2-安电 3-安电管理 4-识电U").eg(4)
