# -*- coding:utf-8 -*-
"""
DATE：2024/12/30 10:15

"""
from pot_libs.sanic_api import summary
from unify_api.modules.inv_eval.service.ems_srv import inv_eval
from unify_api.modules.inv_eval.components.ems_cps import (
    EmsInvEvalReq, EmsInvEvalRsp
)


@summary("投资汇报测算")
async def post_inv_eval(req, body: EmsInvEvalReq) -> EmsInvEvalRsp:
    try:
        load_year = body.load_year or 0
        imp_load_year = body.imp_load_year or 0
        es_cost = body.es_cost or 0
        pv_cost = body.pv_cost or 0
        ele_price = body.ele_price or 0
        cg_cost = body.cg_cost or 0
        sale_price = body.sale_price or 0
        sale_cost = body.sale_cost or 0
        work_hours_year = body.work_hours_year or 0
        sun_hrs_year = body.sun_hrs_year or 0
        max_load = body.max_load or 0
        min_load = body.min_load or 0
        pv_area = body.pv_area or 0
        pv_eff = body.pv_eff or 0
        max_invest_year = body.max_invest_year or 0
        pv_limit = body.pv_limit or 0
        sale_limit = body.sale_limit or 0
        cg_eff = body.cg_eff or 0.8
        es_eff = body.es_eff or 0.8
        goal = body.goal
        d_params = dict(load_year=load_year, imp_load_year=imp_load_year,
                        es_cost=es_cost, pv_cost=pv_cost, ele_price=ele_price,
                        cg_cost=cg_cost, work_hours_year=work_hours_year,
                        max_invest_year=max_invest_year,
                        cg_eff=cg_eff, es_eff=es_eff,
                        sun_hrs_year=sun_hrs_year,
                        max_load=max_load, min_load=min_load,
                        pv_eff=pv_eff, pv_area=pv_area, pv_limit=pv_limit,
                        sale_price=sale_price, sale_limit=sale_limit,
                        sale_cost=sale_cost, goal=goal)
        cfg = await inv_eval(d_params)
        return EmsInvEvalRsp(pv=cfg.get("pv", 0), es=cfg.get("es", 0),
                             cg=cfg.get("cg", 0),
                             income_year=cfg.get("income_year", 0),
                             irr=cfg.get("irr", 0))
    except Exception as e:
        return EmsInvEvalRsp(pv=0, es=0, cg=0, income_year=0, irr=0)
