# -*- coding:utf-8 -*-
"""
DATE：2024/12/30 13:41

"""
from unify_api.algo.ems.ems import EnergyModel


async def inv_eval(d_params):
    load_year = d_params["load_year"]
    imp_load_year = d_params["imp_load_year"]
    es_cost = d_params["es_cost"]
    ele_price = d_params["ele_price"]
    cg_cost = d_params["cg_cost"]
    work_hours_year = d_params["work_hours_year"]
    max_invest_year = d_params["max_invest_year"]
    cg_eff = d_params["cg_eff"]
    es_eff = d_params["es_eff"]
    pv_cost = d_params["pv_cost"]
    sun_hrs_year = d_params["sun_hrs_year"]
    max_load = d_params["max_load"]
    min_load = d_params["min_load"]
    pv_eff = d_params["pv_eff"]
    pv_area = d_params["pv_area"]
    pv_limit = d_params["pv_limit"]
    sale_price = d_params["sale_price"]
    sale_limit = d_params["sale_limit"]
    sale_cost = d_params["sale_cost"]
    goal = d_params["goal"]

    rlt_cfg = {}
    ems_model = EnergyModel(dict(load_year=load_year,
                                 imp_load_year=imp_load_year,
                                 es_cost=es_cost, ele_price=ele_price,
                                 cg_cost=cg_cost,
                                 work_hours_year=work_hours_year,
                                 max_invest_year=max_invest_year,
                                 cg_eff=cg_eff, es_eff=es_eff))
    if goal == 1:
        rlt_cfg = ems_model.cri_calculate()

    elif goal == 2:
        rlt_cfg = ems_model.all_calculate(dict(pv_cost=pv_cost,
                                               sun_hrs_year=sun_hrs_year,
                                               max_load=max_load,
                                               min_load=min_load,
                                               pv_eff=pv_eff,
                                               pv_area=pv_area,
                                               pv_limit=pv_limit))
    elif goal == 3:
        rlt_cfg = ems_model.sale_calculate(dict(pv_cost=pv_cost,
                                                sun_hrs_year=sun_hrs_year,
                                                max_load=max_load,
                                                min_load=min_load,
                                                pv_eff=pv_eff,
                                                pv_area=pv_area,
                                                pv_limit=pv_limit,
                                                sale_price=sale_price,
                                                sale_limit=sale_limit,
                                                sale_cost=sale_cost))
    elif goal == 4:
        rlt_cfg = ems_model.com_strategy(dict(pv_cost=pv_cost,
                                              sun_hrs_year=sun_hrs_year,
                                              max_load=max_load,
                                              min_load=min_load,
                                              pv_eff=pv_eff,
                                              pv_area=pv_area,
                                              pv_limit=pv_limit,
                                              sale_price=sale_price,
                                              sale_limit=sale_limit,
                                              sale_cost=sale_cost))

    return rlt_cfg
