# -*- coding:utf-8 -*-
"""
DATE：2024/8/5 17:41

"""
from dataclasses import dataclass
from pot_libs.sanic_api import Model
from pot_libs.sanic_api.column import Opt, Int, List, Str


@dataclass
class SessionHisReq(Model):
    page_num: int = Opt(Int("页码").eg(1))
    page_size: int = Opt(Int("条数").eg(10))


@dataclass
class SessionInfo(Model):
    id: int = Opt(Int("会话ID").eg(1))
    title: str = Opt(Str("会话标题").eg("未命名会话"))
    create_time: str = Opt(Str("创建时间").eg("2023-12-08 00:54"))


@dataclass
class SessionHisRsp(Model):
    sessions: list = List("会话列表").items(SessionInfo)
