# -*- coding:utf-8 -*-
"""
DATE：2024/12/30 11:43

"""
from dataclasses import dataclass
from pot_libs.sanic_api import Model
from pot_libs.sanic_api.column import Opt, Float, Int, List, Str


@dataclass
class EmsInvEvalReq(Model):
    load_year: float = Opt(Float("年均负荷(kw)").eg(4500))
    imp_load_year: float = Opt(Float("年均重要负荷(kw)").eg(2000))
    es_cost: float = Opt(Float("储能成本  元/kw").eg(1500))
    pv_cost: float = Opt(Float("年均负荷(kw)").eg(800))
    ele_price: float = Opt(Float("电价").eg(1.4))
    cg_cost: float = Opt(Float("煤制气成本加上燃料成本 元/kw").eg(8000))
    sale_price: float = Opt(Float("售电价格").eg(1000))
    sale_cost: float = Opt(Float("售电成本价格").eg(0.5))
    work_hours_year: float = Opt(Float("每年的工作时长").eg(2000))
    sun_hrs_year: float = Opt(Float("每年的光照时长").eg(1300))
    max_load: float = Opt(Float("").eg(6000))
    min_load: float = Opt(Float("").eg(2400))
    pv_area: float = Opt(Float("光伏建设最大面积").eg(50000))
    pv_eff: float = Opt(Float("光伏效率").eg(0.8))
    max_invest_year: float = Opt(Float("当前投资收益最大限制").eg(5))
    pv_limit: float = Opt(Float("光伏最大限制").eg(7000))
    sale_limit: float = Opt(Float("售电限制kw*h").eg(100000))
    cg_eff: float = Opt(Float("煤制气效率").eg(0.8))
    es_eff: float = Opt(Float("充电效率").eg(0.8))
    goal: int = Int("1保重要负荷2保所有负荷3可联网售电4综合成本最优").eg(1)


@dataclass
class EmsInvEvalRsp(Model):
    pv: float = Opt(Float("光伏配置").eg(4500))
    es: float = Opt(Float("储能配置").eg(4500))
    cg: float = Opt(Float("煤制气").eg(4500))
    income_year: float = Opt(Float("年收益").eg(4500))
    total_inv_cost: float = Opt(Float("总投资成本").eg(4500))
    irr: float = Opt(Float("投资回报率").eg(0.1))
