from pot_libs.mysql_util.mysql_util import MysqlUtil


async def tc_by_inline_id(inline_id):
    async with MysqlUtil() as conn:
        sql = "select inlid, tc_runtime, cid cid" \
              " from inline where inlid=%s;"
        inline = await conn.fetchone(sql, args=(inline_id,))
    return inline


async def price_policy_by_cid(cid):
    sql = "select `price_md`, `price_tc`, `price_f` from `price_policy` " \
          "where `cid`=%s;"
    async with MysqlUtil() as conn:
        price_policy = await conn.fetchone(sql, args=(cid,))
    return price_policy


async def pids_by_cid(cid):
    sql = "SELECT pid from `point` WHERE cid = %s "
    async with MysqlUtil() as conn:
        point_info = await conn.fetchall(sql=sql, args=(cid,))
    point_list = [point.get("pid") for point in point_info]
    return point_list


async def get_economic_operations(inline_id, month):
    sql = "select `kpi_x`, `save_charge`, `mean_load_factor` " \
          "from `algo_economic_operation_result` " \
          "where `inlid` = %s and `month` = %s"
    async with MysqlUtil() as conn:
        economic_operations = await conn.fetchall(sql, args=(inline_id, month))
    return economic_operations
