from unify_api.constants import SDU_ALARM_LIST
from pot_libs.mysql_util.mysql_util import MysqlUtil


async def load_alarm_cnt_sdu(cids):
    sql = f"select count(1) doc_count from point_1min_event " \
          f"where cid in %s and importance in (1, 2, 3) " \
          f"and event_type in {tuple(SDU_ALARM_LIST)}"
    async with MysqlUtil() as conn:
        data = await conn.fetchone(sql, args=(cids,))
    return data["doc_count"] or 0
