# -*- coding:utf-8 -*-
#
# Author:jing
# Date: 2020/7/8
import typing
from dataclasses import dataclass

from pot_libs.common.components.fields import Cid
from pot_libs.sanic_api import Model
from pot_libs.sanic_api.column import List, Str, Opt, Int
from unify_api.utils.response_code import DbErr, ParamErr


@dataclass
class ListPointRequest(Model):
    cid: Cid
    is_power_equipment: int = Opt(Int('是否动力设备 0-否 1-是'))


@dataclass
class CommonLocation(Model):
    item: str = Str('item').eg('A相')
    location_id: int = Int('location_id')


@dataclass
class CommonPoint(Model):
    name: str = Str('监测点名称').eg('母排')  # unique id
    point_id: int = Opt(Int('point_id'))
    locations: typing.List = Opt(List('location_id').items(CommonLocation))
    add_to_company: int = Int('add_to_company 是否算入工厂总电量，默认为1，即默认算入工厂总电量').eg(1)


@dataclass
class Inline(Model):
    inline_id: int = Int("进线id").eg(48)
    name: str = Str("进线名").eg("35kV总进线")


@dataclass
class ListPointResponse(Model, DbErr):
    points: typing.List[CommonPoint] = List().items(CommonPoint)
    inlines: typing.List[Inline] = List().items(Inline)
    power_show_all: int = Int("电量电费页面全部按钮是否显示，0-不显示 1-显示").eg(1)


@dataclass
class LsRep(Model):
    storey_list: list = List("楼层").eg({"storey_id": 1, "storey_name": "261栋"})


@dataclass
class LtpRep(Model):
    tsp_list: list = List("tsp监测点").eg({"tsp_id": 1, "name": "一号大门"})


@dataclass
class ListPointResponse(Model, DbErr, ParamErr):
    points: typing.List[CommonPoint] = List().items(CommonPoint)
    inlines: typing.List[Inline] = List().items(Inline)
    power_show_all: int = Int("电量电费页面全部按钮是否显示，0-不显示 1-显示").eg(1)


@dataclass
class LplResp(Model):
    inline: list = List("进线").eg([{"name": "10kV进线", "id": 74}])
    transformer: list = List("变压器").eg([{"name": "1#变压器", "id": 74}])
    feeder: list = List("馈线").eg([{"name": "1#馈线", "id": 74}])
    power_dist: list = List("配电").eg([{"name": "1#配电", "id": 74}])
    device: list = List("设备级").eg([{"name": "1#设备", "id": 74}])
    power_show_all: int = Int("电量电费页面全部按钮是否显示，0-不显示 1-显示").eg(1)


@dataclass
class LpiResp(Model):
    inlines: list = List("进线").eg([{"name": "10kV进线", "inline_id": 74}])
