from pot_libs.mysql_util.mysql_util import MysqlUtil


async def get_scope_event_by_event_id(event_id):
    """
    获取录波报警详情
    :param event_id:
    :return:
    """
    sql = f"""
        select pe.*,m.sid from point_1min_event pe
        left join monitor m on pe.mtid = m.mtid
        where pe.event_id =%s
    """

    async with MysqlUtil() as conn:
        result = await conn.fetchone(sql, args=(event_id,))
    return result


async def get_scope_detail_by_pid(pid, event_datetime):
    """
    获取录波详情
    :param pid:
    :param event_datetime:
    :return:
    """
    sql = f"""
        select * from point_1min_scope
        where pid =%s and create_time=%s
    """

    async with MysqlUtil() as conn:
        result = await conn.fetchone(sql, args=(pid, event_datetime))
    return result


async def get_threshold_by_mtid(mtid):
    """
    根据mtid获取阈值
    :param mtid:
    :return:
    """
    sql = f"""
        select threshold from soe_config_record  scr
        left join location l on  scr.lid = l.lid
        where l.ad_type='residual_current' and scr.etype='overResidualCurrent'
        and l.mtid=%s
    """
    async with MysqlUtil() as conn:
        threshold = await conn.fetch_value(sql, args=(mtid,))
    return threshold


async def get_scope_url_by_pid(mtid, start_dt, end_dt):
    """
    获取录波详情
    :param pid:
    :param event_datetime:
    :return:
    """
    sql = f"""
        SELECT
            url, 
        DATE_FORMAT(create_time, '%Y-%m-%d %H:%i:%s') datetime
        FROM
            point_1min_scope 
        WHERE
            create_time > '{start_dt}' 
            AND create_time < '{end_dt}' 
            AND mtid = {mtid} 
            AND scope_g = '2s'

    """

    async with MysqlUtil() as conn:
        result = await conn.fetchall(sql,)
    return result


async def get_e_type_by_event_type(event_type):
    sql = f"""
        SELECT 
        `name` type
        FROM
            event_type 
        WHERE
            e_type = '{event_type}'
        
            """

    async with MysqlUtil() as conn:
        result = await conn.fetchone(sql,)
    return result
