# /usr/bin/env python
# -*- coding: UTF-8 -*-

import numpy as np

from break_fault import break_inside, break_outside
from decom_ABC import dep_res
from sing_earth import earth_outside
from three_short import three_short_inside, three_short_outside
from two_short import two_short_inside, two_short_outside


def fault_reg(data, ctnum):
    cov_dict, dep_final, angles = dep_res(data, ctnum)
    conv_data = {}

    if ctnum == 3:
        length = len(data['ia'])
        points_len = np.floor(length / 80.0)
        for each_key in ['ia', 'ib', 'ic', 'ua', 'ub', 'uc']:
            cov_dict['cov_' + each_key] = cov_dict['cov_' + each_key].tolist()
            conv_data[each_key] = [max(data[each_key][i * 80:(i + 1) * 80]) for i in range(int(points_len))]
        sing_earth_outside_flag, phrase_out, position_out = earth_outside(conv_data, 3)
        if sing_earth_outside_flag > 0:
            return sing_earth_outside_flag, phrase_out, position_out
        sing_earth_outside_flag, phrase_out, position_out = earth_outside(conv_data, 3)
        if sing_earth_outside_flag > 0:
            return sing_earth_outside_flag, phrase_out, position_out
        sing_earth_inside_flag, phrase_in, position_in = break_inside(conv_data, 3)
        if sing_earth_inside_flag > 0:
            return sing_earth_inside_flag, phrase_in, position_in
        sing_earth_outside_flag, phrase_out, position_out = break_outside(conv_data, 3)
        if sing_earth_outside_flag > 0:
            return sing_earth_outside_flag, phrase_out, position_out
        sing_earth_inside_flag, phrase_in, position_in = three_short_inside(conv_data, 3)
        if sing_earth_inside_flag > 0:
            return sing_earth_inside_flag, phrase_in, position_in
        sing_earth_outside_flag, phrase_out, position_out = three_short_outside(conv_data, 3)
        if sing_earth_outside_flag > 0:
            return sing_earth_outside_flag, phrase_out, position_out
        sing_earth_inside_flag, phrase_in, position_in = three_short_inside(conv_data, 3)
        if sing_earth_inside_flag > 0:
            return sing_earth_inside_flag, phrase_in, position_in
        sing_earth_outside_flag, phrase_out, position_out = two_short_inside(conv_data, 3)
        if sing_earth_outside_flag > 0:
            return sing_earth_outside_flag, phrase_out, position_out
        sing_earth_outside_flag, phrase_out, position_out = two_short_outside(conv_data, 3)
        if sing_earth_outside_flag > 0:
            return sing_earth_outside_flag, phrase_out, position_out
        else:
            return 0,"E","无故障"
    else:
        length = len(data['ibc'])
        points_len = np.floor(length / 80.0)
        for each_key in ['iab', 'ibc', 'uab', 'ubc']:
            cov_dict['cov_' + each_key] = cov_dict['cov_' + each_key].tolist()
            conv_data[each_key] = [max(data[each_key][i * 80:(i + 1) * 80]) for i in range(int(points_len))]
        sing_earth_outside_flag, phrase_out, position_out = earth_outside(conv_data, 2)
        if sing_earth_outside_flag > 0:
            return sing_earth_outside_flag, phrase_out, position_out
        sing_earth_outside_flag, phrase_out, position_out = earth_outside(conv_data, 2)
        if sing_earth_outside_flag > 0:
            return sing_earth_outside_flag, phrase_out, position_out
        sing_earth_inside_flag, phrase_in, position_in = break_inside(conv_data, 2)
        if sing_earth_inside_flag > 0:
            return sing_earth_inside_flag, phrase_in, position_in
        sing_earth_outside_flag, phrase_out, position_out = break_outside(conv_data, 2)
        if sing_earth_outside_flag > 0:
            return sing_earth_outside_flag, phrase_out, position_out

        sing_earth_outside_flag, phrase_out, position_out = two_short_inside(conv_data, 2)
        if sing_earth_outside_flag > 0:
            return sing_earth_outside_flag, phrase_out, position_out
        sing_earth_outside_flag, phrase_out, position_out = two_short_outside(conv_data, 2)
        if sing_earth_outside_flag > 0:
            return sing_earth_outside_flag, phrase_out, position_out
        else:
            return 0,"E","无故障"